#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_7" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed
# !!!No Direct PII

#'# Direct PII-team: Encode field team names
# !!!No Direct PII-team

#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!No small locations

#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 


# Top code number of animals/products
quantile(na.exclude(mydata$s7q1)[na.exclude(mydata$s7q1)!=999999], probs = 0.995)
mydata <- top_recode ("s7q1", break_point=4, missing=c(888, 999999))


quantile(na.exclude(mydata$s7q2)[na.exclude(mydata$s7q2)!=999999], probs = 0.995)
mydata <- top_recode ("s7q2", break_point=1, missing=c(888, 999999)) 

quantile(na.exclude(mydata$s7q3)[na.exclude(mydata$s7q3)!=999999], probs = 0.995)
mydata <- top_recode ("s7q3", break_point=6, missing=c(888, 999999)) 

quantile(na.exclude(mydata$s7q7)[na.exclude(mydata$s7q7)!=999999], probs = 0.995)
mydata <- top_recode ("s7q7", break_point=2200, missing=c(888, 999999)) 

quantile(na.exclude(mydata$s7q15)[na.exclude(mydata$s7q15)!=999999], probs = 0.995)
mydata <- top_recode ("s7q15", break_point=3, missing=c(888, 999999))

quantile(na.exclude(mydata$s7q17)[na.exclude(mydata$s7q17)!=999999], probs = 0.995)
mydata <- top_recode ("s7q17", break_point=1, missing=c(888, 999999))

quantile(na.exclude(mydata$s7q20)[na.exclude(mydata$s7q20)!=999999], probs = 0.995)
mydata <- top_recode ("s7q20", break_point=14, missing=c(888, 999999))

quantile(na.exclude(mydata$s7q21)[na.exclude(mydata$s7q21)!=999999], probs = 0.995)
mydata <- top_recode ("s7q21", break_point=2, missing=c(888, 999999))

quantile(na.exclude(mydata$s7q22)[na.exclude(mydata$s7q22)!=999999], probs = 0.995)
mydata <- top_recode ("s7q22", break_point=10, missing=c(888, 999999))

quantile(na.exclude(mydata$s7q31)[na.exclude(mydata$s7q31)!=999999], probs = 0.995)
mydata <- top_recode ("s7q31", break_point=19, missing=c(888, 999999))

quantile(na.exclude(mydata$s7q33)[na.exclude(mydata$s7q33)!=999999], probs = 0.995)
mydata <- top_recode ("s7q33", break_point=8, missing=c(888, 999999))

quantile(na.exclude(mydata$s7q36)[na.exclude(mydata$s7q36)!=999999], probs = 0.995)
mydata <- top_recode ("s7q36", break_point=59, missing=c(888, 999999))

quantile(na.exclude(mydata$s7q37)[na.exclude(mydata$s7q37)!=999999], probs = 0.995)
mydata <- top_recode ("s7q37", break_point=5, missing=c(888, 999999))

quantile(na.exclude(mydata$s7q38)[na.exclude(mydata$s7q38)!=999999], probs = 0.995)
mydata <- top_recode ("s7q38", break_point=1, missing=c(888, 999999))

quantile(na.exclude(mydata$s7q42)[na.exclude(mydata$s7q42)!=999999], probs = 0.995)
mydata <- top_recode ("s7q42", break_point=2000, missing=c(888, 999999))

quantile(na.exclude(mydata$s7q46)[na.exclude(mydata$s7q46)!=999999], probs = 0.995)
mydata <- top_recode ("s7q46", break_point=49, missing=c(888, 999999))

quantile(na.exclude(mydata$s7q48)[na.exclude(mydata$s7q48)!=999999], probs = 0.995)
mydata <- top_recode ("s7q48", break_point=48, missing=c(888, 999999))



# Top code high income/value/expenses to the 99.5 percentile

percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q6)[na.exclude(mydata$s7q6)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q6", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q9)[na.exclude(mydata$s7q9)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q9", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q12)[na.exclude(mydata$s7q12)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q12", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q16)[na.exclude(mydata$s7q16)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q16", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q19)[na.exclude(mydata$s7q19)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q19", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q28)[na.exclude(mydata$s7q28)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q28", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q32)[na.exclude(mydata$s7q32)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q32", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q35)[na.exclude(mydata$s7q35)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q35", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q41)[na.exclude(mydata$s7q41)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q41", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q42c)[na.exclude(mydata$s7q42c)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q42c", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q44)[na.exclude(mydata$s7q44)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q44", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q47)[na.exclude(mydata$s7q47)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q47", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q50)[na.exclude(mydata$s7q50)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q50", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q8)[na.exclude(mydata$s7q8)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q8", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q10)[na.exclude(mydata$s7q10)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q10", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q14)[na.exclude(mydata$s7q14)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q14", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q18)[na.exclude(mydata$s7q18)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q18", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q26)[na.exclude(mydata$s7q26)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q26", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q30)[na.exclude(mydata$s7q30)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q30", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q34)[na.exclude(mydata$s7q34)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q34", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q43)[na.exclude(mydata$s7q43)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q43", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q45)[na.exclude(mydata$s7q45)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q45", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s7q46)[na.exclude(mydata$s7q46)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s7q46", break_point=percentile_99.5, missing=999999)


#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!No Indirect PII - Categorical


#'# Matching and crosstabulations: Run automated PII check 
# !!! Insufficient demographic data


#'# Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("s7q1whynoresponse",
               "s7q2whynoresponse",
               "s7q3whynoresponse",
               "s7q4whynoresponse",
               "s7q5other",
               "s7q5whynoresponse",
               "s7q6whynoresponse",
               "s7q7whynoresponse",
               "s7q8whynoresponse",
               "s7q9whynoresponse",
               "s7q10whynoresponse",
               "s7q11whynoresponse",
               "s7q12whynoresponse",
               "s7q13whynoresponse",
               "s7q14whynoresponse",
               "s7q15whynoresponse",
               "s7q16whynoresponse",
               "s7q17whynoresponse",
               "s7q18whynoresponse",
               "s7q19whynoresponse",
               "s7q20whynoresponse",
               "s7q21whynoresponse",
               "s7q22whynoresponse",
               "s7q23whynoresponse",
               "s7q24other",
               "s7q24whynoresponse",
               "s7q25whynoresponse",
               "s7q26whynoresponse",
               "s7q27whynoresponse",
               "s7q28whynoresponse",
               "s7q29whynoresponse",
               "s7q30whynoresponse",
               "s7q31whynoresponse",
               "s7q32whynoresponse",
               "s7q33whynoresponse",
               "s7q34whynoresponse",
               "s7q35whynoresponse",
               "s7q36whynoresponse",
               "s7q37whynoresponse",
               "s7q38whynoresponse",
               "s7q39whynoresponse",
               "s7q40other",
               "s7q40whynoresponse",
               "s7q41whynoresponse",
               "s7q42bwhynoresponse",
               "s7q42cwhynoresponse",
               "s7q42whynoresponse",
               "s7q43whynoresponse",
               "s7q44whynoresponse",
               "s7q45whynoresponse",
               "s7q46whynoresponse",
               "s7q47whynoresponse",
               "s7q48whynoresponse",
               "s7q48awhynoresponse",
               "s7q49whynoresponse",
               "s7q50whynoresponse")

report_open (list_open_ends = open_ends)



# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata$s7q40other[798] <- "Everyday income from [Wholesale and retail trade]"
mydata$s7q40other[1501] <- "[language]"
mydata$s7q42cwhynoresponse[1570] <- "Just the son who in Manila right is the one who knows the price of what he earned for the [activity]."

#'# GPS data: Displace
# !!!No GPS data

#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
