#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_10" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)

#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed
# !!!No Direct PII

#'# Direct PII-team: Encode field team names
# !!!No Direct PII-team

#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!No small locations

#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 


# Top code high income to the 99.5 percentile

percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q2)[na.exclude(mydata$s10q2)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q2", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q3)[na.exclude(mydata$s10q3)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q3", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q5)[na.exclude(mydata$s10q5)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q5", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q6)[na.exclude(mydata$s10q6)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q6", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q8)[na.exclude(mydata$s10q8)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q8", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q9)[na.exclude(mydata$s10q9)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q9", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q11)[na.exclude(mydata$s10q11)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q11", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q12)[na.exclude(mydata$s10q12)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q12", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q14)[na.exclude(mydata$s10q14)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q14", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q15)[na.exclude(mydata$s10q15)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q15", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q17)[na.exclude(mydata$s10q17)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q17", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q18)[na.exclude(mydata$s10q18)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q18", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q20)[na.exclude(mydata$s10q20)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q20", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q21)[na.exclude(mydata$s10q21)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q21", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q23)[na.exclude(mydata$s10q23)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q23", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q25)[na.exclude(mydata$s10q25)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q25", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q26)[na.exclude(mydata$s10q26)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q26", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q27)[na.exclude(mydata$s10q27)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q27", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q29)[na.exclude(mydata$s10q29)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q29", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q31)[na.exclude(mydata$s10q31)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q31", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q32)[na.exclude(mydata$s10q32)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q32", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q33)[na.exclude(mydata$s10q33)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q33", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q35)[na.exclude(mydata$s10q35)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q35", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q37)[na.exclude(mydata$s10q37)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q37", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q38)[na.exclude(mydata$s10q38)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q38", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q39)[na.exclude(mydata$s10q39)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q39", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q41)[na.exclude(mydata$s10q41)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q41", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q43)[na.exclude(mydata$s10q43)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q43", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q44)[na.exclude(mydata$s10q44)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q44", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q45)[na.exclude(mydata$s10q45)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q45", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s10q47)[na.exclude(mydata$s10q47)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s10q47", break_point=percentile_99.5, missing=999999)


#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("s10q1",
                  "s10q4",
                  "s10q7",
                  "s10q10",
                  "s10q13",
                  "s10q16",
                  "s10q19",
                  "s10q22",
                  "s10q24",
                  "s10q28",
                  "s10q30",
                  "s10q34",
                  "s10q36",
                  "s10q40",
                  "s10q46")
capture_tables (indirect_PII)

# Recode those with very specific values. 
# !!!No specific values

#'# Matching and crosstabulations: Run automated PII check 
# !!! Insufficient demographic data

#'# Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("s10q1_why",
               "s10q2_why",
               "s10q3_why",
               "s10q4_why",
               "s10q5_why",
               "s10q6_why",
               "s10q7_why",
               "s10q8_why",
               "s10q9_why",
               "s10q10_why",
               "s10q11_why",
               "s10q12_why",
               "s10q13_why",
               "s10q14_why",
               "s10q15_why",
               "s10q16_why",
               "s10q17_why",
               "s10q18_why",
               "s10q19_why",
               "s10q20_why",
               "s10q21_why",
               "s10q22_why",
               "s10q23_why",
               "s10q24_why",
               "s10q25_why",
               "s10q26_why",
               "s10q27_why",
               "s10q28_why",
               "s10q29_why",
               "s10q30_why",
               "s10q31_why",
               "s10q32_why",
               "s10q33_why",
               "s10q34_why",
               "s10q35_why",
               "s10q36_why",
               "s10q37_why",
               "s10q38_why",
               "s10q39_why",
               "s10q40_why",
               "s10q41_why",
               "s10q42_why",
               "s10q43_why",
               "s10q44_why",
               "s10q45_why",
               "s10q46_why",
               "s10q47_why")

report_open (list_open_ends = open_ends)


# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata$s10q31_why[730] <- "Just started last week, payment for loans and savings will start this coming [date]"
mydata$s10q32_why[1071] <- "Weekly [amount redacted]"
mydata$s10q33_why[1071] <- "[language]"

#'# GPS data: Displace
# !!!No GPS data


#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
