#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_3" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)

# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed

# !!!No Direct PII 


#'# Direct PII-team: Encode field team names

# !!!No Direct PII - team


#'# Small locations: Encode locations  with pop <100,000 using random large numbers

# !!!No Small locations


#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values

# !!!No Indirect PII - Ordinal


#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("c_s3q4",
                  "c_s3q5",
                  "c_s3q6",
                  "c_s3q7")

capture_tables (indirect_PII)

# Recode those with very specific values. 

break_activity <- c(1,	2,	3,	4,	5,	6,	7,	8,	9,	10,	11,	12,	13,	15,	16,	17,	18,	19,	21,	23,	26,	30,	31,	32,	35,	36,	37,	38,	39,	40,	42,	43,	46,	47,	48,	49,	50,	55,	56,	79,	99)
labels_activity <- c("Others"=1,
                     "Others"=2,
                     "Others"=3,
                     "Others"=4,
                     "Others"=5,
                     "Others"=6,
                     "Other Farming"=7,
                     "Livestock And Dairy Farmers"=8,
                     "Poultry Farmers"=9,
                     "Others"=10,
                     "Inland And Coastal Waters Fishermen"=11,
                     "Others"=12,
                     "Others"=13,
                     "Construction"=14,
                     "Domestic Work"=15,
                     "Others"=16,
                     "Others"=17,
                     "Others"=18,
                     "Others"=19,
                     "Others"=20,
                     "Others"=21,
                     "Others"=22,
                     "Consumer store operator"=23,
                     "Others"=24,
                     "Others"=25,
                     "Others"=26,
                     "Cleaners, Launderers And Related Workers"=27,
                     "Others"=28,
                     "Others"=29,
                     "Others"=30,
                     "Handicraft Workers In Wood, Textile, Leather, Chemicals And Related Workers"=31,
                     "Others"=32,
                     "Market Stall Vendors, Street Vendors And Related Workers"=33,
                     "Others"=34,
                     "Others"=35,
                     "Others"=36,
                     "Others"=37,
                     "Others"=38,
                     "Others"=39,
                     "Rice Farming"=40,
                     "Other:  Specify"=41)
mydata <- ordinal_recode (variable="c_s3q4", break_points=break_activity, missing=999999, value_labels=labels_activity)




break_activity <- c(1,	2,	3,	4,	6,	7,	8,	9,	10,	11,	12,	13,	15,	16,	17,	18,	20,	21,	23,	26,	30,	31,	32,	35,	36,	37,	38,	39,	40,	42,	43,	45,	46,	47,	48,	49,	50,	52,	55,	56,	79,	99)
labels_activity <- c("Others"=1,
                     "Others"=2,
                     "Others"=3,
                     "Others"=4,
                     "Others"=5,
                     "Other Farming"=6,
                     "Livestock And Dairy Farmers"=7,
                     "Poultry Farmers"=8,
                     "Others"=9,
                     "Inland And Coastal Waters Fishermen"=10,
                     "Others"=11,
                     "Others"=12,
                     "Construction"=13,
                     "Domestic Work"=14,
                     "Others"=15,
                     "Others"=16,
                     "Others"=17,
                     "Others"=18,
                     "Others"=19,
                     "Others"=20,
                     "Others"=21,
                     "Consumer store operator"=22,
                     "Others"=23,
                     "Others"=24,
                     "Others"=25,
                     "Cleaners, Launderers And Related Workers"=26,
                     "Others"=27,
                     "Others"=28,
                     "Others"=29,
                     "Handicraft Workers In Wood, Textile, Leather, Chemicals And Related Workers"=30,
                     "Others"=31,
                     "Others"=32,
                     "Market Stall Vendors, Street Vendors And Related Workers"=33,
                     "Others"=34,
                     "Others"=35,
                     "Others"=36,
                     "Others"=37,
                     "Others"=38,
                     "Others"=39,
                     "Others"=40,
                     "Rice Farming"=41,
                     "Other:  Specify"=42)
mydata <- ordinal_recode (variable="c_s3q5", break_points=break_activity, missing=999999, value_labels=labels_activity)




break_activity <- c(1,	2,	3,	4,	7,	8,	9,	10,	11,	12,	13,	15,	16,	17,	18,	20,	22,	23,	31,	35,	36,	37,	39,	40,	41,	42,	43,	45,	46,	47,	48,	50,	52,	56,	98,	99)
labels_activity <- c("Others "=1,
                     "Others "=2,
                     "Others "=3,
                     "Others "=4,
                     "Other Farming"=5,
                     "Livestock And Dairy Farmers"=6,
                     "Poultry Farmers"=7,
                     "Others "=8,
                     "Inland And Coastal Waters Fishermen"=9,
                     "Others "=10,
                     "Others "=11,
                     "Others "=12,
                     "Domestic Work"=13,
                     "Others "=14,
                     "Others "=15,
                     "Others "=16,
                     "Others "=17,
                     "Others "=18,
                     "Others "=19,
                     "Others "=20,
                     "Others "=21,
                     "Others "=22,
                     "Others "=23,
                     "Others "=24,
                     "Others "=25,
                     "Others "=26,
                     "Others "=27,
                     "Others "=28,
                     "Market Stall Vendors, Street Vendors And Related Workers"=29,
                     "Others "=30,
                     "Others "=31,
                     "Others "=32,
                     "Others "=33,
                     "Others "=34,
                     "Only 1 Type of Work "=35,
                     "Other:  Specify"=36)
mydata <- ordinal_recode (variable="c_s3q6", break_points=break_activity, missing=999999, value_labels=labels_activity)




break_activity <- c(1,	2,	3,	7,	8,	9,	10,	11,	12,	13,	15,	16,	17,	18,	22,	23,	25,	31,	32,	35,	36,	37,	39,	40,	41,	42,	43,	46,	47,	48,	49,	50,	51,	56,	98,	99)
labels_activity <- c("Others"=1,
                     "Others"=2,
                     "Others"=3,
                     "Other Farming"=4,
                     "Livestock And Dairy Farmers"=5,
                     "Poultry Farmers"=6,
                     "Others"=7,
                     "Inland And Coastal Waters Fishermen"=8,
                     "Others"=9,
                     "Others"=10,
                     "Others"=11,
                     "Domestic Work"=12,
                     "Others"=13,
                     "Others"=14,
                     "Others"=15,
                     "Others"=16,
                     "Others"=17,
                     "Others"=18,
                     "Others"=19,
                     "Others"=20,
                     "Others"=21,
                     "Others"=22,
                     "Others"=23,
                     "Others"=24,
                     "Others"=25,
                     "Others"=26,
                     "Others"=27,
                     "Market Stall Vendors, Street Vendors And Related Workers"=28,
                     "Others"=29,
                     "Others"=30,
                     "Others"=31,
                     "Others"=32,
                     "Others"=33,
                     "Others"=34,
                     "Only 1 Type of Work "=35,
                     "Other:  Specify"=36)
mydata <- ordinal_recode (variable="c_s3q7", break_points=break_activity, missing=999999, value_labels=labels_activity)



#'# Matching and crosstabulations: Run automated PII check 

# Based on dictionary inspection, select variables for creating sdcMicro object
# See: https://sdcpractice.readthedocs.io/en/latest/anon_methods.html
# All variable names should correspond to the names in the data file
# selected categorical key variables: gender, occupation/education and age

# !!!Insufficient demographic data



#'# Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("c_anoresponse",
               "c_bnoresponse",
               "c_cnoresponse",
               "c_dnoresponse",
               "c_enoresponse",
               "c_fnoresponse",
               "c_gnoresponse",
               "c_hnoresponse",
               "c_inoresponse",
               "c_jnoresponse",
               "c_knoresponse",
               "c_lnoresponse",
               "c_mnoresponse",
               "c_nnoresponse",
               "c_onoresponse",
               "c_s3q4_other",
               "c_s3q4noresponse",
               "c_s3q5_other",
               "c_s3q5noresponse",
               "c_s3q6_other",
               "c_s3q6noresponse",
               "c_s3q7_other",
               "c_s3q7noresponse")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata$c_bnoresponse[74] <- "[Tagalog]"
mydata$c_dnoresponse[74] <- "[Tagalog]"
mydata$c_dnoresponse[335] <- "[Tagalog]"
mydata$c_enoresponse[74] <- "[Tagalog]"
mydata$c_fnoresponse[74] <- "[Tagalog]"
mydata$c_gnoresponse[74] <- "[Tagalog]"
mydata$c_hnoresponse[74] <- "[Tagalog]"
mydata$c_inoresponse[74] <- "[Tagalog]"
mydata$c_jnoresponse[74] <- "[Tagalog]"
mydata$c_knoresponse[74] <- "[Tagalog]"
mydata$c_lnoresponse[74] <- "[Tagalog]"
mydata$c_mnoresponse[74] <- "[Tagalog]"
mydata$c_mnoresponse[335] <- "[Tagalog]"
mydata$c_onoresponse[335] <- "[Tagalog]"

mydata$c_s3q4_other[2] <- "Other"
mydata$c_s3q4_other[3] <- "Other"
mydata$c_s3q4_other[17] <- "Other"
mydata$c_s3q4_other[43] <- "Other"
mydata$c_s3q4_other[50] <- "Other"
mydata$c_s3q4_other[51] <- "Other"
mydata$c_s3q4_other[76] <- "Other"
mydata$c_s3q4_other[81] <- "Other"
mydata$c_s3q4_other[82] <- "Other"
mydata$c_s3q4_other[118] <- "Other"
mydata$c_s3q4_other[165] <- "Other"
mydata$c_s3q4_other[166] <- "Other"
mydata$c_s3q4_other[197] <- "Other"
mydata$c_s3q4_other[220] <- "Other"
mydata$c_s3q4_other[226] <- "Other"
mydata$c_s3q4_other[230] <- "Other"
mydata$c_s3q4_other[232] <- "Other"
mydata$c_s3q4_other[235] <- "Other"
mydata$c_s3q4_other[237] <- "Other"
mydata$c_s3q4_other[239] <- "Other"
mydata$c_s3q4_other[244] <- "Other"
mydata$c_s3q4_other[245] <- "Other"
mydata$c_s3q4_other[290] <- "Other"
mydata$c_s3q4_other[294] <- "Other"
mydata$c_s3q4_other[345] <- "Other"
mydata$c_s3q4_other[351] <- "Other"
mydata$c_s3q4_other[352] <- "Other"
mydata$c_s3q4_other[353] <- "Other"
mydata$c_s3q4_other[362] <- "Other"
mydata$c_s3q4_other[373] <- "Other"
mydata$c_s3q4_other[374] <- "Other"
mydata$c_s3q4_other[377] <- "Other"
mydata$c_s3q4_other[378] <- "Other"
mydata$c_s3q4_other[382] <- "Other"
mydata$c_s3q4_other[421] <- "Other"
mydata$c_s3q4_other[422] <- "Other"
mydata$c_s3q4_other[425] <- "Other"
mydata$c_s3q4_other[429] <- "Other"
mydata$c_s3q4_other[446] <- "Other"
mydata$c_s3q4_other[474] <- "Other"
mydata$c_s3q4_other[507] <- "Other"
mydata$c_s3q4_other[517] <- "Other"
mydata$c_s3q4_other[554] <- "Other"
mydata$c_s3q4_other[578] <- "Other"
mydata$c_s3q4_other[581] <- "Other"
mydata$c_s3q4_other[582] <- "Other"
mydata$c_s3q4_other[583] <- "Other"
mydata$c_s3q4_other[596] <- "Other"
mydata$c_s3q4_other[597] <- "Other"
mydata$c_s3q4_other[623] <- "Other"
mydata$c_s3q4_other[626] <- "Other"
mydata$c_s3q4_other[636] <- "Other"
mydata$c_s3q4_other[638] <- "Other"
mydata$c_s3q4_other[640] <- "Other"
mydata$c_s3q4_other[641] <- "Other"
mydata$c_s3q4_other[642] <- "Other"
mydata$c_s3q4_other[645] <- "Other"
mydata$c_s3q4_other[648] <- "Other"
mydata$c_s3q4_other[652] <- "Other"
mydata$c_s3q4_other[679] <- "Other"
mydata$c_s3q4_other[680] <- "Other"
mydata$c_s3q4_other[683] <- "Other"
mydata$c_s3q4_other[700] <- "Other"
mydata$c_s3q4_other[712] <- "Other"
mydata$c_s3q4_other[731] <- "Other"
mydata$c_s3q4_other[739] <- "Other"
mydata$c_s3q4_other[741] <- "Other"
mydata$c_s3q4_other[742] <- "Other"
mydata$c_s3q4_other[748] <- "Other"
mydata$c_s3q4_other[749] <- "Other"
mydata$c_s3q4_other[750] <- "Other"
mydata$c_s3q4_other[751] <- "Other"
mydata$c_s3q4_other[759] <- "Other"
mydata$c_s3q4_other[765] <- "Other"
mydata$c_s3q4_other[768] <- "Other"
mydata$c_s3q4_other[774] <- "Other"
mydata$c_s3q4_other[776] <- "Other"
mydata$c_s3q4_other[777] <- "Other"
mydata$c_s3q4_other[778] <- "Other"
mydata$c_s3q4_other[779] <- "Other"
mydata$c_s3q4_other[781] <- "Other"
mydata$c_s3q4_other[784] <- "Other"
mydata$c_s3q4_other[801] <- "Other"
mydata$c_s3q4_other[803] <- "Other"
mydata$c_s3q4_other[805] <- "Other"
mydata$c_s3q4_other[810] <- "Other"
mydata$c_s3q4_other[813] <- "Other"
mydata$c_s3q4_other[821] <- "Other"
mydata$c_s3q4_other[824] <- "Other"
mydata$c_s3q4_other[825] <- "Other"
mydata$c_s3q4_other[843] <- "Other"
mydata$c_s3q4_other[844] <- "Other"
mydata$c_s3q4_other[845] <- "Other"
mydata$c_s3q4_other[846] <- "Other"
mydata$c_s3q4_other[847] <- "Other"
mydata$c_s3q4_other[854] <- "Other"
mydata$c_s3q4_other[855] <- "Other"
mydata$c_s3q4_other[859] <- "Other"
mydata$c_s3q4_other[860] <- "Other"
mydata$c_s3q4_other[864] <- "Other"
mydata$c_s3q4_other[865] <- "Other"
mydata$c_s3q4_other[872] <- "Other"
mydata$c_s3q4_other[873] <- "Other"
mydata$c_s3q4_other[878] <- "Other"
mydata$c_s3q4_other[883] <- "Other"
mydata$c_s3q4_other[884] <- "Other"
mydata$c_s3q4_other[886] <- "Other"
mydata$c_s3q4_other[888] <- "Other"
mydata$c_s3q4_other[889] <- "Other"
mydata$c_s3q4_other[891] <- "Other"
mydata$c_s3q4_other[899] <- "Other"
mydata$c_s3q4_other[900] <- "Other"
mydata$c_s3q4_other[902] <- "Other"
mydata$c_s3q4_other[906] <- "Other"
mydata$c_s3q4_other[907] <- "Other"
mydata$c_s3q4_other[908] <- "Other"
mydata$c_s3q4_other[913] <- "Other"
mydata$c_s3q4_other[914] <- "Other"
mydata$c_s3q4_other[915] <- "Other"
mydata$c_s3q4_other[916] <- "Other"
mydata$c_s3q4_other[928] <- "Other"
mydata$c_s3q4_other[941] <- "Other"
mydata$c_s3q4_other[945] <- "Other"
mydata$c_s3q4_other[952] <- "Other"
mydata$c_s3q4_other[954] <- "Other"
mydata$c_s3q4_other[962] <- "Other"
mydata$c_s3q4_other[968] <- "Other"
mydata$c_s3q4_other[970] <- "Other"
mydata$c_s3q4_other[971] <- "Other"
mydata$c_s3q4_other[976] <- "Other"
mydata$c_s3q4_other[977] <- "Other"
mydata$c_s3q4_other[978] <- "Other"
mydata$c_s3q4_other[979] <- "Other"
mydata$c_s3q4_other[980] <- "Other"
mydata$c_s3q4_other[985] <- "Other"
mydata$c_s3q4_other[987] <- "Other"
mydata$c_s3q4_other[991] <- "Other"
mydata$c_s3q4_other[997] <- "Other"
mydata$c_s3q4_other[1000] <- "Other"
mydata$c_s3q4_other[1002] <- "Other"
mydata$c_s3q4_other[1004] <- "Other"
mydata$c_s3q4_other[1010] <- "Other"
mydata$c_s3q4_other[1013] <- "Other"
mydata$c_s3q4_other[1018] <- "Other"
mydata$c_s3q4_other[1020] <- "Other"
mydata$c_s3q4_other[1021] <- "Other"
mydata$c_s3q4_other[1023] <- "Other"
mydata$c_s3q4_other[1025] <- "Other"
mydata$c_s3q4_other[1028] <- "Other"
mydata$c_s3q4_other[1029] <- "Other"
mydata$c_s3q4_other[1036] <- "Other"
mydata$c_s3q4_other[1038] <- "Other"
mydata$c_s3q4_other[1044] <- "Other"
mydata$c_s3q4_other[1045] <- "Other"
mydata$c_s3q4_other[1055] <- "Other"
mydata$c_s3q4_other[1060] <- "Other"
mydata$c_s3q4_other[1064] <- "Other"
mydata$c_s3q4_other[1076] <- "Other"
mydata$c_s3q4_other[1083] <- "Other"
mydata$c_s3q4_other[1086] <- "Other"
mydata$c_s3q4_other[1090] <- "Other"
mydata$c_s3q4_other[1093] <- "Other"
mydata$c_s3q4_other[1094] <- "Other"
mydata$c_s3q4_other[1097] <- "Other"
mydata$c_s3q4_other[1104] <- "Other"
mydata$c_s3q4_other[1105] <- "Other"
mydata$c_s3q4_other[1106] <- "Other"
mydata$c_s3q4_other[1119] <- "Other"
mydata$c_s3q4_other[1121] <- "Other"
mydata$c_s3q4_other[1132] <- "Other"
mydata$c_s3q4_other[1134] <- "Other"
mydata$c_s3q4_other[1138] <- "Other"
mydata$c_s3q4_other[1158] <- "Other"
mydata$c_s3q4_other[1162] <- "Other"
mydata$c_s3q4_other[1166] <- "Other"
mydata$c_s3q4_other[1592] <- "Other"
mydata$c_s3q4_other[2148] <- "Other"
mydata$c_s3q4_other[2354] <- "Other"
mydata$c_s3q4_other[2423] <- "Other"
mydata$c_s3q4_other[2431] <- "Other"
mydata$c_s3q4_other[2432] <- "Other"
mydata$c_s3q4_other[2473] <- "Other"
mydata$c_s3q4_other[2497] <- "Other"
mydata$c_s3q4_other[2499] <- "Other"
mydata$c_s3q4_other[2500] <- "Other"
mydata$c_s3q4_other[2512] <- "Other"
mydata$c_s3q4_other[2524] <- "Other"
mydata$c_s3q4_other[2525] <- "Other"
mydata$c_s3q4_other[2526] <- "Other"
mydata$c_s3q4_other[2527] <- "Other"
mydata$c_s3q4_other[2540] <- "Other"
mydata$c_s3q4_other[2542] <- "Other"
mydata$c_s3q4_other[2563] <- "Other"
mydata$c_s3q4_other[2674] <- "Other"
mydata$c_s3q4_other[2685] <- "Other"
mydata$c_s3q4_other[2690] <- "Other"
mydata$c_s3q4_other[2695] <- "Other"
mydata$c_s3q4_other[2698] <- "Other"
mydata$c_s3q4_other[2702] <- "Other"
mydata$c_s3q4_other[2709] <- "Other"
mydata$c_s3q4_other[2710] <- "Other"
mydata$c_s3q4_other[2719] <- "Other"
mydata$c_s3q4_other[2728] <- "Other"
mydata$c_s3q4_other[2729] <- "Other"
mydata$c_s3q4_other[2730] <- "Other"
mydata$c_s3q4_other[2735] <- "Other"
mydata$c_s3q4_other[2736] <- "Other"
mydata$c_s3q4_other[2737] <- "Other"
mydata$c_s3q4_other[2748] <- "Other"
mydata$c_s3q4_other[2761] <- "Other"
mydata$c_s3q4_other[2762] <- "Other"
mydata$c_s3q4_other[2768] <- "Other"
mydata$c_s3q4_other[2784] <- "Other"
mydata$c_s3q4_other[2789] <- "Other"
mydata$c_s3q4_other[2792] <- "Other"
mydata$c_s3q4_other[2793] <- "Other"
mydata$c_s3q4_other[2802] <- "Other"
mydata$c_s3q4_other[2803] <- "Other"
mydata$c_s3q4_other[2822] <- "Other"
mydata$c_s3q4_other[2823] <- "Other"
mydata$c_s3q4_other[2824] <- "Other"
mydata$c_s3q4_other[2830] <- "Other"
mydata$c_s3q4_other[2832] <- "Other"
mydata$c_s3q4_other[2833] <- "Other"
mydata$c_s3q4_other[2834] <- "Other"
mydata$c_s3q4_other[2842] <- "Other"
mydata$c_s3q4_other[2843] <- "Other"
mydata$c_s3q4_other[2844] <- "Other"
mydata$c_s3q4_other[2845] <- "Other"
mydata$c_s3q4_other[2854] <- "Other"
mydata$c_s3q4_other[2856] <- "Other"
mydata$c_s3q4_other[2857] <- "Other"
mydata$c_s3q4_other[2861] <- "Other"
mydata$c_s3q4_other[2862] <- "Other"
mydata$c_s3q4_other[2863] <- "Other"
mydata$c_s3q4_other[2864] <- "Other"
mydata$c_s3q4_other[2871] <- "Other"
mydata$c_s3q4_other[2872] <- "Other"
mydata$c_s3q4_other[2874] <- "Other"
mydata$c_s3q4_other[2876] <- "Other"
mydata$c_s3q4_other[2891] <- "Other"
mydata$c_s3q4_other[2914] <- "Other"
mydata$c_s3q4_other[2927] <- "Other"
mydata$c_s3q4_other[2928] <- "Other"
mydata$c_s3q4_other[2942] <- "Other"
mydata$c_s3q4_other[2943] <- "Other"
mydata$c_s3q4_other[2945] <- "Other"
mydata$c_s3q4_other[2950] <- "Other"
mydata$c_s3q4_other[2952] <- "Other"
mydata$c_s3q4_other[2953] <- "Other"
mydata$c_s3q4_other[2958] <- "Other"
mydata$c_s3q4_other[2959] <- "Other"
mydata$c_s3q4_other[2966] <- "Other"
mydata$c_s3q4_other[2983] <- "Other"
mydata$c_s3q4_other[2984] <- "Other"
mydata$c_s3q4_other[2985] <- "Other"
mydata$c_s3q4_other[2990] <- "Other"
mydata$c_s3q4_other[2991] <- "Other"
mydata$c_s3q4_other[2995] <- "Other"
mydata$c_s3q4_other[3003] <- "Other"
mydata$c_s3q4_other[3004] <- "Other"
mydata$c_s3q4_other[3005] <- "Other"
mydata$c_s3q4_other[3007] <- "Other"
mydata$c_s3q4_other[3035] <- "Other"
mydata$c_s3q4_other[3036] <- "Other"
mydata$c_s3q4_other[3037] <- "Other"
mydata$c_s3q4_other[3044] <- "Other"
mydata$c_s3q4_other[3054] <- "Other"
mydata$c_s3q4_other[3056] <- "Other"
mydata$c_s3q4_other[3057] <- "Other"
mydata$c_s3q4_other[3061] <- "Other"
mydata$c_s3q4_other[3062] <- "Other"
mydata$c_s3q4_other[3067] <- "Other"
mydata$c_s3q4_other[3068] <- "Other"
mydata$c_s3q4_other[3073] <- "Other"
mydata$c_s3q4_other[3074] <- "Other"
mydata$c_s3q4_other[3082] <- "Other"
mydata$c_s3q4_other[3105] <- "Other"
mydata$c_s3q4_other[3115] <- "Other"
mydata$c_s3q4_other[3407] <- "Other"
mydata$c_s3q4_other[3409] <- "Other"
mydata$c_s3q4_other[3414] <- "Other"
mydata$c_s3q4_other[3415] <- "Other"
mydata$c_s3q4_other[3417] <- "Other"
mydata$c_s3q4_other[3506] <- "Other"
mydata$c_s3q4_other[3510] <- "Other"
mydata$c_s3q4_other[3511] <- "Other"
mydata$c_s3q4_other[3512] <- "Other"
mydata$c_s3q4_other[3515] <- "Other"
mydata$c_s3q4_other[3519] <- "Other"
mydata$c_s3q4_other[3520] <- "Other"
mydata$c_s3q4_other[3524] <- "Other"
mydata$c_s3q4_other[3525] <- "Other"
mydata$c_s3q4_other[3526] <- "Other"
mydata$c_s3q4_other[3532] <- "Other"
mydata$c_s3q4_other[3538] <- "Other"
mydata$c_s3q4_other[3550] <- "Other"
mydata$c_s3q4_other[3552] <- "Other"
mydata$c_s3q4_other[3554] <- "Other"
mydata$c_s3q4_other[3555] <- "Other"
mydata$c_s3q4_other[3556] <- "Other"
mydata$c_s3q4_other[3560] <- "Other"
mydata$c_s3q4_other[3567] <- "Other"
mydata$c_s3q4_other[3576] <- "Other"
mydata$c_s3q4_other[3577] <- "Other"
mydata$c_s3q4_other[3609] <- "Other"
mydata$c_s3q4_other[3613] <- "Other"
mydata$c_s3q4_other[3615] <- "Other"
mydata$c_s3q4_other[3617] <- "Other"
mydata$c_s3q4_other[3624] <- "Other"
mydata$c_s3q4_other[3625] <- "Other"
mydata$c_s3q4_other[3644] <- "Other"
mydata$c_s3q4_other[3647] <- "Other"
mydata$c_s3q4_other[3649] <- "Other"
mydata$c_s3q4_other[3658] <- "Other"
mydata$c_s3q4_other[3661] <- "Other"
mydata$c_s3q4_other[3666] <- "Other"
mydata$c_s3q4_other[3671] <- "Other"
mydata$c_s3q4_other[3681] <- "Other"
mydata$c_s3q4_other[3686] <- "Other"
mydata$c_s3q4_other[3688] <- "Other"
mydata$c_s3q4_other[3689] <- "Other"
mydata$c_s3q4_other[3695] <- "Other"
mydata$c_s3q4_other[3698] <- "Other"
mydata$c_s3q4_other[3699] <- "Other"
mydata$c_s3q4_other[3703] <- "Other"
mydata$c_s3q4_other[3706] <- "Other"
mydata$c_s3q4_other[3707] <- "Other"
mydata$c_s3q4_other[3709] <- "Other"
mydata$c_s3q4_other[3710] <- "Other"
mydata$c_s3q4_other[3719] <- "Other"
mydata$c_s3q4_other[3721] <- "Other"
mydata$c_s3q4_other[3727] <- "Other"
mydata$c_s3q4_other[3729] <- "Other"
mydata$c_s3q4_other[3736] <- "Other"
mydata$c_s3q4_other[3740] <- "Other"
mydata$c_s3q4_other[3741] <- "Other"
mydata$c_s3q4_other[3755] <- "Other"
mydata$c_s3q4_other[3759] <- "Other"
mydata$c_s3q4_other[3776] <- "Other"
mydata$c_s3q4_other[3831] <- "Other"
mydata$c_s3q4_other[3973] <- "Other"
mydata$c_s3q4_other[3974] <- "Other"
mydata$c_s3q4_other[3975] <- "Other"
mydata$c_s3q4_other[3976] <- "Other"
mydata$c_s3q4_other[3977] <- "Other"
mydata$c_s3q4_other[3984] <- "Other"
mydata$c_s3q4_other[3989] <- "Other"
mydata$c_s3q4_other[3990] <- "Other"
mydata$c_s3q4_other[3991] <- "Other"
mydata$c_s3q4_other[3992] <- "Other"
mydata$c_s3q4_other[3993] <- "Other"
mydata$c_s3q4_other[3996] <- "Other"
mydata$c_s3q4_other[3997] <- "Other"
mydata$c_s3q4_other[3999] <- "Other"
mydata$c_s3q4_other[4000] <- "Other"
mydata$c_s3q4_other[4001] <- "Other"
mydata$c_s3q4_other[4002] <- "Other"
mydata$c_s3q4_other[4006] <- "Other"
mydata$c_s3q4_other[4010] <- "Other"
mydata$c_s3q4_other[4011] <- "Other"
mydata$c_s3q4_other[4013] <- "Other"
mydata$c_s3q4_other[4015] <- "Other"
mydata$c_s3q4_other[4017] <- "Other"
mydata$c_s3q4_other[4018] <- "Other"
mydata$c_s3q4_other[4020] <- "Other"
mydata$c_s3q4_other[4021] <- "Other"
mydata$c_s3q4_other[4022] <- "Other"
mydata$c_s3q4_other[4023] <- "Other"
mydata$c_s3q4_other[4024] <- "Other"
mydata$c_s3q4_other[4025] <- "Other"
mydata$c_s3q4_other[4026] <- "Other"
mydata$c_s3q4_other[4027] <- "Other"
mydata$c_s3q4_other[4028] <- "Other"
mydata$c_s3q4_other[4033] <- "Other"
mydata$c_s3q4_other[4040] <- "Other"
mydata$c_s3q4_other[4041] <- "Other"
mydata$c_s3q4_other[4044] <- "Other"
mydata$c_s3q4_other[4045] <- "Other"
mydata$c_s3q4_other[4046] <- "Other"
mydata$c_s3q4_other[4047] <- "Other"
mydata$c_s3q4_other[4056] <- "Other"
mydata$c_s3q4_other[4057] <- "Other"
mydata$c_s3q4_other[4058] <- "Other"
mydata$c_s3q4_other[4059] <- "Other"
mydata$c_s3q4_other[4060] <- "Other"
mydata$c_s3q4_other[4254] <- "Other"
mydata$c_s3q4_other[4261] <- "Other"
mydata$c_s3q4_other[4270] <- "Other"
mydata$c_s3q4_other[4273] <- "Other"
mydata$c_s3q4_other[4274] <- "Other"
mydata$c_s3q4_other[4275] <- "Other"
mydata$c_s3q4_other[4284] <- "Other"
mydata$c_s3q4_other[4285] <- "Other"
mydata$c_s3q4_other[4287] <- "Other"
mydata$c_s3q4_other[4288] <- "Other"
mydata$c_s3q4_other[4294] <- "Other"
mydata$c_s3q4_other[4301] <- "Other"

mydata$c_s3q4noresponse[335] <- "Other"
mydata$c_s3q4noresponse[336] <- "Other"
mydata$c_s3q4noresponse[341] <- "Other"
mydata$c_s3q4noresponse[370] <- "Other"
mydata$c_s3q4noresponse[383] <- "Other"
mydata$c_s3q4noresponse[544] <- "Other"
mydata$c_s3q4noresponse[551] <- "Other"
mydata$c_s3q4noresponse[716] <- "Other"
mydata$c_s3q4noresponse[783] <- "Other"
mydata$c_s3q4noresponse[823] <- "Other"
mydata$c_s3q4noresponse[834] <- "Other"
mydata$c_s3q4noresponse[894] <- "Other"
mydata$c_s3q4noresponse[909] <- "Other"
mydata$c_s3q4noresponse[947] <- "Other"
mydata$c_s3q4noresponse[992] <- "Other"
mydata$c_s3q4noresponse[1009] <- "Other"
mydata$c_s3q4noresponse[1102] <- "Other"
mydata$c_s3q4noresponse[1127] <- "Other"
mydata$c_s3q4noresponse[1130] <- "Other"
mydata$c_s3q4noresponse[1131] <- "Other"
mydata$c_s3q4noresponse[1136] <- "Other"
mydata$c_s3q4noresponse[1181] <- "Other"
mydata$c_s3q4noresponse[1207] <- "Other"
mydata$c_s3q4noresponse[1224] <- "Other"
mydata$c_s3q4noresponse[1256] <- "Other"
mydata$c_s3q4noresponse[1258] <- "Other"
mydata$c_s3q4noresponse[1272] <- "Other"
mydata$c_s3q4noresponse[1286] <- "Other"
mydata$c_s3q4noresponse[1328] <- "Other"
mydata$c_s3q4noresponse[1357] <- "Other"
mydata$c_s3q4noresponse[1398] <- "Other"
mydata$c_s3q4noresponse[1418] <- "Other"
mydata$c_s3q4noresponse[1419] <- "Other"
mydata$c_s3q4noresponse[1447] <- "Other"
mydata$c_s3q4noresponse[1450] <- "Other"
mydata$c_s3q4noresponse[1459] <- "Other"
mydata$c_s3q4noresponse[1460] <- "Other"
mydata$c_s3q4noresponse[1461] <- "Other"
mydata$c_s3q4noresponse[1468] <- "Other"
mydata$c_s3q4noresponse[1491] <- "Other"
mydata$c_s3q4noresponse[1492] <- "Other"
mydata$c_s3q4noresponse[1493] <- "Other"
mydata$c_s3q4noresponse[1501] <- "Other"
mydata$c_s3q4noresponse[1549] <- "Other"
mydata$c_s3q4noresponse[1560] <- "Other"
mydata$c_s3q4noresponse[1595] <- "Other"
mydata$c_s3q4noresponse[1596] <- "Other"
mydata$c_s3q4noresponse[1599] <- "Other"
mydata$c_s3q4noresponse[1603] <- "Other"
mydata$c_s3q4noresponse[1617] <- "Other"
mydata$c_s3q4noresponse[1618] <- "Other"
mydata$c_s3q4noresponse[1632] <- "Other"
mydata$c_s3q4noresponse[1647] <- "Other"
mydata$c_s3q4noresponse[1664] <- "Other"
mydata$c_s3q4noresponse[1685] <- "Other"
mydata$c_s3q4noresponse[1754] <- "Other"
mydata$c_s3q4noresponse[1771] <- "Other"
mydata$c_s3q4noresponse[1775] <- "Other"
mydata$c_s3q4noresponse[1779] <- "Other"
mydata$c_s3q4noresponse[1799] <- "Other"
mydata$c_s3q4noresponse[1828] <- "Other"
mydata$c_s3q4noresponse[1845] <- "Other"
mydata$c_s3q4noresponse[1859] <- "Other"
mydata$c_s3q4noresponse[1901] <- "Other"
mydata$c_s3q4noresponse[1936] <- "Other"
mydata$c_s3q4noresponse[1942] <- "Other"
mydata$c_s3q4noresponse[1949] <- "Other"
mydata$c_s3q4noresponse[1966] <- "Other"
mydata$c_s3q4noresponse[1999] <- "Other"
mydata$c_s3q4noresponse[2013] <- "Other"
mydata$c_s3q4noresponse[2020] <- "Other"
mydata$c_s3q4noresponse[2033] <- "Other"
mydata$c_s3q4noresponse[2050] <- "Other"
mydata$c_s3q4noresponse[2051] <- "Other"
mydata$c_s3q4noresponse[2062] <- "Other"
mydata$c_s3q4noresponse[2069] <- "Other"
mydata$c_s3q4noresponse[2161] <- "Other"
mydata$c_s3q4noresponse[2170] <- "Other"
mydata$c_s3q4noresponse[2205] <- "Other"
mydata$c_s3q4noresponse[2207] <- "Other"
mydata$c_s3q4noresponse[2219] <- "Other"
mydata$c_s3q4noresponse[2222] <- "Other"
mydata$c_s3q4noresponse[2223] <- "Other"
mydata$c_s3q4noresponse[2227] <- "Other"
mydata$c_s3q4noresponse[2235] <- "Other"
mydata$c_s3q4noresponse[2259] <- "Other"
mydata$c_s3q4noresponse[2290] <- "Other"
mydata$c_s3q4noresponse[2293] <- "Other"
mydata$c_s3q4noresponse[2329] <- "Other"
mydata$c_s3q4noresponse[2347] <- "Other"
mydata$c_s3q4noresponse[2397] <- "Other"
mydata$c_s3q4noresponse[2416] <- "Other"
mydata$c_s3q4noresponse[2461] <- "Other"
mydata$c_s3q4noresponse[2487] <- "Other"
mydata$c_s3q4noresponse[2496] <- "Other"
mydata$c_s3q4noresponse[2609] <- "Other"
mydata$c_s3q4noresponse[2637] <- "Other"
mydata$c_s3q4noresponse[2654] <- "Other"
mydata$c_s3q4noresponse[2660] <- "Other"
mydata$c_s3q4noresponse[3247] <- "Other"
mydata$c_s3q4noresponse[3457] <- "Other"
mydata$c_s3q4noresponse[3814] <- "Other"
mydata$c_s3q4noresponse[3900] <- "Other"
mydata$c_s3q4noresponse[3922] <- "Other"
mydata$c_s3q4noresponse[3986] <- "Other"
mydata$c_s3q4noresponse[4085] <- "Other"
mydata$c_s3q4noresponse[4093] <- "Other"
mydata$c_s3q4noresponse[4094] <- "Other"

mydata$c_s3q5_other[50] <- "Other"
mydata$c_s3q5_other[51] <- "Other"
mydata$c_s3q5_other[119] <- "Other"
mydata$c_s3q5_other[128] <- "Other"
mydata$c_s3q5_other[220] <- "Other"
mydata$c_s3q5_other[226] <- "Other"
mydata$c_s3q5_other[230] <- "Other"
mydata$c_s3q5_other[232] <- "Other"
mydata$c_s3q5_other[233] <- "Other"
mydata$c_s3q5_other[234] <- "Other"
mydata$c_s3q5_other[235] <- "Other"
mydata$c_s3q5_other[244] <- "Other"
mydata$c_s3q5_other[267] <- "Other"
mydata$c_s3q5_other[276] <- "Other"
mydata$c_s3q5_other[342] <- "Other"
mydata$c_s3q5_other[345] <- "Other"
mydata$c_s3q5_other[352] <- "Other"
mydata$c_s3q5_other[362] <- "Other"
mydata$c_s3q5_other[370] <- "Other"
mydata$c_s3q5_other[373] <- "Other"
mydata$c_s3q5_other[374] <- "Other"
mydata$c_s3q5_other[377] <- "Other"
mydata$c_s3q5_other[378] <- "Other"
mydata$c_s3q5_other[382] <- "Other"
mydata$c_s3q5_other[389] <- "Other"
mydata$c_s3q5_other[425] <- "Other"
mydata$c_s3q5_other[429] <- "Other"
mydata$c_s3q5_other[471] <- "Other"
mydata$c_s3q5_other[472] <- "Other"
mydata$c_s3q5_other[474] <- "Other"
mydata$c_s3q5_other[507] <- "Other"
mydata$c_s3q5_other[517] <- "Other"
mydata$c_s3q5_other[554] <- "Other"
mydata$c_s3q5_other[583] <- "Other"
mydata$c_s3q5_other[587] <- "Other"
mydata$c_s3q5_other[596] <- "Other"
mydata$c_s3q5_other[597] <- "Other"
mydata$c_s3q5_other[623] <- "Other"
mydata$c_s3q5_other[626] <- "Other"
mydata$c_s3q5_other[645] <- "Other"
mydata$c_s3q5_other[652] <- "Other"
mydata$c_s3q5_other[680] <- "Other"
mydata$c_s3q5_other[684] <- "Other"
mydata$c_s3q5_other[700] <- "Other"
mydata$c_s3q5_other[712] <- "Other"
mydata$c_s3q5_other[739] <- "Other"
mydata$c_s3q5_other[740] <- "Other"
mydata$c_s3q5_other[741] <- "Other"
mydata$c_s3q5_other[748] <- "Other"
mydata$c_s3q5_other[749] <- "Other"
mydata$c_s3q5_other[750] <- "Other"
mydata$c_s3q5_other[751] <- "Other"
mydata$c_s3q5_other[759] <- "Other"
mydata$c_s3q5_other[769] <- "Other"
mydata$c_s3q5_other[774] <- "Other"
mydata$c_s3q5_other[778] <- "Other"
mydata$c_s3q5_other[779] <- "Other"
mydata$c_s3q5_other[781] <- "Other"
mydata$c_s3q5_other[784] <- "Other"
mydata$c_s3q5_other[800] <- "Other"
mydata$c_s3q5_other[801] <- "Other"
mydata$c_s3q5_other[803] <- "Other"
mydata$c_s3q5_other[804] <- "Other"
mydata$c_s3q5_other[805] <- "Other"
mydata$c_s3q5_other[810] <- "Other"
mydata$c_s3q5_other[812] <- "Other"
mydata$c_s3q5_other[816] <- "Other"
mydata$c_s3q5_other[821] <- "Other"
mydata$c_s3q5_other[824] <- "Other"
mydata$c_s3q5_other[825] <- "Other"
mydata$c_s3q5_other[832] <- "Other"
mydata$c_s3q5_other[843] <- "Other"
mydata$c_s3q5_other[844] <- "Other"
mydata$c_s3q5_other[846] <- "Other"
mydata$c_s3q5_other[847] <- "Other"
mydata$c_s3q5_other[851] <- "Other"
mydata$c_s3q5_other[853] <- "Other"
mydata$c_s3q5_other[854] <- "Other"
mydata$c_s3q5_other[855] <- "Other"
mydata$c_s3q5_other[859] <- "Other"
mydata$c_s3q5_other[860] <- "Other"
mydata$c_s3q5_other[864] <- "Other"
mydata$c_s3q5_other[865] <- "Other"
mydata$c_s3q5_other[877] <- "Other"
mydata$c_s3q5_other[883] <- "Other"
mydata$c_s3q5_other[884] <- "Other"
mydata$c_s3q5_other[886] <- "Other"
mydata$c_s3q5_other[888] <- "Other"
mydata$c_s3q5_other[889] <- "Other"
mydata$c_s3q5_other[891] <- "Other"
mydata$c_s3q5_other[899] <- "Other"
mydata$c_s3q5_other[900] <- "Other"
mydata$c_s3q5_other[902] <- "Other"
mydata$c_s3q5_other[906] <- "Other"
mydata$c_s3q5_other[907] <- "Other"
mydata$c_s3q5_other[908] <- "Other"
mydata$c_s3q5_other[913] <- "Other"
mydata$c_s3q5_other[915] <- "Other"
mydata$c_s3q5_other[916] <- "Other"
mydata$c_s3q5_other[952] <- "Other"
mydata$c_s3q5_other[954] <- "Other"
mydata$c_s3q5_other[962] <- "Other"
mydata$c_s3q5_other[970] <- "Other"
mydata$c_s3q5_other[971] <- "Other"
mydata$c_s3q5_other[975] <- "Other"
mydata$c_s3q5_other[978] <- "Other"
mydata$c_s3q5_other[979] <- "Other"
mydata$c_s3q5_other[980] <- "Other"
mydata$c_s3q5_other[985] <- "Other"
mydata$c_s3q5_other[987] <- "Other"
mydata$c_s3q5_other[988] <- "Other"
mydata$c_s3q5_other[991] <- "Other"
mydata$c_s3q5_other[992] <- "Other"
mydata$c_s3q5_other[996] <- "Other"
mydata$c_s3q5_other[1000] <- "Other"
mydata$c_s3q5_other[1002] <- "Other"
mydata$c_s3q5_other[1004] <- "Other"
mydata$c_s3q5_other[1009] <- "Other"
mydata$c_s3q5_other[1018] <- "Other"
mydata$c_s3q5_other[1021] <- "Other"
mydata$c_s3q5_other[1023] <- "Other"
mydata$c_s3q5_other[1025] <- "Other"
mydata$c_s3q5_other[1028] <- "Other"
mydata$c_s3q5_other[1029] <- "Other"
mydata$c_s3q5_other[1034] <- "Other"
mydata$c_s3q5_other[1036] <- "Other"
mydata$c_s3q5_other[1044] <- "Other"
mydata$c_s3q5_other[1055] <- "Other"
mydata$c_s3q5_other[1060] <- "Other"
mydata$c_s3q5_other[1064] <- "Other"
mydata$c_s3q5_other[1072] <- "Other"
mydata$c_s3q5_other[1073] <- "Other"
mydata$c_s3q5_other[1076] <- "Other"
mydata$c_s3q5_other[1083] <- "Other"
mydata$c_s3q5_other[1086] <- "Other"
mydata$c_s3q5_other[1093] <- "Other"
mydata$c_s3q5_other[1094] <- "Other"
mydata$c_s3q5_other[1097] <- "Other"
mydata$c_s3q5_other[1104] <- "Other"
mydata$c_s3q5_other[1105] <- "Other"
mydata$c_s3q5_other[1106] <- "Other"
mydata$c_s3q5_other[1128] <- "Other"
mydata$c_s3q5_other[1132] <- "Other"
mydata$c_s3q5_other[1134] <- "Other"
mydata$c_s3q5_other[1138] <- "Other"
mydata$c_s3q5_other[1158] <- "Other"
mydata$c_s3q5_other[1162] <- "Other"
mydata$c_s3q5_other[1166] <- "Other"
mydata$c_s3q5_other[1734] <- "Other"
mydata$c_s3q5_other[2148] <- "Other"
mydata$c_s3q5_other[2354] <- "Other"
mydata$c_s3q5_other[2473] <- "Other"
mydata$c_s3q5_other[2497] <- "Other"
mydata$c_s3q5_other[2499] <- "Other"
mydata$c_s3q5_other[2500] <- "Other"
mydata$c_s3q5_other[2512] <- "Other"
mydata$c_s3q5_other[2524] <- "Other"
mydata$c_s3q5_other[2525] <- "Other"
mydata$c_s3q5_other[2526] <- "Other"
mydata$c_s3q5_other[2527] <- "Other"
mydata$c_s3q5_other[2542] <- "Other"
mydata$c_s3q5_other[2546] <- "Other"
mydata$c_s3q5_other[2560] <- "Other"
mydata$c_s3q5_other[2674] <- "Other"
mydata$c_s3q5_other[2685] <- "Other"
mydata$c_s3q5_other[2690] <- "Other"
mydata$c_s3q5_other[2695] <- "Other"
mydata$c_s3q5_other[2702] <- "Other"
mydata$c_s3q5_other[2709] <- "Other"
mydata$c_s3q5_other[2710] <- "Other"
mydata$c_s3q5_other[2719] <- "Other"
mydata$c_s3q5_other[2728] <- "Other"
mydata$c_s3q5_other[2735] <- "Other"
mydata$c_s3q5_other[2736] <- "Other"
mydata$c_s3q5_other[2737] <- "Other"
mydata$c_s3q5_other[2761] <- "Other"
mydata$c_s3q5_other[2762] <- "Other"
mydata$c_s3q5_other[2768] <- "Other"
mydata$c_s3q5_other[2771] <- "Other"
mydata$c_s3q5_other[2789] <- "Other"
mydata$c_s3q5_other[2792] <- "Other"
mydata$c_s3q5_other[2793] <- "Other"
mydata$c_s3q5_other[2802] <- "Other"
mydata$c_s3q5_other[2803] <- "Other"
mydata$c_s3q5_other[2822] <- "Other"
mydata$c_s3q5_other[2823] <- "Other"
mydata$c_s3q5_other[2824] <- "Other"
mydata$c_s3q5_other[2830] <- "Other"
mydata$c_s3q5_other[2832] <- "Other"
mydata$c_s3q5_other[2833] <- "Other"
mydata$c_s3q5_other[2834] <- "Other"
mydata$c_s3q5_other[2842] <- "Other"
mydata$c_s3q5_other[2843] <- "Other"
mydata$c_s3q5_other[2844] <- "Other"
mydata$c_s3q5_other[2845] <- "Other"
mydata$c_s3q5_other[2856] <- "Other"
mydata$c_s3q5_other[2857] <- "Other"
mydata$c_s3q5_other[2861] <- "Other"
mydata$c_s3q5_other[2862] <- "Other"
mydata$c_s3q5_other[2871] <- "Other"
mydata$c_s3q5_other[2872] <- "Other"
mydata$c_s3q5_other[2911] <- "Other"
mydata$c_s3q5_other[2914] <- "Other"
mydata$c_s3q5_other[2927] <- "Other"
mydata$c_s3q5_other[2942] <- "Other"
mydata$c_s3q5_other[2943] <- "Other"
mydata$c_s3q5_other[2945] <- "Other"
mydata$c_s3q5_other[2950] <- "Other"
mydata$c_s3q5_other[2952] <- "Other"
mydata$c_s3q5_other[2953] <- "Other"
mydata$c_s3q5_other[2954] <- "Other"
mydata$c_s3q5_other[2958] <- "Other"
mydata$c_s3q5_other[2959] <- "Other"
mydata$c_s3q5_other[2966] <- "Other"
mydata$c_s3q5_other[2983] <- "Other"
mydata$c_s3q5_other[2984] <- "Other"
mydata$c_s3q5_other[2985] <- "Other"
mydata$c_s3q5_other[2986] <- "Other"
mydata$c_s3q5_other[2987] <- "Other"
mydata$c_s3q5_other[2990] <- "Other"
mydata$c_s3q5_other[2991] <- "Other"
mydata$c_s3q5_other[2995] <- "Other"
mydata$c_s3q5_other[2999] <- "Other"
mydata$c_s3q5_other[3003] <- "Other"
mydata$c_s3q5_other[3004] <- "Other"
mydata$c_s3q5_other[3005] <- "Other"
mydata$c_s3q5_other[3007] <- "Other"
mydata$c_s3q5_other[3035] <- "Other"
mydata$c_s3q5_other[3036] <- "Other"
mydata$c_s3q5_other[3037] <- "Other"
mydata$c_s3q5_other[3039] <- "Other"
mydata$c_s3q5_other[3044] <- "Other"
mydata$c_s3q5_other[3053] <- "Other"
mydata$c_s3q5_other[3054] <- "Other"
mydata$c_s3q5_other[3055] <- "Other"
mydata$c_s3q5_other[3056] <- "Other"
mydata$c_s3q5_other[3057] <- "Other"
mydata$c_s3q5_other[3061] <- "Other"
mydata$c_s3q5_other[3062] <- "Other"
mydata$c_s3q5_other[3067] <- "Other"
mydata$c_s3q5_other[3068] <- "Other"
mydata$c_s3q5_other[3073] <- "Other"
mydata$c_s3q5_other[3082] <- "Other"
mydata$c_s3q5_other[3105] <- "Other"
mydata$c_s3q5_other[3112] <- "Other"
mydata$c_s3q5_other[3115] <- "Other"
mydata$c_s3q5_other[3407] <- "Other"
mydata$c_s3q5_other[3414] <- "Other"
mydata$c_s3q5_other[3415] <- "Other"
mydata$c_s3q5_other[3506] <- "Other"
mydata$c_s3q5_other[3510] <- "Other"
mydata$c_s3q5_other[3511] <- "Other"
mydata$c_s3q5_other[3512] <- "Other"
mydata$c_s3q5_other[3519] <- "Other"
mydata$c_s3q5_other[3520] <- "Other"
mydata$c_s3q5_other[3524] <- "Other"
mydata$c_s3q5_other[3525] <- "Other"
mydata$c_s3q5_other[3526] <- "Other"
mydata$c_s3q5_other[3532] <- "Other"
mydata$c_s3q5_other[3538] <- "Other"
mydata$c_s3q5_other[3550] <- "Other"
mydata$c_s3q5_other[3554] <- "Other"
mydata$c_s3q5_other[3555] <- "Other"
mydata$c_s3q5_other[3556] <- "Other"
mydata$c_s3q5_other[3560] <- "Other"
mydata$c_s3q5_other[3576] <- "Other"
mydata$c_s3q5_other[3577] <- "Other"
mydata$c_s3q5_other[3583] <- "Other"
mydata$c_s3q5_other[3609] <- "Other"
mydata$c_s3q5_other[3613] <- "Other"
mydata$c_s3q5_other[3615] <- "Other"
mydata$c_s3q5_other[3617] <- "Other"
mydata$c_s3q5_other[3624] <- "Other"
mydata$c_s3q5_other[3625] <- "Other"
mydata$c_s3q5_other[3648] <- "Other"
mydata$c_s3q5_other[3661] <- "Other"
mydata$c_s3q5_other[3666] <- "Other"
mydata$c_s3q5_other[3671] <- "Other"
mydata$c_s3q5_other[3681] <- "Other"
mydata$c_s3q5_other[3688] <- "Other"
mydata$c_s3q5_other[3689] <- "Other"
mydata$c_s3q5_other[3695] <- "Other"
mydata$c_s3q5_other[3698] <- "Other"
mydata$c_s3q5_other[3699] <- "Other"
mydata$c_s3q5_other[3703] <- "Other"
mydata$c_s3q5_other[3706] <- "Other"
mydata$c_s3q5_other[3709] <- "Other"
mydata$c_s3q5_other[3710] <- "Other"
mydata$c_s3q5_other[3719] <- "Other"
mydata$c_s3q5_other[3721] <- "Other"
mydata$c_s3q5_other[3727] <- "Other"
mydata$c_s3q5_other[3729] <- "Other"
mydata$c_s3q5_other[3740] <- "Other"
mydata$c_s3q5_other[3741] <- "Other"
mydata$c_s3q5_other[3759] <- "Other"
mydata$c_s3q5_other[3776] <- "Other"
mydata$c_s3q5_other[3831] <- "Other"
mydata$c_s3q5_other[3973] <- "Other"
mydata$c_s3q5_other[3974] <- "Other"
mydata$c_s3q5_other[3975] <- "Other"
mydata$c_s3q5_other[3976] <- "Other"
mydata$c_s3q5_other[3977] <- "Other"
mydata$c_s3q5_other[3984] <- "Other"
mydata$c_s3q5_other[3989] <- "Other"
mydata$c_s3q5_other[3991] <- "Other"
mydata$c_s3q5_other[3992] <- "Other"
mydata$c_s3q5_other[3993] <- "Other"
mydata$c_s3q5_other[3995] <- "Other"
mydata$c_s3q5_other[3996] <- "Other"
mydata$c_s3q5_other[3997] <- "Other"
mydata$c_s3q5_other[3999] <- "Other"
mydata$c_s3q5_other[4000] <- "Other"
mydata$c_s3q5_other[4001] <- "Other"
mydata$c_s3q5_other[4002] <- "Other"
mydata$c_s3q5_other[4006] <- "Other"
mydata$c_s3q5_other[4009] <- "Other"
mydata$c_s3q5_other[4010] <- "Other"
mydata$c_s3q5_other[4011] <- "Other"
mydata$c_s3q5_other[4013] <- "Other"
mydata$c_s3q5_other[4015] <- "Other"
mydata$c_s3q5_other[4020] <- "Other"
mydata$c_s3q5_other[4021] <- "Other"
mydata$c_s3q5_other[4022] <- "Other"
mydata$c_s3q5_other[4023] <- "Other"
mydata$c_s3q5_other[4024] <- "Other"
mydata$c_s3q5_other[4025] <- "Other"
mydata$c_s3q5_other[4026] <- "Other"
mydata$c_s3q5_other[4027] <- "Other"
mydata$c_s3q5_other[4028] <- "Other"
mydata$c_s3q5_other[4029] <- "Other"
mydata$c_s3q5_other[4030] <- "Other"
mydata$c_s3q5_other[4031] <- "Other"
mydata$c_s3q5_other[4033] <- "Other"
mydata$c_s3q5_other[4040] <- "Other"
mydata$c_s3q5_other[4041] <- "Other"
mydata$c_s3q5_other[4045] <- "Other"
mydata$c_s3q5_other[4046] <- "Other"
mydata$c_s3q5_other[4047] <- "Other"
mydata$c_s3q5_other[4056] <- "Other"
mydata$c_s3q5_other[4057] <- "Other"
mydata$c_s3q5_other[4058] <- "Other"
mydata$c_s3q5_other[4059] <- "Other"
mydata$c_s3q5_other[4060] <- "Other"
mydata$c_s3q5_other[4065] <- "Other"
mydata$c_s3q5_other[4270] <- "Other"
mydata$c_s3q5_other[4273] <- "Other"
mydata$c_s3q5_other[4274] <- "Other"
mydata$c_s3q5_other[4275] <- "Other"
mydata$c_s3q5_other[4283] <- "Other"
mydata$c_s3q5_other[4284] <- "Other"
mydata$c_s3q5_other[4285] <- "Other"
mydata$c_s3q5_other[4287] <- "Other"
mydata$c_s3q5_other[4288] <- "Other"
mydata$c_s3q5_other[4294] <- "Other"
mydata$c_s3q5_other[4301] <- "Other"

mydata$c_s3q5noresponse[335] <- "Other"
mydata$c_s3q5noresponse[336] <- "Other"
mydata$c_s3q5noresponse[383] <- "Other"
mydata$c_s3q5noresponse[742] <- "Other"
mydata$c_s3q5noresponse[1010] <- "Other"
mydata$c_s3q5noresponse[1290] <- "Other"
mydata$c_s3q5noresponse[1320] <- "Other"
mydata$c_s3q5noresponse[1327] <- "Other"
mydata$c_s3q5noresponse[1419] <- "Other"
mydata$c_s3q5noresponse[1491] <- "Other"
mydata$c_s3q5noresponse[1493] <- "Other"
mydata$c_s3q5noresponse[1496] <- "Other"
mydata$c_s3q5noresponse[1560] <- "Other"
mydata$c_s3q5noresponse[1595] <- "Other"
mydata$c_s3q5noresponse[1615] <- "Other"
mydata$c_s3q5noresponse[1617] <- "Other"
mydata$c_s3q5noresponse[1678] <- "Other"
mydata$c_s3q5noresponse[1685] <- "Other"
mydata$c_s3q5noresponse[1749] <- "Other"
mydata$c_s3q5noresponse[1754] <- "Other"
mydata$c_s3q5noresponse[1771] <- "Other"
mydata$c_s3q5noresponse[1799] <- "Other"
mydata$c_s3q5noresponse[1822] <- "Other"
mydata$c_s3q5noresponse[1827] <- "Other"
mydata$c_s3q5noresponse[1828] <- "Other"
mydata$c_s3q5noresponse[1833] <- "Other"
mydata$c_s3q5noresponse[1834] <- "Other"
mydata$c_s3q5noresponse[1837] <- "Other"
mydata$c_s3q5noresponse[1838] <- "Other"
mydata$c_s3q5noresponse[1857] <- "Other"
mydata$c_s3q5noresponse[1900] <- "Other"
mydata$c_s3q5noresponse[1998] <- "Other"
mydata$c_s3q5noresponse[2086] <- "Other"
mydata$c_s3q5noresponse[2161] <- "Other"
mydata$c_s3q5noresponse[2203] <- "Other"
mydata$c_s3q5noresponse[2660] <- "Other"
mydata$c_s3q5noresponse[3247] <- "Other"
mydata$c_s3q5noresponse[3933] <- "Other"
mydata$c_s3q5noresponse[626] <- "Other"
mydata$c_s3q5noresponse[645] <- "Other"
mydata$c_s3q5noresponse[652] <- "Other"
mydata$c_s3q5noresponse[680] <- "Other"
mydata$c_s3q5noresponse[684] <- "Other"
mydata$c_s3q5noresponse[700] <- "Other"
mydata$c_s3q5noresponse[712] <- "Other"
mydata$c_s3q5noresponse[739] <- "Other"
mydata$c_s3q5noresponse[740] <- "Other"
mydata$c_s3q5noresponse[741] <- "Other"
mydata$c_s3q5noresponse[748] <- "Other"
mydata$c_s3q5noresponse[749] <- "Other"
mydata$c_s3q5noresponse[750] <- "Other"
mydata$c_s3q5noresponse[751] <- "Other"
mydata$c_s3q5noresponse[759] <- "Other"
mydata$c_s3q5noresponse[769] <- "Other"
mydata$c_s3q5noresponse[774] <- "Other"
mydata$c_s3q5noresponse[778] <- "Other"
mydata$c_s3q5noresponse[779] <- "Other"
mydata$c_s3q5noresponse[781] <- "Other"
mydata$c_s3q5noresponse[784] <- "Other"
mydata$c_s3q5noresponse[800] <- "Other"
mydata$c_s3q5noresponse[801] <- "Other"
mydata$c_s3q5noresponse[803] <- "Other"
mydata$c_s3q5noresponse[804] <- "Other"
mydata$c_s3q5noresponse[805] <- "Other"
mydata$c_s3q5noresponse[810] <- "Other"
mydata$c_s3q5noresponse[812] <- "Other"
mydata$c_s3q5noresponse[816] <- "Other"
mydata$c_s3q5noresponse[821] <- "Other"
mydata$c_s3q5noresponse[824] <- "Other"
mydata$c_s3q5noresponse[825] <- "Other"
mydata$c_s3q5noresponse[832] <- "Other"
mydata$c_s3q5noresponse[843] <- "Other"
mydata$c_s3q5noresponse[844] <- "Other"
mydata$c_s3q5noresponse[846] <- "Other"
mydata$c_s3q5noresponse[847] <- "Other"
mydata$c_s3q5noresponse[851] <- "Other"
mydata$c_s3q5noresponse[853] <- "Other"
mydata$c_s3q5noresponse[854] <- "Other"
mydata$c_s3q5noresponse[855] <- "Other"
mydata$c_s3q5noresponse[859] <- "Other"
mydata$c_s3q5noresponse[860] <- "Other"
mydata$c_s3q5noresponse[864] <- "Other"
mydata$c_s3q5noresponse[865] <- "Other"
mydata$c_s3q5noresponse[877] <- "Other"
mydata$c_s3q5noresponse[883] <- "Other"
mydata$c_s3q5noresponse[884] <- "Other"
mydata$c_s3q5noresponse[886] <- "Other"
mydata$c_s3q5noresponse[888] <- "Other"
mydata$c_s3q5noresponse[889] <- "Other"
mydata$c_s3q5noresponse[891] <- "Other"
mydata$c_s3q5noresponse[899] <- "Other"
mydata$c_s3q5noresponse[900] <- "Other"
mydata$c_s3q5noresponse[902] <- "Other"
mydata$c_s3q5noresponse[906] <- "Other"
mydata$c_s3q5noresponse[907] <- "Other"
mydata$c_s3q5noresponse[908] <- "Other"
mydata$c_s3q5noresponse[913] <- "Other"
mydata$c_s3q5noresponse[915] <- "Other"
mydata$c_s3q5noresponse[916] <- "Other"
mydata$c_s3q5noresponse[952] <- "Other"
mydata$c_s3q5noresponse[954] <- "Other"
mydata$c_s3q5noresponse[962] <- "Other"
mydata$c_s3q5noresponse[970] <- "Other"
mydata$c_s3q5noresponse[971] <- "Other"
mydata$c_s3q5noresponse[975] <- "Other"
mydata$c_s3q5noresponse[978] <- "Other"
mydata$c_s3q5noresponse[979] <- "Other"
mydata$c_s3q5noresponse[980] <- "Other"
mydata$c_s3q5noresponse[985] <- "Other"
mydata$c_s3q5noresponse[987] <- "Other"
mydata$c_s3q5noresponse[988] <- "Other"
mydata$c_s3q5noresponse[991] <- "Other"
mydata$c_s3q5noresponse[992] <- "Other"
mydata$c_s3q5noresponse[996] <- "Other"
mydata$c_s3q5noresponse[1000] <- "Other"
mydata$c_s3q5noresponse[1002] <- "Other"
mydata$c_s3q5noresponse[1004] <- "Other"
mydata$c_s3q5noresponse[1009] <- "Other"
mydata$c_s3q5noresponse[1018] <- "Other"
mydata$c_s3q5noresponse[1021] <- "Other"
mydata$c_s3q5noresponse[1023] <- "Other"
mydata$c_s3q5noresponse[1025] <- "Other"
mydata$c_s3q5noresponse[1028] <- "Other"
mydata$c_s3q5noresponse[1029] <- "Other"
mydata$c_s3q5noresponse[1034] <- "Other"
mydata$c_s3q5noresponse[1036] <- "Other"
mydata$c_s3q5noresponse[1044] <- "Other"
mydata$c_s3q5noresponse[1055] <- "Other"
mydata$c_s3q5noresponse[1060] <- "Other"
mydata$c_s3q5noresponse[1064] <- "Other"
mydata$c_s3q5noresponse[1072] <- "Other"
mydata$c_s3q5noresponse[1073] <- "Other"
mydata$c_s3q5noresponse[1076] <- "Other"
mydata$c_s3q5noresponse[1083] <- "Other"
mydata$c_s3q5noresponse[1086] <- "Other"
mydata$c_s3q5noresponse[1093] <- "Other"
mydata$c_s3q5noresponse[1094] <- "Other"
mydata$c_s3q5noresponse[1097] <- "Other"
mydata$c_s3q5noresponse[1104] <- "Other"
mydata$c_s3q5noresponse[1105] <- "Other"
mydata$c_s3q5noresponse[1106] <- "Other"
mydata$c_s3q5noresponse[1128] <- "Other"
mydata$c_s3q5noresponse[1132] <- "Other"
mydata$c_s3q5noresponse[1134] <- "Other"
mydata$c_s3q5noresponse[1138] <- "Other"
mydata$c_s3q5noresponse[1158] <- "Other"
mydata$c_s3q5noresponse[1162] <- "Other"
mydata$c_s3q5noresponse[1166] <- "Other"
mydata$c_s3q5noresponse[1734] <- "Other"
mydata$c_s3q5noresponse[2148] <- "Other"
mydata$c_s3q5noresponse[2354] <- "Other"
mydata$c_s3q5noresponse[2473] <- "Other"
mydata$c_s3q5noresponse[2497] <- "Other"
mydata$c_s3q5noresponse[2499] <- "Other"
mydata$c_s3q5noresponse[2500] <- "Other"
mydata$c_s3q5noresponse[2512] <- "Other"
mydata$c_s3q5noresponse[2524] <- "Other"
mydata$c_s3q5noresponse[2525] <- "Other"
mydata$c_s3q5noresponse[2526] <- "Other"
mydata$c_s3q5noresponse[2527] <- "Other"
mydata$c_s3q5noresponse[2542] <- "Other"
mydata$c_s3q5noresponse[2546] <- "Other"
mydata$c_s3q5noresponse[2560] <- "Other"
mydata$c_s3q5noresponse[2674] <- "Other"
mydata$c_s3q5noresponse[2685] <- "Other"
mydata$c_s3q5noresponse[2690] <- "Other"
mydata$c_s3q5noresponse[2695] <- "Other"
mydata$c_s3q5noresponse[2702] <- "Other"
mydata$c_s3q5noresponse[2709] <- "Other"
mydata$c_s3q5noresponse[2710] <- "Other"
mydata$c_s3q5noresponse[2719] <- "Other"
mydata$c_s3q5noresponse[2728] <- "Other"
mydata$c_s3q5noresponse[2735] <- "Other"
mydata$c_s3q5noresponse[2736] <- "Other"
mydata$c_s3q5noresponse[2737] <- "Other"
mydata$c_s3q5noresponse[2761] <- "Other"
mydata$c_s3q5noresponse[2762] <- "Other"
mydata$c_s3q5noresponse[2768] <- "Other"
mydata$c_s3q5noresponse[2771] <- "Other"
mydata$c_s3q5noresponse[2789] <- "Other"
mydata$c_s3q5noresponse[2792] <- "Other"
mydata$c_s3q5noresponse[2793] <- "Other"
mydata$c_s3q5noresponse[2802] <- "Other"
mydata$c_s3q5noresponse[2803] <- "Other"
mydata$c_s3q5noresponse[2822] <- "Other"
mydata$c_s3q5noresponse[2823] <- "Other"
mydata$c_s3q5noresponse[2824] <- "Other"
mydata$c_s3q5noresponse[2830] <- "Other"
mydata$c_s3q5noresponse[2832] <- "Other"
mydata$c_s3q5noresponse[2833] <- "Other"
mydata$c_s3q5noresponse[2834] <- "Other"
mydata$c_s3q5noresponse[2842] <- "Other"
mydata$c_s3q5noresponse[2843] <- "Other"
mydata$c_s3q5noresponse[2844] <- "Other"
mydata$c_s3q5noresponse[2845] <- "Other"
mydata$c_s3q5noresponse[2856] <- "Other"
mydata$c_s3q5noresponse[2857] <- "Other"
mydata$c_s3q5noresponse[2861] <- "Other"
mydata$c_s3q5noresponse[2862] <- "Other"
mydata$c_s3q5noresponse[2871] <- "Other"
mydata$c_s3q5noresponse[2872] <- "Other"
mydata$c_s3q5noresponse[2911] <- "Other"
mydata$c_s3q5noresponse[2914] <- "Other"
mydata$c_s3q5noresponse[2927] <- "Other"
mydata$c_s3q5noresponse[2942] <- "Other"
mydata$c_s3q5noresponse[2943] <- "Other"
mydata$c_s3q5noresponse[2945] <- "Other"
mydata$c_s3q5noresponse[2950] <- "Other"
mydata$c_s3q5noresponse[2952] <- "Other"
mydata$c_s3q5noresponse[2953] <- "Other"
mydata$c_s3q5noresponse[2954] <- "Other"
mydata$c_s3q5noresponse[2958] <- "Other"
mydata$c_s3q5noresponse[2959] <- "Other"
mydata$c_s3q5noresponse[2966] <- "Other"
mydata$c_s3q5noresponse[2983] <- "Other"
mydata$c_s3q5noresponse[2984] <- "Other"
mydata$c_s3q5noresponse[2985] <- "Other"
mydata$c_s3q5noresponse[2986] <- "Other"
mydata$c_s3q5noresponse[2987] <- "Other"
mydata$c_s3q5noresponse[2990] <- "Other"
mydata$c_s3q5noresponse[2991] <- "Other"
mydata$c_s3q5noresponse[2995] <- "Other"
mydata$c_s3q5noresponse[2999] <- "Other"
mydata$c_s3q5noresponse[3003] <- "Other"
mydata$c_s3q5noresponse[3004] <- "Other"
mydata$c_s3q5noresponse[3005] <- "Other"
mydata$c_s3q5noresponse[3007] <- "Other"
mydata$c_s3q5noresponse[3035] <- "Other"
mydata$c_s3q5noresponse[3036] <- "Other"
mydata$c_s3q5noresponse[3037] <- "Other"
mydata$c_s3q5noresponse[3039] <- "Other"
mydata$c_s3q5noresponse[3044] <- "Other"
mydata$c_s3q5noresponse[3053] <- "Other"
mydata$c_s3q5noresponse[3054] <- "Other"
mydata$c_s3q5noresponse[3055] <- "Other"
mydata$c_s3q5noresponse[3056] <- "Other"
mydata$c_s3q5noresponse[3057] <- "Other"
mydata$c_s3q5noresponse[3061] <- "Other"
mydata$c_s3q5noresponse[3062] <- "Other"
mydata$c_s3q5noresponse[3067] <- "Other"
mydata$c_s3q5noresponse[3068] <- "Other"
mydata$c_s3q5noresponse[3073] <- "Other"
mydata$c_s3q5noresponse[3082] <- "Other"
mydata$c_s3q5noresponse[3105] <- "Other"
mydata$c_s3q5noresponse[3112] <- "Other"
mydata$c_s3q5noresponse[3115] <- "Other"
mydata$c_s3q5noresponse[3407] <- "Other"
mydata$c_s3q5noresponse[3414] <- "Other"
mydata$c_s3q5noresponse[3415] <- "Other"
mydata$c_s3q5noresponse[3506] <- "Other"
mydata$c_s3q5noresponse[3510] <- "Other"
mydata$c_s3q5noresponse[3511] <- "Other"
mydata$c_s3q5noresponse[3512] <- "Other"
mydata$c_s3q5noresponse[3519] <- "Other"
mydata$c_s3q5noresponse[3520] <- "Other"
mydata$c_s3q5noresponse[3524] <- "Other"
mydata$c_s3q5noresponse[3525] <- "Other"
mydata$c_s3q5noresponse[3526] <- "Other"
mydata$c_s3q5noresponse[3532] <- "Other"
mydata$c_s3q5noresponse[3538] <- "Other"
mydata$c_s3q5noresponse[3550] <- "Other"
mydata$c_s3q5noresponse[3554] <- "Other"
mydata$c_s3q5noresponse[3555] <- "Other"
mydata$c_s3q5noresponse[3556] <- "Other"
mydata$c_s3q5noresponse[3560] <- "Other"
mydata$c_s3q5noresponse[3576] <- "Other"
mydata$c_s3q5noresponse[3577] <- "Other"
mydata$c_s3q5noresponse[3583] <- "Other"
mydata$c_s3q5noresponse[3609] <- "Other"
mydata$c_s3q5noresponse[3613] <- "Other"
mydata$c_s3q5noresponse[3615] <- "Other"
mydata$c_s3q5noresponse[3617] <- "Other"
mydata$c_s3q5noresponse[3624] <- "Other"
mydata$c_s3q5noresponse[3625] <- "Other"
mydata$c_s3q5noresponse[3648] <- "Other"
mydata$c_s3q5noresponse[3661] <- "Other"
mydata$c_s3q5noresponse[3666] <- "Other"
mydata$c_s3q5noresponse[3671] <- "Other"
mydata$c_s3q5noresponse[3681] <- "Other"
mydata$c_s3q5noresponse[3688] <- "Other"
mydata$c_s3q5noresponse[3689] <- "Other"
mydata$c_s3q5noresponse[3695] <- "Other"
mydata$c_s3q5noresponse[3698] <- "Other"
mydata$c_s3q5noresponse[3699] <- "Other"
mydata$c_s3q5noresponse[3703] <- "Other"
mydata$c_s3q5noresponse[3706] <- "Other"
mydata$c_s3q5noresponse[3709] <- "Other"
mydata$c_s3q5noresponse[3710] <- "Other"
mydata$c_s3q5noresponse[3719] <- "Other"
mydata$c_s3q5noresponse[3721] <- "Other"
mydata$c_s3q5noresponse[3727] <- "Other"
mydata$c_s3q5noresponse[3729] <- "Other"
mydata$c_s3q5noresponse[3740] <- "Other"
mydata$c_s3q5noresponse[3741] <- "Other"
mydata$c_s3q5noresponse[3759] <- "Other"
mydata$c_s3q5noresponse[3776] <- "Other"
mydata$c_s3q5noresponse[3831] <- "Other"
mydata$c_s3q5noresponse[3973] <- "Other"
mydata$c_s3q5noresponse[3974] <- "Other"
mydata$c_s3q5noresponse[3975] <- "Other"
mydata$c_s3q5noresponse[3976] <- "Other"
mydata$c_s3q5noresponse[3977] <- "Other"
mydata$c_s3q5noresponse[3984] <- "Other"
mydata$c_s3q5noresponse[3989] <- "Other"
mydata$c_s3q5noresponse[3991] <- "Other"
mydata$c_s3q5noresponse[3992] <- "Other"
mydata$c_s3q5noresponse[3993] <- "Other"
mydata$c_s3q5noresponse[3995] <- "Other"
mydata$c_s3q5noresponse[3996] <- "Other"
mydata$c_s3q5noresponse[3997] <- "Other"
mydata$c_s3q5noresponse[3999] <- "Other"
mydata$c_s3q5noresponse[4000] <- "Other"
mydata$c_s3q5noresponse[4001] <- "Other"
mydata$c_s3q5noresponse[4002] <- "Other"
mydata$c_s3q5noresponse[4006] <- "Other"
mydata$c_s3q5noresponse[4009] <- "Other"
mydata$c_s3q5noresponse[4010] <- "Other"
mydata$c_s3q5noresponse[4011] <- "Other"
mydata$c_s3q5noresponse[4013] <- "Other"
mydata$c_s3q5noresponse[4015] <- "Other"
mydata$c_s3q5noresponse[4020] <- "Other"
mydata$c_s3q5noresponse[4021] <- "Other"
mydata$c_s3q5noresponse[4022] <- "Other"
mydata$c_s3q5noresponse[4023] <- "Other"
mydata$c_s3q5noresponse[4024] <- "Other"
mydata$c_s3q5noresponse[4025] <- "Other"
mydata$c_s3q5noresponse[4026] <- "Other"
mydata$c_s3q5noresponse[4027] <- "Other"
mydata$c_s3q5noresponse[4028] <- "Other"
mydata$c_s3q5noresponse[4029] <- "Other"
mydata$c_s3q5noresponse[4030] <- "Other"
mydata$c_s3q5noresponse[4031] <- "Other"
mydata$c_s3q5noresponse[4033] <- "Other"
mydata$c_s3q5noresponse[4040] <- "Other"
mydata$c_s3q5noresponse[4041] <- "Other"
mydata$c_s3q5noresponse[4045] <- "Other"
mydata$c_s3q5noresponse[4046] <- "Other"
mydata$c_s3q5noresponse[4047] <- "Other"
mydata$c_s3q5noresponse[4056] <- "Other"
mydata$c_s3q5noresponse[4057] <- "Other"
mydata$c_s3q5noresponse[4058] <- "Other"
mydata$c_s3q5noresponse[4059] <- "Other"
mydata$c_s3q5noresponse[4060] <- "Other"
mydata$c_s3q5noresponse[4065] <- "Other"
mydata$c_s3q5noresponse[4270] <- "Other"
mydata$c_s3q5noresponse[4273] <- "Other"
mydata$c_s3q5noresponse[4274] <- "Other"
mydata$c_s3q5noresponse[4275] <- "Other"
mydata$c_s3q5noresponse[4283] <- "Other"
mydata$c_s3q5noresponse[4284] <- "Other"
mydata$c_s3q5noresponse[4285] <- "Other"
mydata$c_s3q5noresponse[4287] <- "Other"
mydata$c_s3q5noresponse[4288] <- "Other"
mydata$c_s3q5noresponse[4294] <- "Other"
mydata$c_s3q5noresponse[4301] <- "Other"
mydata$c_s3q5noresponse[4000] <- "Other"
mydata$c_s3q5noresponse[4001] <- "Other"
mydata$c_s3q5noresponse[4002] <- "Other"
mydata$c_s3q5noresponse[4006] <- "Other"
mydata$c_s3q5noresponse[4010] <- "Other"
mydata$c_s3q5noresponse[4011] <- "Other"
mydata$c_s3q5noresponse[4013] <- "Other"
mydata$c_s3q5noresponse[4015] <- "Other"
mydata$c_s3q5noresponse[4017] <- "Other"
mydata$c_s3q5noresponse[4018] <- "Other"
mydata$c_s3q5noresponse[4020] <- "Other"
mydata$c_s3q5noresponse[4021] <- "Other"
mydata$c_s3q5noresponse[4022] <- "Other"
mydata$c_s3q5noresponse[4023] <- "Other"
mydata$c_s3q5noresponse[4024] <- "Other"
mydata$c_s3q5noresponse[4025] <- "Other"
mydata$c_s3q5noresponse[4026] <- "Other"
mydata$c_s3q5noresponse[4027] <- "Other"
mydata$c_s3q5noresponse[4028] <- "Other"
mydata$c_s3q5noresponse[4033] <- "Other"
mydata$c_s3q5noresponse[4040] <- "Other"
mydata$c_s3q5noresponse[4041] <- "Other"
mydata$c_s3q5noresponse[4044] <- "Other"
mydata$c_s3q5noresponse[4045] <- "Other"
mydata$c_s3q5noresponse[4046] <- "Other"
mydata$c_s3q5noresponse[4047] <- "Other"
mydata$c_s3q5noresponse[4056] <- "Other"
mydata$c_s3q5noresponse[4057] <- "Other"
mydata$c_s3q5noresponse[4058] <- "Other"
mydata$c_s3q5noresponse[4059] <- "Other"
mydata$c_s3q5noresponse[4060] <- "Other"
mydata$c_s3q5noresponse[4254] <- "Other"
mydata$c_s3q5noresponse[4261] <- "Other"
mydata$c_s3q5noresponse[4270] <- "Other"
mydata$c_s3q5noresponse[4273] <- "Other"
mydata$c_s3q5noresponse[4274] <- "Other"
mydata$c_s3q5noresponse[4275] <- "Other"
mydata$c_s3q5noresponse[4284] <- "Other"
mydata$c_s3q5noresponse[4285] <- "Other"
mydata$c_s3q5noresponse[4287] <- "Other"
mydata$c_s3q5noresponse[4288] <- "Other"
mydata$c_s3q5noresponse[4294] <- "Other"
mydata$c_s3q5noresponse[4301] <- "Other"

mydata$c_s3q6_other[45] <- "Other"
mydata$c_s3q6_other[49] <- "Other"
mydata$c_s3q6_other[68] <- "Other"
mydata$c_s3q6_other[199] <- "Other"
mydata$c_s3q6_other[238] <- "Other"
mydata$c_s3q6_other[258] <- "Other"
mydata$c_s3q6_other[276] <- "Other"
mydata$c_s3q6_other[336] <- "Other"
mydata$c_s3q6_other[612] <- "Other"
mydata$c_s3q6_other[653] <- "Other"
mydata$c_s3q6_other[703] <- "Other"
mydata$c_s3q6_other[729] <- "Other"
mydata$c_s3q6_other[740] <- "Other"
mydata$c_s3q6_other[757] <- "Other"
mydata$c_s3q6_other[793] <- "Other"
mydata$c_s3q6_other[851] <- "Other"
mydata$c_s3q6_other[853] <- "Other"
mydata$c_s3q6_other[877] <- "Other"
mydata$c_s3q6_other[901] <- "Other"
mydata$c_s3q6_other[922] <- "Other"
mydata$c_s3q6_other[925] <- "Other"
mydata$c_s3q6_other[932] <- "Other"
mydata$c_s3q6_other[953] <- "Other"
mydata$c_s3q6_other[972] <- "Other"
mydata$c_s3q6_other[992] <- "Other"
mydata$c_s3q6_other[995] <- "Other"
mydata$c_s3q6_other[1034] <- "Other"
mydata$c_s3q6_other[1040] <- "Other"
mydata$c_s3q6_other[1072] <- "Other"
mydata$c_s3q6_other[1073] <- "Other"
mydata$c_s3q6_other[1112] <- "Other"
mydata$c_s3q6_other[1123] <- "Other"
mydata$c_s3q6_other[1128] <- "Other"
mydata$c_s3q6_other[1133] <- "Other"
mydata$c_s3q6_other[1144] <- "Other"
mydata$c_s3q6_other[1163] <- "Other"
mydata$c_s3q6_other[1183] <- "Other"
mydata$c_s3q6_other[1185] <- "Other"
mydata$c_s3q6_other[1232] <- "Other"
mydata$c_s3q6_other[1252] <- "Other"
mydata$c_s3q6_other[1307] <- "Other"
mydata$c_s3q6_other[1345] <- "Other"
mydata$c_s3q6_other[1367] <- "Other"
mydata$c_s3q6_other[1368] <- "Other"
mydata$c_s3q6_other[1399] <- "Other"
mydata$c_s3q6_other[1418] <- "Other"
mydata$c_s3q6_other[1419] <- "Other"
mydata$c_s3q6_other[1450] <- "Other"
mydata$c_s3q6_other[1456] <- "Other"
mydata$c_s3q6_other[1484] <- "Other"
mydata$c_s3q6_other[1485] <- "Other"
mydata$c_s3q6_other[1491] <- "Other"
mydata$c_s3q6_other[1493] <- "Other"
mydata$c_s3q6_other[1499] <- "Other"
mydata$c_s3q6_other[1520] <- "Other"
mydata$c_s3q6_other[1560] <- "Other"
mydata$c_s3q6_other[1572] <- "Other"
mydata$c_s3q6_other[1574] <- "Other"
mydata$c_s3q6_other[1583] <- "Other"
mydata$c_s3q6_other[1595] <- "Other"
mydata$c_s3q6_other[1596] <- "Other"
mydata$c_s3q6_other[1599] <- "Other"
mydata$c_s3q6_other[1606] <- "Other"
mydata$c_s3q6_other[1647] <- "Other"
mydata$c_s3q6_other[1664] <- "Other"
mydata$c_s3q6_other[1685] <- "Other"
mydata$c_s3q6_other[1707] <- "Other"
mydata$c_s3q6_other[1712] <- "Other"
mydata$c_s3q6_other[1713] <- "Other"
mydata$c_s3q6_other[1754] <- "Other"
mydata$c_s3q6_other[1771] <- "Other"
mydata$c_s3q6_other[1773] <- "Other"
mydata$c_s3q6_other[1779] <- "Other"
mydata$c_s3q6_other[1787] <- "Other"
mydata$c_s3q6_other[1791] <- "Other"
mydata$c_s3q6_other[1797] <- "Other"
mydata$c_s3q6_other[1798] <- "Other"
mydata$c_s3q6_other[1799] <- "Other"
mydata$c_s3q6_other[1803] <- "Other"
mydata$c_s3q6_other[1847] <- "Other"
mydata$c_s3q6_other[1861] <- "Other"
mydata$c_s3q6_other[1899] <- "Other"
mydata$c_s3q6_other[1901] <- "Other"
mydata$c_s3q6_other[1922] <- "Other"
mydata$c_s3q6_other[1936] <- "Other"
mydata$c_s3q6_other[2033] <- "Other"
mydata$c_s3q6_other[2153] <- "Other"
mydata$c_s3q6_other[2275] <- "Other"
mydata$c_s3q6_other[2366] <- "Other"
mydata$c_s3q6_other[2369] <- "Other"
mydata$c_s3q6_other[2371] <- "Other"
mydata$c_s3q6_other[2378] <- "Other"
mydata$c_s3q6_other[2397] <- "Other"
mydata$c_s3q6_other[2470] <- "Other"
mydata$c_s3q6_other[2471] <- "Other"
mydata$c_s3q6_other[2482] <- "Other"
mydata$c_s3q6_other[2580] <- "Other"
mydata$c_s3q6_other[2590] <- "Other"
mydata$c_s3q6_other[2603] <- "Other"
mydata$c_s3q6_other[2610] <- "Other"
mydata$c_s3q6_other[2627] <- "Other"
mydata$c_s3q6_other[2629] <- "Other"
mydata$c_s3q6_other[2633] <- "Other"
mydata$c_s3q6_other[2653] <- "Other"
mydata$c_s3q6_other[2666] <- "Other"
mydata$c_s3q6_other[2693] <- "Other"
mydata$c_s3q6_other[2756] <- "Other"
mydata$c_s3q6_other[2766] <- "Other"
mydata$c_s3q6_other[2770] <- "Other"
mydata$c_s3q6_other[2771] <- "Other"
mydata$c_s3q6_other[2783] <- "Other"
mydata$c_s3q6_other[2800] <- "Other"
mydata$c_s3q6_other[2821] <- "Other"
mydata$c_s3q6_other[2850] <- "Other"
mydata$c_s3q6_other[2888] <- "Other"
mydata$c_s3q6_other[2971] <- "Other"
mydata$c_s3q6_other[2998] <- "Other"
mydata$c_s3q6_other[3038] <- "Other"
mydata$c_s3q6_other[3053] <- "Other"
mydata$c_s3q6_other[3063] <- "Other"
mydata$c_s3q6_other[3107] <- "Other"
mydata$c_s3q6_other[3109] <- "Other"
mydata$c_s3q6_other[3165] <- "Other"
mydata$c_s3q6_other[3193] <- "Other"
mydata$c_s3q6_other[3195] <- "Other"
mydata$c_s3q6_other[3196] <- "Other"
mydata$c_s3q6_other[3216] <- "Other"
mydata$c_s3q6_other[3218] <- "Other"
mydata$c_s3q6_other[3220] <- "Other"
mydata$c_s3q6_other[3247] <- "Other"
mydata$c_s3q6_other[3272] <- "Other"
mydata$c_s3q6_other[3288] <- "Other"
mydata$c_s3q6_other[3290] <- "Other"
mydata$c_s3q6_other[3295] <- "Other"
mydata$c_s3q6_other[3296] <- "Other"
mydata$c_s3q6_other[3302] <- "Other"
mydata$c_s3q6_other[3331] <- "Other"
mydata$c_s3q6_other[3339] <- "Other"
mydata$c_s3q6_other[3360] <- "Other"
mydata$c_s3q6_other[3377] <- "Other"
mydata$c_s3q6_other[3378] <- "Other"
mydata$c_s3q6_other[3382] <- "Other"
mydata$c_s3q6_other[3434] <- "Other"
mydata$c_s3q6_other[3441] <- "Other"
mydata$c_s3q6_other[3458] <- "Other"
mydata$c_s3q6_other[3472] <- "Other"
mydata$c_s3q6_other[3480] <- "Other"
mydata$c_s3q6_other[3493] <- "Other"
mydata$c_s3q6_other[3503] <- "Other"
mydata$c_s3q6_other[3529] <- "Other"
mydata$c_s3q6_other[3566] <- "Other"
mydata$c_s3q6_other[3571] <- "Other"
mydata$c_s3q6_other[3597] <- "Other"
mydata$c_s3q6_other[3599] <- "Other"
mydata$c_s3q6_other[3606] <- "Other"
mydata$c_s3q6_other[3618] <- "Other"
mydata$c_s3q6_other[3645] <- "Other"
mydata$c_s3q6_other[3648] <- "Other"
mydata$c_s3q6_other[3714] <- "Other"
mydata$c_s3q6_other[3724] <- "Other"
mydata$c_s3q6_other[3726] <- "Other"
mydata$c_s3q6_other[3744] <- "Other"
mydata$c_s3q6_other[3808] <- "Other"
mydata$c_s3q6_other[3814] <- "Other"
mydata$c_s3q6_other[3821] <- "Other"
mydata$c_s3q6_other[3837] <- "Other"
mydata$c_s3q6_other[3844] <- "Other"
mydata$c_s3q6_other[3853] <- "Other"
mydata$c_s3q6_other[3871] <- "Other"
mydata$c_s3q6_other[3874] <- "Other"
mydata$c_s3q6_other[3899] <- "Other"
mydata$c_s3q6_other[3900] <- "Other"
mydata$c_s3q6_other[3978] <- "Other"
mydata$c_s3q6_other[3995] <- "Other"
mydata$c_s3q6_other[4008] <- "Other"
mydata$c_s3q6_other[4009] <- "Other"
mydata$c_s3q6_other[4016] <- "Other"
mydata$c_s3q6_other[4029] <- "Other"
mydata$c_s3q6_other[4030] <- "Other"
mydata$c_s3q6_other[4031] <- "Other"
mydata$c_s3q6_other[4091] <- "Other"
mydata$c_s3q6_other[4093] <- "Other"
mydata$c_s3q6_other[4131] <- "Other"
mydata$c_s3q6_other[4189] <- "Other"
mydata$c_s3q6_other[4229] <- "Other"
mydata$c_s3q6_other[4272] <- "Other"

mydata$c_s3q6noresponse[731] <- "Other"
mydata$c_s3q6noresponse[741] <- "Other"
mydata$c_s3q6noresponse[748] <- "Other"
mydata$c_s3q6noresponse[872] <- "Other"
mydata$c_s3q6noresponse[952] <- "Other"
mydata$c_s3q6noresponse[978] <- "Other"
mydata$c_s3q6noresponse[1021] <- "Other"
mydata$c_s3q6noresponse[1083] <- "Other"
mydata$c_s3q6noresponse[1090] <- "Other"
mydata$c_s3q6noresponse[1193] <- "Other"
mydata$c_s3q6noresponse[1273] <- "Other"
mydata$c_s3q6noresponse[1327] <- "Other"
mydata$c_s3q6noresponse[1453] <- "Other"
mydata$c_s3q6noresponse[1490] <- "Other"
mydata$c_s3q6noresponse[1496] <- "Other"
mydata$c_s3q6noresponse[1592] <- "Other"
mydata$c_s3q6noresponse[1597] <- "Other"
mydata$c_s3q6noresponse[1598] <- "Other"
mydata$c_s3q6noresponse[1612] <- "Other"
mydata$c_s3q6noresponse[1615] <- "Other"
mydata$c_s3q6noresponse[1630] <- "Other"
mydata$c_s3q6noresponse[1631] <- "Other"
mydata$c_s3q6noresponse[1636] <- "Other"
mydata$c_s3q6noresponse[1645] <- "Other"
mydata$c_s3q6noresponse[1675] <- "Other"
mydata$c_s3q6noresponse[1678] <- "Other"
mydata$c_s3q6noresponse[1719] <- "Other"
mydata$c_s3q6noresponse[1722] <- "Other"
mydata$c_s3q6noresponse[1729] <- "Other"
mydata$c_s3q6noresponse[1815] <- "Other"
mydata$c_s3q6noresponse[1885] <- "Other"
mydata$c_s3q6noresponse[1900] <- "Other"
mydata$c_s3q6noresponse[1943] <- "Other"
mydata$c_s3q6noresponse[1998] <- "Other"
mydata$c_s3q6noresponse[2341] <- "Other"
mydata$c_s3q6noresponse[2386] <- "Other"
mydata$c_s3q6noresponse[2468] <- "Other"
mydata$c_s3q6noresponse[2583] <- "Other"
mydata$c_s3q6noresponse[2585] <- "Other"
mydata$c_s3q6noresponse[2830] <- "Other"
mydata$c_s3q6noresponse[2856] <- "Other"
mydata$c_s3q6noresponse[2857] <- "Other"
mydata$c_s3q6noresponse[2958] <- "Other"
mydata$c_s3q6noresponse[3252] <- "Other"
mydata$c_s3q6noresponse[3254] <- "Other"
mydata$c_s3q6noresponse[3806] <- "Other"
mydata$c_s3q6noresponse[3823] <- "Other"
mydata$c_s3q6noresponse[3902] <- "Other"
mydata$c_s3q6noresponse[3916] <- "Other"
mydata$c_s3q6noresponse[3918] <- "Other"
mydata$c_s3q6noresponse[3968] <- "Other"

mydata$c_s3q7_other[290] <- "Other"
mydata$c_s3q7_other[336] <- "Other"
mydata$c_s3q7_other[609] <- "Other"
mydata$c_s3q7_other[653] <- "Other"
mydata$c_s3q7_other[813] <- "Other"
mydata$c_s3q7_other[901] <- "Other"
mydata$c_s3q7_other[959] <- "Other"
mydata$c_s3q7_other[972] <- "Other"
mydata$c_s3q7_other[973] <- "Other"
mydata$c_s3q7_other[1015] <- "Other"
mydata$c_s3q7_other[1020] <- "Other"
mydata$c_s3q7_other[1040] <- "Other"
mydata$c_s3q7_other[1119] <- "Other"
mydata$c_s3q7_other[1123] <- "Other"
mydata$c_s3q7_other[1183] <- "Other"
mydata$c_s3q7_other[1185] <- "Other"
mydata$c_s3q7_other[1220] <- "Other"
mydata$c_s3q7_other[1232] <- "Other"
mydata$c_s3q7_other[1252] <- "Other"
mydata$c_s3q7_other[1289] <- "Other"
mydata$c_s3q7_other[1314] <- "Other"
mydata$c_s3q7_other[1320] <- "Other"
mydata$c_s3q7_other[1327] <- "Other"
mydata$c_s3q7_other[1358] <- "Other"
mydata$c_s3q7_other[1367] <- "Other"
mydata$c_s3q7_other[1368] <- "Other"
mydata$c_s3q7_other[1399] <- "Other"
mydata$c_s3q7_other[1419] <- "Other"
mydata$c_s3q7_other[1455] <- "Other"
mydata$c_s3q7_other[1484] <- "Other"
mydata$c_s3q7_other[1485] <- "Other"
mydata$c_s3q7_other[1491] <- "Other"
mydata$c_s3q7_other[1493] <- "Other"
mydata$c_s3q7_other[1496] <- "Other"
mydata$c_s3q7_other[1499] <- "Other"
mydata$c_s3q7_other[1520] <- "Other"
mydata$c_s3q7_other[1523] <- "Other"
mydata$c_s3q7_other[1536] <- "Other"
mydata$c_s3q7_other[1560] <- "Other"
mydata$c_s3q7_other[1565] <- "Other"
mydata$c_s3q7_other[1572] <- "Other"
mydata$c_s3q7_other[1573] <- "Other"
mydata$c_s3q7_other[1574] <- "Other"
mydata$c_s3q7_other[1580] <- "Other"
mydata$c_s3q7_other[1584] <- "Other"
mydata$c_s3q7_other[1595] <- "Other"
mydata$c_s3q7_other[1606] <- "Other"
mydata$c_s3q7_other[1615] <- "Other"
mydata$c_s3q7_other[1678] <- "Other"
mydata$c_s3q7_other[1685] <- "Other"
mydata$c_s3q7_other[1707] <- "Other"
mydata$c_s3q7_other[1754] <- "Other"
mydata$c_s3q7_other[1771] <- "Other"
mydata$c_s3q7_other[1773] <- "Other"
mydata$c_s3q7_other[1779] <- "Other"
mydata$c_s3q7_other[1799] <- "Other"
mydata$c_s3q7_other[1801] <- "Other"
mydata$c_s3q7_other[1847] <- "Other"
mydata$c_s3q7_other[1900] <- "Other"
mydata$c_s3q7_other[1998] <- "Other"
mydata$c_s3q7_other[2143] <- "Other"
mydata$c_s3q7_other[2145] <- "Other"
mydata$c_s3q7_other[2153] <- "Other"
mydata$c_s3q7_other[2343] <- "Other"
mydata$c_s3q7_other[2368] <- "Other"
mydata$c_s3q7_other[2378] <- "Other"
mydata$c_s3q7_other[2389] <- "Other"
mydata$c_s3q7_other[2397] <- "Other"
mydata$c_s3q7_other[2469] <- "Other"
mydata$c_s3q7_other[2470] <- "Other"
mydata$c_s3q7_other[2471] <- "Other"
mydata$c_s3q7_other[2483] <- "Other"
mydata$c_s3q7_other[2578] <- "Other"
mydata$c_s3q7_other[2580] <- "Other"
mydata$c_s3q7_other[2583] <- "Other"
mydata$c_s3q7_other[2586] <- "Other"
mydata$c_s3q7_other[2601] <- "Other"
mydata$c_s3q7_other[2603] <- "Other"
mydata$c_s3q7_other[2609] <- "Other"
mydata$c_s3q7_other[2629] <- "Other"
mydata$c_s3q7_other[2693] <- "Other"
mydata$c_s3q7_other[2748] <- "Other"
mydata$c_s3q7_other[2766] <- "Other"
mydata$c_s3q7_other[2769] <- "Other"
mydata$c_s3q7_other[2783] <- "Other"
mydata$c_s3q7_other[2850] <- "Other"
mydata$c_s3q7_other[2998] <- "Other"
mydata$c_s3q7_other[3038] <- "Other"
mydata$c_s3q7_other[3063] <- "Other"
mydata$c_s3q7_other[3074] <- "Other"
mydata$c_s3q7_other[3193] <- "Other"
mydata$c_s3q7_other[3216] <- "Other"
mydata$c_s3q7_other[3218] <- "Other"
mydata$c_s3q7_other[3220] <- "Other"
mydata$c_s3q7_other[3247] <- "Other"
mydata$c_s3q7_other[3272] <- "Other"
mydata$c_s3q7_other[3296] <- "Other"
mydata$c_s3q7_other[3339] <- "Other"
mydata$c_s3q7_other[3373] <- "Other"
mydata$c_s3q7_other[3377] <- "Other"
mydata$c_s3q7_other[3378] <- "Other"
mydata$c_s3q7_other[3434] <- "Other"
mydata$c_s3q7_other[3441] <- "Other"
mydata$c_s3q7_other[3458] <- "Other"
mydata$c_s3q7_other[3480] <- "Other"
mydata$c_s3q7_other[3529] <- "Other"
mydata$c_s3q7_other[3552] <- "Other"
mydata$c_s3q7_other[3566] <- "Other"
mydata$c_s3q7_other[3571] <- "Other"
mydata$c_s3q7_other[3597] <- "Other"
mydata$c_s3q7_other[3606] <- "Other"
mydata$c_s3q7_other[3611] <- "Other"
mydata$c_s3q7_other[3618] <- "Other"
mydata$c_s3q7_other[3647] <- "Other"
mydata$c_s3q7_other[3649] <- "Other"
mydata$c_s3q7_other[3658] <- "Other"
mydata$c_s3q7_other[3714] <- "Other"
mydata$c_s3q7_other[3744] <- "Other"
mydata$c_s3q7_other[3792] <- "Other"
mydata$c_s3q7_other[3825] <- "Other"
mydata$c_s3q7_other[3837] <- "Other"
mydata$c_s3q7_other[3864] <- "Other"
mydata$c_s3q7_other[3874] <- "Other"
mydata$c_s3q7_other[3899] <- "Other"
mydata$c_s3q7_other[3900] <- "Other"
mydata$c_s3q7_other[3922] <- "Other"
mydata$c_s3q7_other[3978] <- "Other"
mydata$c_s3q7_other[4007] <- "Other"
mydata$c_s3q7_other[4008] <- "Other"
mydata$c_s3q7_other[4016] <- "Other"
mydata$c_s3q7_other[4017] <- "Other"
mydata$c_s3q7_other[4032] <- "Other"
mydata$c_s3q7_other[4085] <- "Other"
mydata$c_s3q7_other[4091] <- "Other"
mydata$c_s3q7_other[4093] <- "Other"
mydata$c_s3q7_other[4189] <- "Other"
mydata$c_s3q7_other[4265] <- "Other"
mydata$c_s3q7_other[4272] <- "Other"

mydata$c_s3q7noresponse[740] <- "Other"
mydata$c_s3q7noresponse[748] <- "Other"
mydata$c_s3q7noresponse[902] <- "Other"
mydata$c_s3q7noresponse[952] <- "Other"
mydata$c_s3q7noresponse[978] <- "Other"
mydata$c_s3q7noresponse[1021] <- "Other"
mydata$c_s3q7noresponse[1132] <- "Other"
mydata$c_s3q7noresponse[1134] <- "Other"
mydata$c_s3q7noresponse[1307] <- "Other"
mydata$c_s3q7noresponse[1344] <- "Other"
mydata$c_s3q7noresponse[1418] <- "Other"
mydata$c_s3q7noresponse[1450] <- "Other"
mydata$c_s3q7noresponse[1453] <- "Other"
mydata$c_s3q7noresponse[1490] <- "Other"
mydata$c_s3q7noresponse[1549] <- "Other"
mydata$c_s3q7noresponse[1596] <- "Other"
mydata$c_s3q7noresponse[1597] <- "Other"
mydata$c_s3q7noresponse[1599] <- "Other"
mydata$c_s3q7noresponse[1630] <- "Other"
mydata$c_s3q7noresponse[1631] <- "Other"
mydata$c_s3q7noresponse[1636] <- "Other"
mydata$c_s3q7noresponse[1647] <- "Other"
mydata$c_s3q7noresponse[1669] <- "Other"
mydata$c_s3q7noresponse[1675] <- "Other"
mydata$c_s3q7noresponse[1712] <- "Other"
mydata$c_s3q7noresponse[1719] <- "Other"
mydata$c_s3q7noresponse[1722] <- "Other"
mydata$c_s3q7noresponse[1790] <- "Other"
mydata$c_s3q7noresponse[1798] <- "Other"
mydata$c_s3q7noresponse[1815] <- "Other"
mydata$c_s3q7noresponse[1885] <- "Other"
mydata$c_s3q7noresponse[1899] <- "Other"
mydata$c_s3q7noresponse[1901] <- "Other"
mydata$c_s3q7noresponse[1936] <- "Other"
mydata$c_s3q7noresponse[1939] <- "Other"
mydata$c_s3q7noresponse[1943] <- "Other"
mydata$c_s3q7noresponse[2077] <- "Other"
mydata$c_s3q7noresponse[2297] <- "Other"
mydata$c_s3q7noresponse[2347] <- "Other"
mydata$c_s3q7noresponse[2348] <- "Other"
mydata$c_s3q7noresponse[2398] <- "Other"
mydata$c_s3q7noresponse[2468] <- "Other"
mydata$c_s3q7noresponse[2830] <- "Other"
mydata$c_s3q7noresponse[2856] <- "Other"
mydata$c_s3q7noresponse[2857] <- "Other"
mydata$c_s3q7noresponse[2958] <- "Other"
mydata$c_s3q7noresponse[2990] <- "Other"
mydata$c_s3q7noresponse[3252] <- "Other"
mydata$c_s3q7noresponse[3254] <- "Other"
mydata$c_s3q7noresponse[3437] <- "Other"
mydata$c_s3q7noresponse[3806] <- "Other"
mydata$c_s3q7noresponse[3823] <- "Other"
mydata$c_s3q7noresponse[3867] <- "Other"
mydata$c_s3q7noresponse[3902] <- "Other"
mydata$c_s3q7noresponse[3968] <- "Other"


#'# GPS data: Displace
# !!!No GPS data


#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
