#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_2" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)

#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed

# !!!No Direct PII 


#'# Direct PII-team: Encode field team names

# !!!No Direct PII-team 


#'# Small locations: Encode locations  with pop <100,000 using random large numbers

# !!!No Small locations


#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 

#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("c_s2q3",
                  "c_s2q4",
                  "c_s2q5",
                  "c_s2q6")

capture_tables (indirect_PII)

# Recode those with very specific values. 

break_edu <- c(-999,0,1,2,10,17)
labels_edu <- c("No Response" = 1,
                "Pre-Kinder" = 2,
                "Kinder" = 3,
                "1st-6th Grade" = 4,
                "7th Grade-High School Graduate" = 5,
                "1st Year Vocational training or associates degree or more" = 6)
mydata <- ordinal_recode (variable="c_s2q4", break_points=break_edu, missing=999999, value_labels=labels_edu)


break_edu <- c(-999,0,10,14,17)
labels_edu <- c("No Response" = 1,
                "Pre-Kinder to 6th Grade" = 2,
                "7th-10th Grade" = 3,
                "11th Grade-High School Graduate"=4,
                "1st Year Vocational training or associates degree or more" = 5)
mydata <- ordinal_recode (variable="c_s2q5", break_points=break_edu, missing=999999, value_labels=labels_edu)

#'# Matching and crosstabulations: Run automated PII check 
# !Insufficient information

#'# Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("c_s2q1_other",
"c_s2q1noresponse",
"c_s2q3_other",
"c_s2q3noresponse",
"c_s2q4_other",
"c_s2q4noresponse",
"c_s2q5_other",
"c_s2q5noresponse",
"c_s2q6noresponse",
"c_s2q7_other",
"c_s2q7noresponse",
"c_s2q8noresponse",
"c_s2q9noresponse")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata$c_s2q1_other[412] <- "Other"
mydata$c_s2q1_other[1101] <- "Other"
mydata$c_s2q1_other[1170] <- "Other"
mydata$c_s2q1_other[1338] <- "Other"
mydata$c_s2q1_other[2005] <- "Other"
mydata$c_s2q1_other[2206] <- "Other"
mydata$c_s2q1_other[3136] <- "Other"
mydata$c_s2q1_other[3976] <- "Other"

mydata$c_s2q3noresponse[1910] <- "[name] does not know if his school is private or public school."

mydata$c_s2q4_other[14] <- "Other"
mydata$c_s2q4_other[1987] <- "Other"
mydata$c_s2q4_other[3136] <- "Other"
mydata$c_s2q4_other[3976] <- "Other"

mydata$c_s2q5_other[14] <- "Other"
mydata$c_s2q5_other[1023] <- "Other"
mydata$c_s2q5_other[1090] <- "Other"
mydata$c_s2q5_other[1987] <- "Other"
mydata$c_s2q5_other[3136] <- "Other"
mydata$c_s2q5_other[3206] <- "Other"
mydata$c_s2q5_other[3976] <- "Other"

mydata$c_s2q8noresponse[1239] <- "[Tagalog]"


#'# GPS data: Displace

# !!!No GPS data


#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
