#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_6" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)

#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#'# Direct PII: variables to be removed
# !!!No Direct PII 

#'# Direct PII-team: Encode field team names
# !!!No Direct PII - team

#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!No Small locations

#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# !!!No Indirect PII - Ordinal

#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!No Indirect PII - Categorical

# Recode those with very specific values. 

#'# Matching and crosstabulations: Run automated PII check 
# !!!Insufficient demographic data

#'# Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("c_s6q17", "c_s6q15other")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

# !!!Redacted, as it contains a lot of sensitive information and some information is in Tagalog.

mydata$c_s6q15other[796] <- "Grandmother's House"
mydata$c_s6q15other[987] <- "Near brgy. Health center in there store."
mydata$c_s6q15other[1073] <- "Secretary's house"
mydata$c_s6q15other[1121] <- "[Tagalog]"
mydata$c_s6q15other[2359] <- "In their [type of store] store [small location] "
mydata$c_s6q15other[2411] <- "Working area"
mydata$c_s6q15other[2596] <- "PARK"
mydata$c_s6q15other[2603] <- "[type of farm] farm "
mydata$c_s6q15other[3150] <- "Hall"
mydata$c_s6q15other[3158] <- "HEALTH CENTER"
mydata$c_s6q15other[3159] <- "Health Center"
mydata$c_s6q15other[3160] <- "Health Center"
mydata$c_s6q15other[3161] <- " hall"
mydata$c_s6q15other[3167] <- " Captains house"
mydata$c_s6q15other[3213] <- " hall"
mydata$c_s6q15other[3214] <- " hall"
mydata$c_s6q15other[3227] <- "[Tagalog]"
mydata$c_s6q15other[3236] <- "[Tagalog]"
mydata$c_s6q15other[3237] <- "[Tagalog]"
mydata$c_s6q15other[3446] <- "Captain's house"
mydata$c_s6q15other[3454] <- "Captain's house"
mydata$c_s6q15other[3455] <- "Captain's house"
mydata$c_s6q15other[3462] <- "Captain'shouse"
mydata$c_s6q15other[3463] <- "Captain's house"
mydata$c_s6q15other[3488] <- " hall"
mydata$c_s6q15other[3493] <- "hall"
mydata$c_s6q15other[3494] <- "hall"
mydata$c_s6q15other[3615] <- "A place name [small location's name], his work place"
mydata$c_s6q15other[4243] <- "Hall"
mydata$c_s6q15other[4272] <- "In their [type of store] store"

mydata$c_s6q17[4] <- "[name] Gave up easily on the drawing part."
mydata$c_s6q17[5] <- "[name] Does not pay attention to the questions being asked. Pre-occupied with other thoughts."
mydata$c_s6q17[25] <- "I was not able to interview the twins [name]  and [name]  because they are with their mother, selling constructions supply."
mydata$c_s6q17[30] <- "[name]  is willing to participate in our studies."
mydata$c_s6q17[33] <- "[name]  is willing to participate in our research."
mydata$c_s6q17[34] <- "[name]  is accomodating."
mydata$c_s6q17[39] <- "[name]  is willing to participate in our studies."
mydata$c_s6q17[63] <- "[name]  is willing to participate in our studies."
mydata$c_s6q17[69] <- "[name]  is willing to participate in our research."
mydata$c_s6q17[70] <- "[name]  is willing to participate in our studies."
mydata$c_s6q17[73] <- "[small location] Plaza"
mydata$c_s6q17[81] <- "She is shy but gained relaxed as we progresses.  The two child was not able to be interview because[name] is in college and going to school, while [name] is in her auntie's house at  [small location] "
mydata$c_s6q17[86] <- "[name]  is willing to participate in our studies."
mydata$c_s6q17[87] <- "[name] is willing to participate in our research."
mydata$c_s6q17[88] <- "[name] is willing to 0articate in our studies."
mydata$c_s6q17[135] <- "[name] fetch water everyday. Walks atleast 1 hour back and forth. Carry 2 pails in her hands."
mydata$c_s6q17[191] <- "[name] is a school achiever."
mydata$c_s6q17[193] <- "[name] was very shy and felt like she doesn't want to participate in the survey. Didn't try to draw."
mydata$c_s6q17[213] <- "[name] had a hard time comprehending the tagalog questions because they speak Ilocano most of the time. Had to ask someone in the house to translate some phrases to [name]."
mydata$c_s6q17[214] <- "Completed [name]was not able to be interview  because he was with his father at [small locaion]"
mydata$c_s6q17[222] <- "Father figure is [name]"
mydata$c_s6q17[223] <- "Father figure is [name]"
mydata$c_s6q17[224] <- "Father figure is [name]"
mydata$c_s6q17[231] <- "[Tagalog]"
mydata$c_s6q17[238] <- "He is very attentive.  [name] was not able to be interview because she is on vacation at [small location]."
mydata$c_s6q17[241] <- "I was not able to interview [name] because she is not at home. She is working as a housemaid."
mydata$c_s6q17[243] <- "[name] stop schooling."
mydata$c_s6q17[249] <- "[name] was in vacation at present"
mydata$c_s6q17[257] <- "His mother figure is his auntie and father figure is his uncle because he is living with them. [name] was not able to be interviewed because she is attending a seminar at her school."
mydata$c_s6q17[275] <- "[name] is in [small location] working in her Aunt's store to earn money for her school"
mydata$c_s6q17[278] <- "[name]"
mydata$c_s6q17[288] <- "I was not able to interview [name] and [name] because they are on vacation in [small location]"
mydata$c_s6q17[299] <- "[name] did not join the interview because of her situation"
mydata$c_s6q17[300] <- "I was not able to interview [name] because she is working in [small location]"
mydata$c_s6q17[316] <- "I was not able to interview [name] because he is in working in  [small location]"
mydata$c_s6q17[319] <- "[name] is willing to Participate in our research."
mydata$c_s6q17[324] <- "[name] is willing to participate in our research."
mydata$c_s6q17[325] <- "[name] is willing to participate in our research"
mydata$c_s6q17[329] <- "Along the way of [small location]"
mydata$c_s6q17[331] <- "Near [small location] Road"
mydata$c_s6q17[341] <- "[name] is working as aconstruction worker"
mydata$c_s6q17[348] <- "[name] only went home every Saturday because she is working."
mydata$c_s6q17[351] <- "Completed [name 1] was not able to be interview because he is working and only go home during weekend.  [name 2] was not able to be interview because she is on vacation and at the same time taking care of her lola."
mydata$c_s6q17[352] <- "He's attentive and willing to be interview.  [name] was not able to be interview because she is with his brother in law selling at the market."
mydata$c_s6q17[370] <- "[name] is working at his age."
mydata$c_s6q17[376] <- "[name] is currently in [small location] for Vacation"
mydata$c_s6q17[379] <- "[name] was currently in [small location]"
mydata$c_s6q17[384] <- "I was not able to interview [name] and [name] because they are in [small location] working in [type of work redacted]."
mydata$c_s6q17[388] <- "Her father figure is her [name] because her father died 2 years ago."
mydata$c_s6q17[389] <- "Her father figure is her [name] beacuse her father died 2 years ago."
mydata$c_s6q17[396] <- "[name] is willing to participate in our studies."
mydata$c_s6q17[397] <- "[name] stop schooling because of financial problem.her mother try to recover due to the fire last year."
mydata$c_s6q17[406] <- "[name] is willing to participate in our research."
mydata$c_s6q17[407] <- "[name] is willing to participate in our research."
mydata$c_s6q17[424] <- "Child is very shy but gain confidence as the interview progresses. [name] was not able to be interview tending a store at [small location]"
mydata$c_s6q17[426] <- "[name] is at [small location] with her grandmother."
mydata$c_s6q17[458] <- "He has no father figure since his father left in 2014 and his grandfather is already deceased.  He finished the mirror activity quickly.  [name] was not interviewed because he is on vacation at [small location] with his Uncle during the time of visit."
mydata$c_s6q17[463] <- "[name] loves his grandparents, he choses to stay with them."
mydata$c_s6q17[471] <- "[name] is willing to particate in our studies."
mydata$c_s6q17[472] <- "[name] is very accommodating."
mydata$c_s6q17[475] <- "[name] is willing to participate in our studies."
mydata$c_s6q17[476] <- "[name] is willing to participate in our research."
mydata$c_s6q17[477] <- "[name] is willing to participate in our studies."
mydata$c_s6q17[500] <- "I was not able to interview [name] because she is in her teacher's home, she will stay there for the rest of the summer vacation."
mydata$c_s6q17[502] <- "[name] is willing to participate in our research."
mydata$c_s6q17[515] <- "[name] is willing to participate in our studies."
mydata$c_s6q17[520] <- "[name] was hesitant but she participated in our studies."
mydata$c_s6q17[521] <- "[name] is hesitant he told me that he doesn't like to go to school."
mydata$c_s6q17[528] <- "[name] doing the choires and as i can see he is a very industrious child"
mydata$c_s6q17[543] <- "[name] was very shy, he was not facing me and he rarely made eye contact throughout the interview. I know that he is paying attention because he responds with a nod whenever I gave an instruction. Also, he answered audibly even if his tone was very low."
mydata$c_s6q17[551] <- "Her older brother, [Name], translated for me for the parenting style portion."
mydata$c_s6q17[553] <- "[name] has a wound on his left finger because he helped his brother to chop a wood. They was not able to bring him in the hospital because it is too far."
mydata$c_s6q17[560] <- "[name] is hesitant but she answered all the question spontaneously."
mydata$c_s6q17[561] <- "[name] is willing to participate in our studies."
mydata$c_s6q17[562] <- "[name] is willing to participate in our research."
mydata$c_s6q17[563] <- "[name] is willing to participare in our research."
mydata$c_s6q17[567] <- "[name] is a happy boy. He sees life in a positive way."
mydata$c_s6q17[570] <- "[name 1] is living inside the church, [name2] is financing his studies."
mydata$c_s6q17[571] <- "[name] is aspiring to become a teacher in the future. She speaks well."
mydata$c_s6q17[573] <- "[name] is willing to participate in our studies"
mydata$c_s6q17[574] <- "[name] is very active. He finished all the images without hesitation."
mydata$c_s6q17[576] <- "Child was very active in answering the questions. She helps in family's farm and also works for other farms. She answered quickly in every question and seems very smart. She said she's an honor student.  Other child, [name] is on vacation in [small location] so she was not available during the time of visit."
mydata$c_s6q17[580] <- "Another child from neighbor distracted him during the interview by talking to him or also answering the questions.  Another eligible child was not present during the interview. She is in [small location] for vacation."
mydata$c_s6q17[586] <- "I wasn't able to interview [name] because he is working in [small location]"
mydata$c_s6q17[605] <- "[name] is hesitant to be interviewed at first. He stopped studying. His grand father took care of him since he was 1 year old."
mydata$c_s6q17[606] <- "[name] is willing to participate in our studies."
mydata$c_s6q17[608] <- "[name] is  very kind."
mydata$c_s6q17[609] <- "[name] is intelligent."
mydata$c_s6q17[617] <- "[name] is willing to partivipate in our studies."
mydata$c_s6q17[618] <- "[name] is willing to participate in our studies."
mydata$c_s6q17[627] <- "Grandfather is the father image in the parenting style section  ER, [name], is not available for interview because he attended a cousin's graduation and will not be back until the next day."
mydata$c_s6q17[633] <- "[Tagalog]"
mydata$c_s6q17[636] <- "[name] is willing to participate in our studies."
mydata$c_s6q17[639] <- "[name] is accommodating."
mydata$c_s6q17[647] <- "Interview was hastened because he had to leave for work.  The other eligible child, [name] was selling halo-halo in [small location] during the time of visit."
mydata$c_s6q17[650] <- "[name] is nit studying in this school year"
mydata$c_s6q17[651] <- "Child was very shy and her mom just convinced her to participate. It seems she could not understand some of the statements and took time thinking what to answer. She just gave me blank stares for the questions she couldn't understand so mom had to help her explaining in [small location]"
mydata$c_s6q17[656] <- "Only the father (adult respondent) and [name] (child respondent) is at home so the interview was peaceful and quiet."
mydata$c_s6q17[658] <- "[name] is willing to participate in our studies."
mydata$c_s6q17[659] <- "[name] is willing to particate in our studies."
mydata$c_s6q17[660] <- "[name] is willing to participate in our studies."
mydata$c_s6q17[664] <- "[name] is willing to participate in our research."
mydata$c_s6q17[665] <- "[name] is willing to participate in our research."
mydata$c_s6q17[693] <- "I was nog able to interview [name] because he is in [small location] for vacation."
mydata$c_s6q17[696] <- "I was not able to interview [name] because he is in [small location] staying in his friend for 1 week."
mydata$c_s6q17[699] <- "[name] not available when the time visited. According to her mother indefenite schedule when she's going back home because she is on vacation with her grandparents on the other town."
mydata$c_s6q17[706] <- "[name] was not around during survey,he' at uncle's house for a vacation and dont know when will be going back home."
mydata$c_s6q17[784] <- "The interview went well. (HH and other children surveys were done by FO [name])"
mydata$c_s6q17[785] <- "The child was good in the game, but could not speak and express his answer in tagalog. Her mother helped him answer in tagalog in some questions... One eligible child named Jestoni Gaoat was interviewed by another F.O (care of [name])."
mydata$c_s6q17[830] <- "Child2-[name] interviewed by FO [name]."
mydata$c_s6q17[848] <- "Interview went well.  The other 2 child was interviewed by [name]."
mydata$c_s6q17[888] <- "[Name] is not available during the day of the survey, and [Name] is speacial child."
mydata$c_s6q17[940] <- "Interview done in [small location]"
mydata$c_s6q17[941] <- "Interview done in [small location]."
mydata$c_s6q17[942] <- "[name] and [name] interviewed by FO [name]"
mydata$c_s6q17[987] <- "6 meters left side of [small location] Health center"
mydata$c_s6q17[994] <- "[name] is on vacation and will be back on june."
mydata$c_s6q17[999] <- "[name 1] joy guide her sister [name 2] in some part of the questions because she cannot understand some part of the questions and she cant understand tagalog and deep tagalog language."
mydata$c_s6q17[1073] <- "Parenting questions no answers because child suddenly ran away, I tried to ask him to finish but he then never talks/speak. His mother even force the child to finish. This was the child upon initial approach of the first visit by F.O[name], the child went away and hide somewhere, he just showed up when we leave their purok."
mydata$c_s6q17[1075] <- "Interview went long because he is not fluent in [small location] he is a ifugao.  The other child was interviewed by [name]"
mydata$c_s6q17[1078] <- "Interview done in [small location] The other child was interviewed by [name]"
mydata$c_s6q17[1080] <- "Interview done in [small location]"
mydata$c_s6q17[1100] <- "[name] doesnt want to be interview,during the survey he runaway maybe because he is afraid and shy to be interview."
mydata$c_s6q17[1161] <- "Child -[name 1] interviewed byvFO [name 2]"
mydata$c_s6q17[1184] <- "She is very respectful but she was hard up on the mirror game. She can not easily understand some questions in parenting part. She is a choir member in the church and school with a monthly allowance of [amount of money] pesos from the office of tourism."
mydata$c_s6q17[1404] <- "The child is relax/calm in answering the questions.  (This interview was done by fellow field officer [name]. I just copied this to him because there was a conflict to my time schedule, I was assigned to go back to mariveles, we just let him do the interview because he was on the area.)"
mydata$c_s6q17[1405] <- "The field officer who interviewed the child is [name] because we returned to [small location 1] to complete the interview in [small location 2]."
mydata$c_s6q17[1417] <- "His real father is staying in [small location]"
mydata$c_s6q17[1492] <- "The real father is now at [small location]"
mydata$c_s6q17[1493] <- "His father is working in [small location] last 2015."
mydata$c_s6q17[1565] <- "[Tagalog]"
mydata$c_s6q17[1605] <- "He works 15 days only in [small location] last january 2016 as helper of cable connection. He is respectful."
mydata$c_s6q17[1697] <- "Sitio [small location], under the manggo trees."
mydata$c_s6q17[1738] <- "Other child already interview [name]"
mydata$c_s6q17[1773] <- "She is living with his boyfriend [name] for 2 years"
mydata$c_s6q17[1818] <- "[Tagalog]"
mydata$c_s6q17[1833] <- "[name] is a bit shy but she was able to finish the interview."
mydata$c_s6q17[1834] <- "[name] ia a cheerful child. She is smiling all the time when she answering my questions."
mydata$c_s6q17[1837] <- "[name] is very cooperative boy during our interview."
mydata$c_s6q17[1838] <- "[name] is a very happy person."
mydata$c_s6q17[1839] <- "[name] is accommodating and intelligent boy."
mydata$c_s6q17[1840] <- "[name] is accommodating duting our interview."
mydata$c_s6q17[1845] <- "[name] is very willing to be interviewed."
mydata$c_s6q17[1846] <- "[name] is very willing to be interviewed. She said that she was happy for her family right now."
mydata$c_s6q17[1848] <- "[name] is willing to participate in our studies."
mydata$c_s6q17[1855] <- "[name] is only 11 years old right now he stop schooling but he said that next year he will go back to school he is willing to particate in our research. Children nos. 3,4,5 are not available for interview.  There is no definite day when they will come home."
mydata$c_s6q17[1856] <- "[name] is willing to participate in our research, almost one month that she has no work because of her condition her hair frequently falling she doesnt know what is the main reason.but now it stop."
mydata$c_s6q17[1859] <- "[name] was answering my question very well. Privacy is not possible because some neighbors is also in their home but they went home later on."
mydata$c_s6q17[1860] <- "[name] is already married at the age of 15 but she still lives at her parent'shome. Michael does not want to undergo interview, he hid when it was his turn already."
mydata$c_s6q17[1864] <- "[name] is very friendly and consistent with me during my interview."
mydata$c_s6q17[1869] <- "[name] is listening well to the questions before answering my questions."
mydata$c_s6q17[1870] <- "The child participates in the survey and seems confident to answer and actively gives attention throughout the interview.Child survey  1 and 4 Conducted by Field officer [name]"
mydata$c_s6q17[1872] <- "Child 1and 4 done interview by [name]"
mydata$c_s6q17[1873] <- "The child sometimes hesitate to answer and shy, his attention occasionaly drifted, speaks in a low voice so the Field officer needs to explain briefly all the questionaire. Child Survey 1 and 4 is conducted by [name]"
mydata$c_s6q17[1879] <- "[name] always smiles when he is answering my questiona."
mydata$c_s6q17[1881] <- "Since they are living in a area where there are only few person resides, at first [name] cries when she cannot answer the question. I asked for her sister to accompany her during the first part of my interview."
mydata$c_s6q17[1882] <- "[name] seems to be shy but he is answering my question correctly."
mydata$c_s6q17[1884] <- "[name] is very cooperative during our interview."
mydata$c_s6q17[1885] <- "[name] is very happy during our interview."
mydata$c_s6q17[1886] <- "[name] is very cooperative durinf our interview."
mydata$c_s6q17[1887] <- "[name] is very accommodating during our interview. He is happy with his family."
mydata$c_s6q17[1895] <- "[name] is such a smart girl. She is thinking first before answering each question."
mydata$c_s6q17[1896] <- "[name] was so persistent to finish all of the drawing. He answered all of my question without hesitation."
mydata$c_s6q17[1897] <- "[name] was thinking first before answering all of my questions."
mydata$c_s6q17[1899] <- "[name] is accommodating during our interview."
mydata$c_s6q17[1900] <- "[name] is very Accommodating."
mydata$c_s6q17[1901] <- "[name] is attentive in our intetview."
mydata$c_s6q17[1902] <- "[name] is a child which is a slow learner and that is the main reason why she lost her focus most of the time."
mydata$c_s6q17[1904] <- "[name] was so cooperative all throughout the interview."
mydata$c_s6q17[1909] <- "[name] is such a cheerful child. Their family do have a tight bonding."
mydata$c_s6q17[1910] <- "[name] is not attentive during the interview, although he is having an eye contact with me, it seems that he was thinking of something else. Most of the time I need to ask the question twice or explain what it means before he answers in a soft voice."
mydata$c_s6q17[1911] <- "[name] participates well during my interview with her. When she cannot understand the questions she ask me to profound the question for her to be able understand."
mydata$c_s6q17[1912] <- "[name] is very cooperative it is just that he cannot participate to the game because he is bedridden due to the accident he had last May 2015."
mydata$c_s6q17[1913] <- "[name] tends to lose her focus during the interview because her stepsister who is younger than her is right beside her, that is the reason why i presume that she is a little bit confuse on how is she going to answer the questions regarding how she was treated by her mother."
mydata$c_s6q17[1915] <- "My interview with [name] was so smooth."
mydata$c_s6q17[1920] <- "[Tagalog]"
mydata$c_s6q17[1921] <- "[Tagalog]"
mydata$c_s6q17[1922] <- "[name] is accomodating in our conversation her family needs help."
mydata$c_s6q17[1926] <- "[name] sometimes lost his attention because he is so conscious about his answer."
mydata$c_s6q17[1927] <- "[name] is a nice child but sometimes timid to answer the questions because he is already a teenager."
mydata$c_s6q17[1928] <- "[name] is hesitant to talked to me onset of the interview because her sister told her that I am from DSWD and I will be adopting her but when I talked to her she slowly believe that I am not doing any harm towards her."
mydata$c_s6q17[1929] <- "[name] sometimes having a hard time answering the question because she already have a live in partner."
mydata$c_s6q17[1932] <- "[name] is such a sweet child. She answered my questions very well."
mydata$c_s6q17[1934] <- "[name 1] is very shy that for her to be interview needs the assistance and presence of her Auntie ( [name2])  To sum it up, we finished the interview."
mydata$c_s6q17[1935] <- "[name] is a cheerful girl. She is raised by her grandparents with so much love that reflects to her personality."
mydata$c_s6q17[1936] <- "[name] is accommodating during our interview."
mydata$c_s6q17[1937] <- "[name] is so cooperative during our interview he is very happy to his family."
mydata$c_s6q17[1938] <- "[name] was a bit shy onset of the interview but she answered all of my questions in a nice manner."
mydata$c_s6q17[1939] <- "[name] is working at his age of 14. He told me that he want to go back to school but his parents does not  have enough money to send him to school."
mydata$c_s6q17[1940] <- "[name] is very accommodating."
mydata$c_s6q17[1941] <- "[name] is very attentie during our interview."
mydata$c_s6q17[1942] <- "[name] is very cooperative during our interview."
mydata$c_s6q17[1943] <- "[name] is accomodating during our interview"
mydata$c_s6q17[1944] <- "[name] is very cooperative, he plays the game and answers the questions with all honesty."
mydata$c_s6q17[1945] <- "[name] is reaponsive in answering my questions but sometimes he is loosing his attention because he wants to do something else."
mydata$c_s6q17[1946] <- "[name]  was attentive during our interview."
mydata$c_s6q17[1947] <- "[name] participates well. She tried to raise some questions when she cannot understand the questionaire."
mydata$c_s6q17[1948] <- "[name] was so attentive all throughout the interview."
mydata$c_s6q17[1950] <- "[name] Is an intelligent boy he told me that aside from cleaning the house and taking care of his sibling he is always playing."
mydata$c_s6q17[1951] <- "[name] is grade 7 right now he is studying in the morning and working in the evening."
mydata$c_s6q17[1952] <- "[name] told me that he is selling balot and driving pedicab at the same time after school,and he use the money that he earn for his allowance in school."
mydata$c_s6q17[1957] <- "[name] is a happy and polite boy."
mydata$c_s6q17[1958] <- "[name] participates well in the interview."
mydata$c_s6q17[1974] <- "[name] does not want to draw because he is doing something."
mydata$c_s6q17[1979] <- "Child answered every question quickly and seemed sure with his answers - even when I asked him justifications, he could answer immediately and straightforwardly. He didn't ask about anything or make some comments. He just gave answers without second thought.  Sometimes, he helps in others' coconut farm by carrying the coconut and putting them into the truck where he earns [amount of money] day. But this happens 5-10 times a year only. His other work that he only started just last week was accompanying his friend in selling vegetables around the barangay. He just did it last week twice and his friend gave him [amount of money] a day.  He had a hard time working on the activity and was able to finish only one image but had tried all the images."
mydata$c_s6q17[1980] <- "He shy at first but when the interviewed progress he felt comfortable. Child 3-[name] not available,according to her mother she is on vacation to her sister in other province, indefinite schedule when she come back."
mydata$c_s6q17[1986] <- "[name] and very straight forward to answer the quedtions."
mydata$c_s6q17[1990] <- "[name] is willing to participate in our research.As I can see he is confused on his gender."
mydata$c_s6q17[1991] <- "[name] is cooperative child she lived with her grandparent."
mydata$c_s6q17[1997] <- "[name] is willing to participate in our studies he is cooperative."
mydata$c_s6q17[1998] <- "[name] is the youngest son of Soprema jherome is willing to participate in our studies."
mydata$c_s6q17[1999] <- "[name 1] is the eldest daughter of [name 2] she is very cooperative and happy person."
mydata$c_s6q17[2000] <- "[name] participated well and he is relaxed during the survey."
mydata$c_s6q17[2001] <- "[name] her mother is listening and coaching her on how to answer, in section of this survey Life satisfaction, I lend her the tablet for her to answer the sensitive questions and instructed her that if there are questions that she cannot understand I can explain it to her."
mydata$c_s6q17[2002] <- "[name] is a playful girl. It reflects in her attitude during the survey."
mydata$c_s6q17[2003] <- "[name] is uncomfortable at some part of the interview because his mother and father were looking at him.  Harlington was not interviewed because he was not available during the interview."
mydata$c_s6q17[2005] <- "[name] is seventeen years old. Her mother tried to bring her to school when she was at her tender age however [name] is uncomfortable to study in a large number of kids. They believe that she has a mild mental retardation. She acts as a child in her age but she knows how to speak, write, interact and do household chores. Her mother asked me to interview her daughter despite the fact that she knows her condition. I dont want to break the heart of her mother so I tried to talk to her and suprisingly she interacts with me and even draw the images."
mydata$c_s6q17[2006] <- "[name] is a careless boy. He was not properly guided by his mother although she was trying her best to give him the best life can offer."
mydata$c_s6q17[2007] <- "[name] ask me to repeat the question when she cannot understand. I can say that she is easy to deal with."
mydata$c_s6q17[2008] <- "[name] is a polite boy. He answers all of my questions properly. He is helping his father to harvest their crops."
mydata$c_s6q17[2009] <- "[name] is a happy girl, it's so sad that life is that cruel that they are in that position although their father is giving his best to give them a good life."
mydata$c_s6q17[2010] <- "[name 1] participated well in the interview. She draws well.  Child #3, [name 2]  was not interviewed because she is not available. She is on vacation with her grandmother in [small location], as per [name 3]."
mydata$c_s6q17[2011] <- "[name] seems to be a playful kid. He is using his cellpone while talking to me. I have to repeat and explain the question before answering."
mydata$c_s6q17[2012] <- "[name] seems to be shy onset of the interview but I manage to end the interview well."
mydata$c_s6q17[2013] <- "[name] is a cooperative person. He draws well."
mydata$c_s6q17[2014] <- "[name] is smart. During the interview, her siblings were present and they tried to break her attention. That is the reason why [name]'s attention occassionaly drifts."
mydata$c_s6q17[2015] <- "[name] is matured and confident during the interview."
mydata$c_s6q17[2017] <- "[name] is playful boy but he is serious during the interview."
mydata$c_s6q17[2021] <- "[name] is working at his early age to earn money for him to buy his personal needs. This work is affecting his studies."
mydata$c_s6q17[2022] <- "[name] has a low self-esteem. Whenever I am asking him a question he answers me in a whispering manner. I need to repeat the question for me to understand him."
mydata$c_s6q17[2025] <- "[name] is such a timid child. I let him answer the Life Satisfaction part of the interview by himself because his father is listening in on our conversation."
mydata$c_s6q17[2026] <- "[name] asked me what the interview is all about  before agreeing to participate. She is helping her mother sort and pack the vegetables that her mother is selling. I let her answer the Life Satisfaction part by herself because her father is listening in on our conversation."
mydata$c_s6q17[2031] <- "The respondent is shy. She is not afraid of her father. The father is very kind and it seems that [name] is spoiled."
mydata$c_s6q17[2042] <- "[name] is willing to participate in our studies although she dont like to finish or to draw our images."
mydata$c_s6q17[2045] <- "[name] is willing to participate in our studies she answered all the questions spontenously."
mydata$c_s6q17[2050] <- "[name] thinks first before he answer the questions. He is living with his step father,."
mydata$c_s6q17[2051] <- "[name] answers all of my question even he is sick."
mydata$c_s6q17[2052] <- "[name] was listening well before answering the questions."
mydata$c_s6q17[2053] <- "[name] is very shy. He needs encouragement from me for him to answer the question."
mydata$c_s6q17[2054] <- "[name] is confident with his answers."
mydata$c_s6q17[2055] <- "[name] participates well. She draws the drawing so well, in a snap of a finger she is done."
mydata$c_s6q17[2057] <- "[name] is a bit shy. He is just pointing his answer on the flash card."
mydata$c_s6q17[2059] <- "[name] participates well. His grandparents were present the whole interview."
mydata$c_s6q17[2062] <- "[name] seems shy onset of the interview but he is answering my questions appropriately."
mydata$c_s6q17[2063] <- "[name] is confident aswering the questionaires. With regard to the parenting style, he is living with his step father."
mydata$c_s6q17[2087] <- "[name] is cooperative in our studies he told me that he only took care of his siblings."
mydata$c_s6q17[2095] <- "Mother and father figure is same as his sisters [name 1] and [name 2] Of the siblings, only [name 3] acknowledged that they have 2 other siblings with their father and 3 other siblings with their mother."
mydata$c_s6q17[2096] <- "Mother figure is also paternal grandmother. Father figure is still their father. She is [name]'s sister."
mydata$c_s6q17[2097] <- "Mother figure is also paternal grandmother. Father figure is paternal grandfather. She is [name]'s cousin."
mydata$c_s6q17[2108] <- "[name] is cooperative during our interview."
mydata$c_s6q17[2112] <- "The respondent is not a member of the family biologically but she stayed at [name 1] house since last year because [name 2] and [name 3] are now live-in partner. The parents of [name 4] was in [small location 1] but her sisters lived in [small location 2]. She visit sometime to her sisters house."
mydata$c_s6q17[2129] <- "[name 1] is willing to participate in our studies she is second to the eldest and very cooperative girl and happy person.  [name 2] does not want to participate in our studies."
mydata$c_s6q17[2130] <- "[name] is willing to particate in our studies. Her parent are separated."
mydata$c_s6q17[2132] <- "[name] is cooperative during our conversation."
mydata$c_s6q17[2136] <- "[name] is willing to participate in our research."
mydata$c_s6q17[2138] <- "[name] is already 15 years old but physically she is like 7 years old because of the late development of her body. Since birth, she is weak and often times has to be hospitalized because of the complications she is going through in her internal organs. She is also short because of the abnormalities in his feet. This is the reason why she had to stop from school and was also late for school.  But, during the interview, she has shown willingness to participate and was smart in answering the survey questions."
mydata$c_s6q17[2139] <- "[name] had a difficulty in working on the activity. He seemed unhappy because his parents separated and has their own families. He was left by his parent since he was 1 year old."
mydata$c_s6q17[2149] <- "[name] is more confident during the survey because he was present during the interview of his sister."
mydata$c_s6q17[2150] <- "[name] seems to be holding grudges against her parents."
mydata$c_s6q17[2152] <- "[name] cannot estimate the time."
mydata$c_s6q17[2153] <- "[name] participates well during the interview."
mydata$c_s6q17[2154] <- "[name] seems so tired and sleepy during the interview."
mydata$c_s6q17[2157] <- "[name] participates well. She is having a hard time   finishing the drawing. She may have cheated in the first two images."
mydata$c_s6q17[2158] <- "[name] is having a hard time finishing the drawing but he tried his best to do it."
mydata$c_s6q17[2163] <- "[name] is hesitant to answer my questions."
mydata$c_s6q17[2164] <- "[name] is willing to participate in our studies."
mydata$c_s6q17[2168] <- "The Child participates and listening to the instructions, shes confident and responding very well, and pay attention for the whole interview, she is the daughter of [name] when she is still single."
mydata$c_s6q17[2173] <- "[name] is such a cheerful child, he is answering all of my question with a smile."
mydata$c_s6q17[2174] <- "[name] participates well and she is relaxed during the survey."
mydata$c_s6q17[2175] <- "[name] is very sensitive boy."
mydata$c_s6q17[2176] <- "[name] is cooperative and easily instructed."
mydata$c_s6q17[2188] <- "[name] is easily distracted by her mother because her mother was asking her of some information to be filled in in household interview."
mydata$c_s6q17[2189] <- "[name]'s attention occassionally drifts because his playmates is waiting for him to finish the interview."
mydata$c_s6q17[2190] <- "[name] is a playful child, I have to asm the question more than 3 times before she answers."
mydata$c_s6q17[2218] <- "[name] is a very thoughful child and a very attendtive brother to his siblings, he do household chores,together with his brother  and a very respectful child to his parents."
mydata$c_s6q17[2220] <- "[name] is longing for her mother and father his grandmother and grandfather took care of him when he was born."
mydata$c_s6q17[2223] <- "He enjoyed the mirror game. He worked for only 4 days in the [type of work redacted] last February. He just arrived in the hh last September 2015. He was staying with his biological father in [small location] prior to his move to [small location]. His father is the 2nd husband. He considered his step father (mother's 3rd husband) as his father image in the parenting style portion."
mydata$c_s6q17[2227] <- "[name] stopped schooling due to financial problem."
mydata$c_s6q17[2233] <- "[name] was not able to see his father since he was kid. Her mother is in Manila with her new family, so he was raised by his grandmother."
mydata$c_s6q17[2236] <- "[name] is a very respectful child and eventhough they are poor of the poorest his father dont want him to work."
mydata$c_s6q17[2240] <- "[name]'s family is so hospitable. After explaining all of the necessary information they willingly participated in our research."
mydata$c_s6q17[2246] <- "We took an hour and a half for us to locate their house from [small location]. [name]'s family seems to have an average life. Her mother is working abroad for him to study in a decent school."
mydata$c_s6q17[2247] <- "[name]'s family supported us to have a private interview with her. They gave us a place where we can talk."
mydata$c_s6q17[2250] <- "[name] stop studying because he dont have enough money to go to school he is willing to participate in our reaearch."
mydata$c_s6q17[2251] <- "[name 1] have twin brother [name 2],they are willing to participate in our research."
mydata$c_s6q17[2252] <- "[name] is very intelligent girl she is a working student.she work for her allowance in school."
mydata$c_s6q17[2253] <- "[name] is 13 years old at his age he know how to drive a motorcycle he help his parent without hesitation."
mydata$c_s6q17[2260] <- "[name 1] shared that she wants to be a doctor someday. I visited their home 4 times but I can't see [name 2] and [name 3]- Al because their mother is always bringing them to work. In my last visit with them (March 18), I waited for them until 8:30 pm but they didn't come home."
mydata$c_s6q17[2261] <- "[name]'s father is present during the interview because there is no enough space for us to conduct the survey."
mydata$c_s6q17[2263] <- "Other children in the household were playing around and talking to the child respondent at some point of the interview.  Child helps in the family business (sometimes in the kitchen sometimes in selling or serving). Her mom sometimes gives her [amount of money] a day."
mydata$c_s6q17[2264] <- "Child refused to participate twice and did not want to talk to us. With the help of the barangay councilor, we chased him at his uncle's house and did the interview there with the consent of his parents. Child goes home from time to time but most of the time sleeps in his Uncle's house because child goes with his Uncle to work in the coconut farm to carry cocolumbers using a horse where he earns [amount of money] a week."
mydata$c_s6q17[2280] <- "The child is very attentive and polite. [name] was not available for interview because he is working at a poultry farm and goes home on weekends only."
mydata$c_s6q17[2281] <- "[name] has an orthopedic disability on her feet and can not walk properly. Their life seems to be so miserable because her parents are separated already and her mother is unemployed."
mydata$c_s6q17[2282] <- "[name] is having a hard time finishing the drawing."
mydata$c_s6q17[2284] <- "[name] was not willing to participate in our research but eventually I convinced him to participate and he said yes."
mydata$c_s6q17[2285] <- "[name] is cooperative in our research he is working saturday and sunday as a conductor to earn money."
mydata$c_s6q17[2286] <- "[name] is 6 months pregnant at the age of 14."
mydata$c_s6q17[2287] <- "[name] is living with her grandmother for 1 year now.  With the parenting style she imagine her grandparents as her parent."
mydata$c_s6q17[2288] <- "[name] answers all of my question honestly. It seems that she does not have a good relationship with her father."
mydata$c_s6q17[2290] <- "At the beginning of the interview he felt shy but when he started the images he is more relaxed and answered the questions attentively. The 2 other eligible children were interviewed by [name]."
mydata$c_s6q17[2291] <- "[name] seems to be so shy but we were able to finish the interview. She is living with her aunt."
mydata$c_s6q17[2293] <- "[name] is helping his father in their farm."
mydata$c_s6q17[2294] <- "[name] is helping his father in their farm."
mydata$c_s6q17[2295] <- "[name] is not working, he just focuses on his studies because he belongs to top 10 of his class."
mydata$c_s6q17[2296] <- "[name] worked in [small location] for just 1 week because she cannot work well and its hard for her to be a housemaid."
mydata$c_s6q17[2297] <- "[name] is willing to participate in our studies."
mydata$c_s6q17[2298] <- "[name]'s family is living their life one day at a time but they are happy."
mydata$c_s6q17[2299] <- "[name] was shy at first but when I explained what is the interview all about, she answered all of the questions and finished the interview well."
mydata$c_s6q17[2304] <- "[name] is very close to her Father."
mydata$c_s6q17[2305] <- "[name] is very close to her father."
mydata$c_s6q17[2310] <- "The family of [name] permitted us to conduct the survey, although they are busy preparing foods because it's her cousin's first birthday."
mydata$c_s6q17[2314] <- "[name] seems to be so tired because she symphatizes with her father because he was the one who's looking after his children and doing some chores. Her mother is working in [small location]"
mydata$c_s6q17[2315] <- "On our way to [name]'s house, we had an encounter with four dogs.. When the survey is finished, i requested for [name] to accompany us to reached the national road."
mydata$c_s6q17[2316] <- "[name] excel well in school. She is the class validectorian."
mydata$c_s6q17[2320] <- "[name] answers all of my question with no hesitation."
mydata$c_s6q17[2323] <- "[name] hesitate for the first time weve meet but in the midle of interview shes responding well and a very shy type child."
mydata$c_s6q17[2325] <- "She enjoyed the activity even if she didn't finish the images. During the interview she is relaxed and gives full attention to the questions.  [name] was not available for interview because he is helping his father harvest coconuts in [small location]. They are expected to come home on Sunday evening."
mydata$c_s6q17[2335] <- "[name 1] is not working, she is just looking after her younger siblings. I was not able to interview [name 2] because she is a special child."
mydata$c_s6q17[2338] <- "[name] is very hard to convince and hesitate and shy, i need to find him and run for him how many times, and i need to convince and explain to him why we should need to interview him, its realy realy hard convincing him but at the end I encourage him succesfully, and  he gains confidence to answer."
mydata$c_s6q17[2341] <- "[name] is 17 years old at his age he is already a father."
mydata$c_s6q17[2342] <- "[name] is willing to participate in our research."
mydata$c_s6q17[2343] <- "[name] is so kind eventhough he is sleepy he tried to finish all the images that i gave go him."
mydata$c_s6q17[2345] <- "[name]'s mother is in [small location 1] and his father is working in  [small location 2]."
mydata$c_s6q17[2346] <- "[name] did not finish grade 8 at her age she was pregnant."
mydata$c_s6q17[2347] <- "[name] is hesitant but I convince him to participate in our research."
mydata$c_s6q17[2348] <- "[name] only finish grade six at his age he had a live in partner."
mydata$c_s6q17[2370] <- "[name 1] is just the niece of [name 2],she is now acting as the mother of the child since the mother and father leave him.And [name 3] is not around during the data collection, he's at [small location] and will be back on sunday."
mydata$c_s6q17[2407] <- "The child was actively response to the queries and there is no problem while having the interview. He refuse to do the mirror game. Contact number for household respondent [contadt number deleted]"
mydata$c_s6q17[2422] <- "He is too shy and afraid at the same time but as we go with the interview he gain confident and the  interview went well.  The other child  ([name]) was not able to be interviewed because she was practicing for the graduation and attend a birthday party at [small location]"
mydata$c_s6q17[2432] <- "She did not finished all the images cause she find it hard. She is active and attentive in answering all the questions.  Her sister [name] was not able to be interviewed because she does not feel well she had undergo chemotheraphy because she had a cancer."
mydata$c_s6q17[2491] <- "[name]'s mother is paralyze due to stroke. [name] is the one helping her father in their daily errands."
mydata$c_s6q17[2493] <- "[name] is telling me a story while we are having the survey, its about her mom being hospitalized for 1 month and her sister passed away last 2 years due to heart problem."
mydata$c_s6q17[2504] <- "[name] is such a playful child, he stopped from studying last 3 months because he wants to play computer."
mydata$c_s6q17[2506] <- "[name]'s parents were hesitant for us to conduct the interview, but when we explained the reason why we need to conduct the survey, they said yes."
mydata$c_s6q17[2517] <- "[name] seems to be friendly and a very thoughtful child"
mydata$c_s6q17[2518] <- "[name] is confident and actively answering the questions."
mydata$c_s6q17[2519] <- "[name] is a very naughty child but a  very respectful. There father leave them since he is 1 years old."
mydata$c_s6q17[2520] <- "[name 1] is a silent type of child and respectful.There father leave them since she is in the womb of her mother.The child 1 namely [name 2] is not at home during the interview this summer she had a partime job."
mydata$c_s6q17[2521] <- "[name] is a shy type of child but a very respectful. There father leave them since he is 4 years old."
mydata$c_s6q17[2528] <- "[name] is happy kid. Everytime i asked her questions, she smiles in a friendly way. I was not able to interview Reymart because he refuses to. Her mother talked to him for hours and even hurt him but he still refused to be interviewed. I decided not to interview him anymore because I cannot bare his pain anymore."
mydata$c_s6q17[2529] <- "[name] is family oriented. She is waiting when will is the schedule of exam for Alternative Learning System."
mydata$c_s6q17[2530] <- "[name] do have a big dream in her life. She wants to finish her studies to help her parents."
mydata$c_s6q17[2534] <- "[name] is very cooperative."
mydata$c_s6q17[2535] <- "[name] is suffering from asthma.. That is the reason why he is not taking his course in a formal school."
mydata$c_s6q17[2536] <- "[name] is a honor student. Her parents were hoping that they can sustain her studies."
mydata$c_s6q17[2553] <- "[name] is out of school youth."
mydata$c_s6q17[2554] <- "[name] is hesitant because at his age he is only grade 5."
mydata$c_s6q17[2555] <- "[name] was not irritated that she was taken away from what she was doing to attend the interview. Her grandfather fetched her for us. She readily agreed to do the interview the minute she came home."
mydata$c_s6q17[2564] <- "[name] is hesitant in our first conversation but eventually she answers all the question spontaneously."
mydata$c_s6q17[2574] <- "[Tagalog]"
mydata$c_s6q17[2576] <- "[Tagalog]"
mydata$c_s6q17[2583] <- "[name] was very cooperative in answering the questions but during the game, he easily gave up and did not finish any of the images."
mydata$c_s6q17[2584] <- "Respondent seems shy and didn't want to speak or make more comments.  She mentioned that sometimes during weekends she works as a store attendant in her grandmother's store for which she earns [amount of money]per day - she gives half of it to her mom."
mydata$c_s6q17[2585] <- "[name] gets distracted towards the end of the survey and seems inattentive, keeps on moving and want to go away and play."
mydata$c_s6q17[2609] <- "First part of the interview was private but other household members (mother and grandfather) started to be suspicious at the middle of the interview and parents asked us to stop the interview so we just finished [name]'s interview and wasn't able to proceed with the third child.  [name] seems nervous and shy during the interview and he was distracted by the people around since there was no private place inside their house to conduct the interview. We have done it at their terrace."
mydata$c_s6q17[2621] <- "[Tagalog]"
mydata$c_s6q17[2632] <- "[Tagalog]"
mydata$c_s6q17[2666] <- "The child answered the questions very well.  The third child was not around because she went for a vacation in their relative's house in [small location] and parents are not sure when will she come back, but they gave consent for this child's interview. Third child left for about a week ago though they are sure that she will come back they cannot tell the exact date."
mydata$c_s6q17[2777] <- "[name 1] was participative. She was able to try all images in the mirror game and did quite well. Some relatives/neighbors were present during the game part. She paid full attention though she did not make eye contact. She smiled for every positive statement and answer regarding parenting style. [name 2] and [name 1] are twins."
mydata$c_s6q17[2831] <- "[Tagalog]"
mydata$c_s6q17[2941] <- "The child is working in her relative collecting coconut and taking care of carabai. She just started Monday last week and 4 days in a week. Its her 7th day of working. She is working Monday, Wednesday, Thursday and Friday with [amount of money] daily wage. She is boyish."
mydata$c_s6q17[3088] <- "She will go to [small location] next month to work as a domestic helper"
mydata$c_s6q17[3093] <- "[Tagalog]"
mydata$c_s6q17[3158] <- "Im doing the child while [name] is doing the hh. No electricity in their house."
mydata$c_s6q17[3159] <- "[NAME] DOING THE HH WHILE IM DOING THE CHILD."
mydata$c_s6q17[3211] <- "Completed.The one whom I interviewed is [name 1] not [name 2]"
mydata$c_s6q17[3213] <- "Interviewed conducted in [small location] hall because their house is very far from the barrio site."
mydata$c_s6q17[3260] <- "Shy but participative. This is the Child Survey number 2 of [name]"
mydata$c_s6q17[3274] <- "[name] met a bicycle accident  Last september 2, 2015.due to overspeeding and hit concrete gutter and dislocated his ankle.."
mydata$c_s6q17[3296] <- "His mother is in [small location] that is why he keep saying that it is moderately unlike when it comes to their relationship."
mydata$c_s6q17[3302] <- "She was baby sitting in [small location] before and her boss wants to bring her in America but she refused because she dont want to leave his father who is almost blind"
mydata$c_s6q17[3316] <- "[Tagalog]"
mydata$c_s6q17[3587] <- "[Tagalog]"
mydata$c_s6q17[3588] <- "[Tagalog]"
mydata$c_s6q17[3883] <- "[Tagalog]"
mydata$c_s6q17[3885] <- "[Tagalog]"
mydata$c_s6q17[3886] <- "[Tagalog]"
mydata$c_s6q17[3903] <- "[Tagalog]"
mydata$c_s6q17[3927] <- "I asked the details of the household roster list to [name 1] , [name 2] elder sister as the mother left before the interview start."
mydata$c_s6q17[3942] <- "[name 1] is [name 2]'s son to her first husband. [name 1] is working in bakery."
mydata$c_s6q17[3963] <- "Roster 3 [name] 16 is working ."
mydata$c_s6q17[4032] <- "The child is very relax while taking care her son during our interview. Pls delete Roster 3 [name] he is a migrant."
mydata$c_s6q17[4073] <- "[Tagalog]"
mydata$c_s6q17[4096] <- "The child just got home last two weeks. She is busy right now for examination for scholarship in college in [small location]"

#'# GPS data: Displace
# !!!No GPS data



#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
