#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_1" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed

# !!!No Direct PII 


#'# Direct PII-team: Encode field team names

# !!!No Direct PII-team 


#'# Small locations: Encode locations  with pop <100,000 using random large numbers

# !!!No Small locations


#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 

# Top code household composition variables with large and unusual numbers 

mydata <- top_recode ("c_s1q1", break_point=12, missing=c(888, 999999)) # !!!Topcode cases with 12 or more members. 
mydata <- top_recode ("c_s1q2", break_point=11, missing=c(888, 999999)) # !!!Topcode cases corresponding to 11 or higher
mydata <- top_recode ("c_s1q3", break_point=6, missing=c(888, 999999)) # !!!Topcode cases with 6 or more older sisters


#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values

# !!!No Indirect PII - Categorical


#'# Matching and crosstabulations: Run automated PII check 

# !!!Insufficient demographic data


#'# Open-ends: review responses for any sensitive information, redact as necessary

# !!! Identify open-end variables here: 
open_ends <- c("c_s1q1noresponse", "c_s1q2noresponse", "c_s1q3noresponse")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata$c_s1q1noresponse[508] <- "[Name redacted] is the guardian of the child, the child came from a broken family,and the father of the child went abroad and the mother of the child went to [location redacted] and have her own family already."


#'# GPS data: Displace

# !!!No GPS data


#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
