#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "DOLE" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 0
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 



#'# Direct PII: variables to be removed
# !!!No Direct PII 

#'# Direct PII-team: Encode field team names
# !!!No Direct PII - team

#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!Include relevant variables, but check their population size first to confirm they are <100,000

locvars <- c("Municipality") 
mydata <- encode_location (variables= locvars, missing=999999)

#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Top code high income to the 99.5 percentile

mydata$Assetvalue <- as.numeric(mydata$Assetvalue)
percentile_99.5 <- floor(quantile(na.exclude(mydata$Assetvalue)[na.exclude(mydata$Assetvalue)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="Assetvalue", break_point=percentile_99.5, missing=-97)


#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("Assettype",
                  "Compliance",
                  "Training1Description",
                  "Training2Description",
                  "Training3Decription",
                  "assettype_clean",
                  "assetcat",
                  "assets_exp")

capture_tables (indirect_PII)

# Recode those with very specific values. 

break_activity <- c(1, 	2, 	3, 	4, 	5, 	6, 	7, 	8, 	10, 	11, 	12, 	13, 	14, 	15, 	16, 	17, 	18, 	20, 	21, 	22, 	23, 	24, 	25)
labels_activity <- c("Sari Sari business/equipment"=1,
                     "Prepared-Food business/equipment (rice, vegetables, fish, etc)"=2,
                     "Fishing business/equipment"=3,
                     "Others"=4,
                     "Others"=5,
                     "Others"=6,
                     "Others"=7,
                     "Others"=8,
                     "Others"=9,
                     "Others"=10,
                     "Others"=11,
                     "Others"=12,
                     "Others"=13,
                     "Others"=14,
                     "Others"=15,
                     "Others"=16,
                     "Tools and equipment"=17,
                     "Others"=18,
                     "Others"=19,
                     "Others"=20,
                     "Others"=21,
                     "Others"=22,
                     "Others"=23)
mydata2 <- ordinal_recode (variable="assetcat", break_points=break_activity, missing=999999, value_labels=labels_activity)



mydata <- mydata[!names(mydata) %in% "Assettype"]
mydata <- mydata[!names(mydata) %in% "assettype_clean"]
# !!!Removed, as it contains sensitive information and there is another variable that contains this information at a more aggregated level.


#'# Matching and crosstabulations: Run automated PII check 
# !!!Insufficient demographic data


#'# Open-ends: review responses for any sensitive information, redact as necessary
# !!!No Open-ends

#'# GPS data: Displace
# !!!No GPS data

#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))

# Transform stata date format to string for spss compatibility

mydata$Date2 <- as.character(mydata$Date2)
mydata$Date3 <- as.character(mydata$Date3)
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
