#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "midline_bgy_captain_survey" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)


#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed
# !!!No Direct PII 


#'# Direct PII-team: Encode field team names
# !!!No Direct PII - team


#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!Include relevant variables, but check their population size first to confirm they are <100,000

locvars <- c("m_s0q4") 
mydata <- encode_location (variables= locvars, missing=999999)


#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 


percentile_99.5 <- floor(quantile(na.exclude(mydata$bcs_s1q2)[na.exclude(mydata$bcs_s1q2)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="bcs_s1q2", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$bcs_s1q5)[na.exclude(mydata$bcs_s1q5)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="bcs_s1q5", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$bcs_s1q7)[na.exclude(mydata$bcs_s1q7)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="bcs_s1q7", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$bcs_s1q8)[na.exclude(mydata$bcs_s1q8)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="bcs_s1q8", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$bcs_s1q9)[na.exclude(mydata$bcs_s1q9)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="bcs_s1q9", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$bcs_s1q10)[na.exclude(mydata$bcs_s1q10)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="bcs_s1q10", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$bcs_s1q11)[na.exclude(mydata$bcs_s1q11)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="bcs_s1q11", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$bcs_s1q12)[na.exclude(mydata$bcs_s1q12)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="bcs_s1q12", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$bcs_s1q13)[na.exclude(mydata$bcs_s1q13)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="bcs_s1q13", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$bcs_s1q16)[na.exclude(mydata$bcs_s1q16)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="bcs_s1q16", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$bcs_s1q17)[na.exclude(mydata$bcs_s1q17)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="bcs_s1q17", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$bcs_s1q18)[na.exclude(mydata$bcs_s1q18)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="bcs_s1q18", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$bcs_ty_2)[na.exclude(mydata$bcs_ty_2)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="bcs_ty_2", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$bcs_ty_5)[na.exclude(mydata$bcs_ty_5)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="bcs_ty_5", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$bcs_ty_7)[na.exclude(mydata$bcs_ty_7)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="bcs_ty_7", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$bcs_ty_10)[na.exclude(mydata$bcs_ty_10)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="bcs_ty_10", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$bcs_ty_12)[na.exclude(mydata$bcs_ty_12)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="bcs_ty_12", break_point=percentile_99.5, missing=999999)


#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("bcs_s0q21",
                  "bcs_s1q1",
                  "bcs_s1q3",
                  "bcs_s1q4",
                  "bcs_s1q14",
                  "bcs_s1q15",
                  "bcs_ty_1",
                  "bcs_ty_3",
                  "bcs_ty_4",
                  "bcs_ty_6",
                  "bcs_ty_8",
                  "bcs_ty_9",
                  "bcs_ty_11",
                  "bcs_vio_5",
                  "bcs_vio_7",
                  "bcs_vio_9",
                  "bcs_qua_7",
                  "bcs_rec_1",
                  "bcs_rec_4",
                  "bcs_dev_3__1",
                  "bcs_dev_5__1",
                  "bcs_dev_3__2",
                  "bcs_dev_5__2",
                  "bcs_dev_3__3",
                  "bcs_dev_5__3",
                  "bcs_dev_3__4",
                  "bcs_dev_5__4",
                  "bcs_dev_3__5",
                  "bcs_dev_5__5",
                  "bcs_dev_3__6",
                  "bcs_dev_5__6")

capture_tables (indirect_PII)

# Recode those with very specific values. 

break_activity <- c(1,	2,	3,	4,	5,	6)
labels_activity <- c("Barangay Captain"=1,
                     "Counselor"=2,
                     "Other"=3,
                     "Other"=4,
                     "Other"=5,
                     "Other"=6)
mydata <- ordinal_recode (variable="bcs_s1q1", break_points=break_activity, missing=999999, value_labels=labels_activity)

break_activity <- c(1,	2,	3,	4,	5,	6)
labels_activity <- c("Other"=1,
                     "Counselor"=2,
                     "Other"=3,
                     "Other"=4,
                     "Other"=5,
                     "Other"=6)
mydata <- ordinal_recode (variable="bcs_s1q4", break_points=break_activity, missing=999999, value_labels=labels_activity)


break_source <- c(-999,-998,1,2,3,4)
labels_source <- c("Refused to answer"=1,
                     "Don't know"=2,
                     "Connected to Grid"=3,
                     "Local Hydroelectric"=4,
                     "Other"=5,
                     "Other"=6)
mydata <- ordinal_recode (variable="bcs_s1q15", break_points=break_source, missing=999999, value_labels=labels_source)


#'# Matching and crosstabulations: Run automated PII check 
# !!!Insufficient demographic data


#'# Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("bcs_scq2",
               "bcs_scq4",
               "bcs_s1q1_other",
               "bcs_s1q4_other",
               "bcs_political1other",
               "bcs_political2other",
               "bcs_political3other",
               "bcs_s1q15other",
               "bcs_s1q19other",
               "bcs_calc_4",
               "bcs_qua_3",
               "bcs_qua_4",
               "bcs_qua_5",
               "bcs_qua_6",
               "bcs_qua_8",
               "bcs_qua_9",
               "bcs_dev_2__1",
               "bcs_dev_4__1",
               "bcs_dev_6__1",
               "bcs_dev_2__2",
               "bcs_dev_4__2",
               "bcs_dev_6__2",
               "bcs_dev_2__3",
               "bcs_dev_4__3",
               "bcs_dev_6__3",
               "bcs_dev_2__4",
               "bcs_dev_4__4",
               "bcs_dev_6__4",
               "bcs_dev_2__5",
               "bcs_dev_4__5",
               "bcs_dev_6__5",
               "bcs_dev_2__6",
               "bcs_dev_4__6",
               "bcs_dev_6__6")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata$bcs_s1q1_other[56] <- "Other"
mydata$bcs_s1q1_other[102] <- "Other"
mydata$bcs_s1q4_other[5] <- "Other"
mydata$bcs_s1q4_other[7] <- "Other"
mydata$bcs_s1q4_other[8] <- "Other"
mydata$bcs_s1q4_other[12] <- "Other"
mydata$bcs_s1q4_other[98] <- "Other"
mydata$bcs_s1q4_other[107] <- "Other"
mydata$bcs_s1q4_other[131] <- "Other"
mydata$bcs_s1q4_other[149] <- "Other"
mydata$bcs_political2other[151] <- "[small location redacted] is not covered by prov.council"
mydata$bcs_political2other[152] <- "[small location redacted] is not covered buy prov.council"


#'# GPS data: Displace
# !!!No GPS data


#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
