#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "SAP20152016_Urbano_NOPII" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed

# !!!Include any Direct PII variables
dropvars <- c("jefe_nom_2015",
              "jefe_priape_2015",
              "jefe_segape_2015",
              "bf1_fname_2015",
              "bf1_sname_2015",
              "bf1_flastname_2015",
              "bf1_slastname_2015",
              "bf2_fname_2015",
              "bf2_sname_2015",
              "bf2_flastname_2015",
              "bf2_slastname_2015",
              "bf3_fname_2015",
              "bf3_sname_2015",
              "bf3_flastname_2015",
              "bf3_slastname_2015",
              "A_NOM",
              "C_NOM",
              "A_APEPAT",
              "C_APEPAT",
              "A_APEMAT",
              "C_APEMAT",
              "DNI",
              "J_DNI",
              "L_DNI",
              "bf1_fname_2016",
              "bf1_sname_2016",
              "bf1_flastname_2016",
              "bf1_slastname_2016",
              "bf2_fname_2016",
              "bf2_sname_2016",
              "bf2_flastname_2016",
              "bf2_slastname_2016",
              "bf3_fname_2016",
              "bf3_sname_2016",
              "bf3_flastname_2016",
              "bf3_slastname_2016") 
mydata <- mydata[!names(mydata) %in% dropvars]


#'# Direct PII-team: Encode field team names
# !!!Replace vector in "variables" field below with relevant variable names

mydata <- mydata[!names(mydata) %in% "DIGITA"]


#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!Include relevant variables, but check their population size first to confirm they are <100,000

mydata <- mydata[!names(mydata) %in% "NOMESC"]

as.numeric(mydata$CODLOC)
locvars <- c("CODLOC", "COD_MOD_2015", "COD_MOD_2016", "cod_local") 
mydata <- encode_location (variables= locvars, missing=999999)

#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 
dropvars <- c("D_DD",
              "D_MM",
              "F_DD",
              "F_MM") 
mydata <- mydata[!names(mydata) %in% dropvars]

#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!No Indirect PII - Categorical

#'# Matching and crosstabulations: Run automated PII check 

# Based on dictionary inspection, select variables for creating sdcMicro object
# See: https://sdcpractice.readthedocs.io/en/latest/anon_methods.html
# All variable names should correspond to the names in the data file
# selected categorical key variables: gender, occupation/education and age
selectedKeyVars = c('sexo', 'edad_2015') 

mydata$edad_2015 <- round(mydata$edad_2015, 1)

# weight variable (add if available)
# selectedWeightVar = c('projwt') ##!!! Replace with weight var

# household id variable (cluster)
# selectedHouseholdID = c('wpid') ##!!! Replace with household id

# creating the sdcMicro object with the assigned variables
sdcInitial <- createSdcObj(dat = mydata, keyVars = selectedKeyVars)
sdcInitial

#' Show values of key variable of records that violate k-anonymity
mydata <- labelDataset(mydata)
notAnon <- sdcInitial@risk$individual[,2] < 2 # for 2-anonymity
mydata[notAnon,selectedKeyVars]
sdcFinal <- localSuppression(sdcInitial)

# Recombining anonymized variables

extractManipData(sdcFinal)[notAnon,selectedKeyVars] # manipulated variables HH
mydata [notAnon,"sexo"] <- NA
mydata [notAnon,"edad_2015"] <- round(mydata[notAnon,"edad_2015"], 0)
sdcInitial <- createSdcObj(dat = mydata, keyVars = selectedKeyVars)
sdcInitial

#'# Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("name_schship_2015",
               "name_schship_2016",
               "name_cred_2016",
               "unitec_b_2016",
               "nopay_wlta_sup_b_2016")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

# !!!Remove, as they contain a lot of sensitive information and they are in Spanish.
mydata <- mydata[!names(mydata) %in% "name_schship_2015"]
mydata <- mydata[!names(mydata) %in% "name_schship_2016"]
mydata <- mydata[!names(mydata) %in% "name_cred_2016"]
mydata <- mydata[!names(mydata) %in% "unitec_b_2016"]
mydata <- mydata[!names(mydata) %in% "nopay_wlta_sup_b_2016"]


#'# GPS data: Displace
# !!!No GPS data


#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))

# Change names of columns containing illegal starting characters (i.e. "_") for SPSS

mydata <- haven::read_dta(paste0(filename, "_PU.dta"))
colnames(mydata)[grep("^_", colnames(mydata))] <- c("x000000_2016", "msap2016", "dropoutpooldata2015", "dropoutpooldata2016", 
                                                    "rank", "mergeCMExtra", "seguimiento2015", "seguimiento2016")

mydata[is.na(mydata)] <- NA
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
