#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "SAP20152016_Rural_NOPII" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)

#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed

# !!!Include any Direct PII variables
dropvars <- c("A_NOM",
              "C_NOM",
              "A_APEPAT",
              "C_APEPAT",
              "A_APEMAT",
              "C_APEMAT",
              "DNI_2015",
              "FIRMA_2015",
              "dni_2015",
              "J_DNI",
              "L_DNI",
              "FIRMA_2016",
              "dni_2016",
              "ubigeo_2016",
              "nombre_ie_2016") 
mydata <- mydata[!names(mydata) %in% dropvars]

#'# Direct PII-team: Encode field team names
# !!!Replace vector in "variables" field below with relevant variable names

mydata <- encode_direct_PII_team (variables=c("ENCUES_2015", "ENCUES_2016"))
mydata <- mydata[!names(mydata) %in% "DIGITA"] 

#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!Include relevant variables, but check their population size first to confirm they are <100,000

mydata <- mydata[!names(mydata) %in% "NOMESC"] 

locvars <- c("CODLOC",
             "CODMOD_2015",
             "Escuela",
             "cod_local_2016",
             "codlocal_2016",
             "Escuela_2016",
             "COD_MOD_2015",
             "COD_MOD_2016") 
mydata <- encode_location (variables= locvars, missing=999999)


#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 

dropvars <- c("D_DD",
              "D_MM",
              "F_DD",
              "F_MM",
              "fecha_nacimiento_2016") 
mydata <- mydata[!names(mydata) %in% dropvars]


#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("TURNO",
                  "idioma1_2015",
                  "I_SEXO",
                  "area")

capture_tables (indirect_PII)


# Recode those with very specific values. 


break_language <- c(-9,-8,-7,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16)
labels_language <- c("No indica"=1,
                     "No se puede leer"=2,
                     "Error"=3,
                     "Castellano \xf3 Espa\xf1ol"=4,
                     "Quechua"=5,
                     "Aymara"=6,
                     "Otro"=7,
                     "Ingl\xe9s"=8,
                     "Portugues"=9,
                     "Franc\xe9s"=10,
                     "Italiano"=11,
                     "Shipibo"=12,
                     "Aguaruna"=13,
                     "Machiguenga"=14,
                     "Alem\xe1n"=15,
                     "Catal\xe1n"=16,
                     "Hindu"=17,
                     "Coreano"=18,
                     "Chino"=19)
mydata <- ordinal_recode (variable="idioma1_2015", break_points=break_language, missing=999999, value_labels=labels_language)



#'# Matching and crosstabulations: Run automated PII check 
# selected categorical key variables: gender, occupation/education and age
selectedKeyVars = c('sexo', 'grado11') ##!!! Replace with candidate categorical demo vars


# creating the sdcMicro object with the assigned variables
sdcInitial <- createSdcObj(dat = mydata, keyVars = selectedKeyVars)
sdcInitial


#' Show values of key variable of records that violate k-anonymity
mydata <- labelDataset(mydata)
notAnon <- sdcInitial@risk$individual[,2] < 2 # for 2-anonymity
mydata[notAnon,selectedKeyVars]
sdcFinal <- localSuppression(sdcInitial)


#'# Open-ends: review responses for any sensitive information, redact as necessary

# !!! Identify open-end variables here: 
open_ends <- c("name_schship_2015",
              "name_schship_2016")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

# !!!Removed, as they contain a lot of sensitive information and they are in Spanish.
mydata <- mydata[!names(mydata) %in% "name_schship_2015"]
mydata <- mydata[!names(mydata) %in% "name_schship_2016"]

#'# GPS data: Displace
# !!!No GPS data

#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))

colnames(mydata) <- gsub('^_', '', colnames(mydata))

mydata [is.na(mydata)] <- NA
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
