#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "IDT_raw_parents_NOPII" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)

#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed

# !!!Include any Direct PII variables

dropvars <- c("prompt_student_id",
              "student_id",
              "student_name",
              "no_guardian_name",
              "grado2016_admin_name",
              "sap_househead_name",
              "consent_signature",
              "consent_signature_paper",
              "hh_name1",
              "hh_name2",
              "hh_lastname1",
              "hh_lastname2",
              "hh_dni",
              "i31",
              "p60",
              "reference",
              "i32",
              "random_audio_hh",
              "p27a1",
              "p27a2",
              "p27a3",
              "p27a4",
              "p27a5",
              "p27a6",
              "p27a7",
              "p27a8",
              "p27c1",
              "p27c2",
              "p27d1",
              "p27d2",
              "p27d3",
              "p27d4",
              "p27ma1",
              "p27ma2",
              "p27ma3",
              "p27ma4",
              "p27ma5",
              "p27ma6",
              "p27mc1",
              "p27mc2",
              "p27mc3",
              "p27mc4",
              "p27mc5",
              "p27mc6",
              "p27md1", 
              "address") 
mydata <- mydata[!names(mydata) %in% dropvars]

#'# Direct PII-team: Encode field team names

# !!!Replace vector in "variables" field below with relevant variable names

dropvars <- c("i4")
mydata <- mydata[!names(mydata) %in% dropvars]

mydata <- encode_direct_PII_team (variables=c("i5"))


#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!Include relevant variables, but check their population size first to confirm they are <100,000

locvars <- c("cod_mod2016_admin", "district", "p63") 
mydata <- encode_location (variables= locvars, missing=999999)

dropvars <- c("p62")
mydata <- mydata[!names(mydata) %in% dropvars]


#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values

# Recode ages

mydata$hh_ageinyears <- as.numeric(mydata$hh_ageinyears)

break_age <- c(18,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50)
labels_age <- c("30 or younger" =1, 
                "31"=2,
                "32"=3,
                "33"=4,
                "34"=5,
                "35"=6,
                "36"=7,
                "37"=8,
                "38"=9,
                "39"=10,
                "40"=11,
                "41"=12,
                "42"=13,
                "43"=14,
                "44"=15,
                "45"=16,
                "46"=17,
                "47"=18,
                "48"=19,
                "49"=20,
                "50 or older"=21,
                "NA" = 22)
mydata <- ordinal_recode (variable="hh_ageinyears", break_points=break_age, missing=999999, value_labels=labels_age)


# Recode education attainment of adults to reduce risk of re-identification 

break_edu <- c(-98,1,3,4,5,6,7,8,9)
labels_edu <- c("No se"=1,
                "Pri Incomp or less"=2,
                "Pri Comp"=3,
                "Sec Incomp"=4,
                "Sec Comp"=5,
                "Tec Incomp"=6,
                "Tec Comp"=7,
                "Uni Incomp"=8,
                "Uni Comp"=9)
mydata <- ordinal_recode (variable="p6_1", break_points=break_edu, missing=999999, value_labels=labels_edu)


break_edu <- c(-98,1,2,3,4,5,6)
labels_edu <- c("No se"=1,
                "Sin nivel"=2,
                "Pri Incomp"=3,
                "Pri Comp"=4,
                "Sec Incomp"=5,
                "Sec Comp"=6,
                "Tec Incomp/Comp or Uni Incomp/Comp"=7)
mydata <- ordinal_recode (variable="p6b1", break_points=break_edu, missing=999999, value_labels=labels_edu)



break_edu <- c(-98,1,3,4)
labels_edu <- c("No se"=1,
                "Pri Incomp or less"=2,
                "Pri Comp"=3,
                "Sec Incomp/Comp, Tec Imcomp/Comp or Uni Incomp/Comp"=4)
mydata <- ordinal_recode (variable="p6b2", break_points=break_edu, missing=999999, value_labels=labels_edu)

break_edu <- c(-98,1,4,5,6)
labels_edu <- c("No se"=1,
                "Pri Comp or less"=2,
                "Sec Incomp"=3,
                "Sec Comp"=4,
                "Tec Incomp/Comp or Uni Incomp/Comp"=5)
mydata <- ordinal_recode (variable="p6c1", break_points=break_edu, missing=999999, value_labels=labels_edu)


break_edu <- c(-98,1,5,6)
labels_edu <- c("No se"=1,
                "Sec Incomp or less"=2,
                "Sec Comp"=3,
                "Tec Imcomp/Comp or Uni Incomp/Comp"=4)
mydata <- ordinal_recode (variable="p6c2", break_points=break_edu, missing=999999, value_labels=labels_edu)

break_edu <- c(-98,1,6)
labels_edu <- c("No se"=1,
                "Sec Comp or less"=2,
                "Tec Imcomp/Comp or Uni Incomp/Comp"=3)
mydata <- ordinal_recode (variable="p6c3", break_points=break_edu, missing=999999, value_labels=labels_edu)


# Top code household composition variables with large and unusual numbers 

mydata <- top_recode ("p1", break_point=10, missing=c(888, 999999))  
mydata <- top_recode ("p2c", break_point=5, missing=c(888, 999999))
mydata <- top_recode ("p2d", break_point=2, missing=c(888, 999999))
mydata <- top_recode ("p2e", break_point=3, missing=c(888, 999999))
mydata <- top_recode ("p2f", break_point=2, missing=c(888, 999999))
mydata <- top_recode ("p2g", break_point=3, missing=c(888, 999999))

# Top code high income to the 99.5 percentile

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7_1)[na.exclude(mydata$p7_1)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7_1", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7_2)[na.exclude(mydata$p7_2)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7_2", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7a1)[na.exclude(mydata$p7a1)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7a1", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7a2)[na.exclude(mydata$p7a2)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7a2", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7a3)[na.exclude(mydata$p7a3)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7a3", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7a4)[na.exclude(mydata$p7a4)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7a4", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7a5)[na.exclude(mydata$p7a5)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7a5", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7a6)[na.exclude(mydata$p7a6)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7a6", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7a7)[na.exclude(mydata$p7a7)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7a7", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7b1)[na.exclude(mydata$p7b1)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7b1", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7b2)[na.exclude(mydata$p7b2)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7b2", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7c1)[na.exclude(mydata$p7c1)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7c1", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7c2)[na.exclude(mydata$p7c2)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7c2", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7c3)[na.exclude(mydata$p7c3)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7c3", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7c4)[na.exclude(mydata$p7c4)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7c4", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7c5)[na.exclude(mydata$p7c5)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7c5", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7c6)[na.exclude(mydata$p7c6)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7c6", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7d1)[na.exclude(mydata$p7d1)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7d1", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7d2)[na.exclude(mydata$p7d2)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7d2", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p49)[na.exclude(mydata$p49)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p49", break_point=percentile_99.5, missing=-97)


# Top code number of rooms variables with large and unusual numbers

mydata <- top_recode ("p9", break_point=7, missing=c(888, 999999))

#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("student_female",
                  "hh_gender",
                  "attending_confirm",
                  "grado2016_confirm",
                  "p2a",
                  "p2b",
                  "p3a1",
                  "p3a2",
                  "p3a3",
                  "p3a4",
                  "p3a5",
                  "p3a6",
                  "p3a7",
                  "p3a8",
                  "p3b1",
                  "p3b2",
                  "p3b3",
                  "p3c1",
                  "p3c2",
                  "p3c3",
                  "p3c4",
                  "p3c5",
                  "p3c6",
                  "p3d1",
                  "p3d2",
                  "p3d3",
                  "p3d4",
                  "p3d5",
                  "p3d6",
                  "p26a1",
                  "p26a2",
                  "p26a3",
                  "p26a4",
                  "p26a5",
                  "p26a6",
                  "p26a7",
                  "p26a8",
                  "p26c1",
                  "p26c2",
                  "p26c3",
                  "p26c4",
                  "p26c5",
                  "p26c6",
                  "p26d1",
                  "p26d2",
                  "p26d3",
                  "p26d4",
                  "p26d5",
                  "p26d6",
                  "p4_1",
                  "p4_2",
                  "p4a1",
                  "p4a2",
                  "p4a3",
                  "p4a4",
                  "p4a5",
                  "p4a6",
                  "p4a7",
                  "p4a8",
                  "p4b1",
                  "p4b2",
                  "p4b3",
                  "p4c1",
                  "p4c2",
                  "p4c3",
                  "p4c4",
                  "p4c5",
                  "p4c6",
                  "p4d1",
                  "p4d2",
                  "p4d3",
                  "p5_aa1",
                  "p5_aa2",
                  "p5_aa3",
                  "p5_aa4",
                  "p5_aa5",
                  "p5_aa6",
                  "p5_aa7",
                  "p5_aa8",
                  "p23a",
                  "p23_1",
                  "p23_2",
                  "p23a1",
                  "p23a2",
                  "p23a3",
                  "p23a4",
                  "p23a5",
                  "p23a6",
                  "p23a7",
                  "p23a8",
                  "p23b1",
                  "p23b2",
                  "p23b3",
                  "p23c1",
                  "p23c2",
                  "p23c3",
                  "p23c4",
                  "p23c5",
                  "p23c6",
                  "p23d1",
                  "p23d2",
                  "p23d3",
                  "p8",
                  "p42",
                  "p43",
                  "p44b",
                  "p44b_1",
                  "p44b_2",
                  "p44b_3",
                  "p44b_4",
                  "p44b_5",
                  "p44b_6",
                  "p44b_7",
                  "p44b_8",
                  "p44b_99",
                  "p50",
                  "p53",
                  "p55",
                  "p59")

capture_tables (indirect_PII)

# Recode those with very specific values.


break_activity <- c(1,2,3,4,5)
labels_activity <- c("Otros"=1,
                    "Estudia y tiene un trabajo remunerado"=2,
                    "Trabajo remunerado"=3,
                    "Quehaceres del hogar o trabajo no remunerado"=4,
                    "No hace nada"=5)
mydata <- ordinal_recode (variable="p4b1", break_points=break_activity, missing=999999, value_labels=labels_activity)


break_activity <- c(1,2,3,4,5)
labels_activity <- c("Otros"=1,
                     "Otros"=2,
                     "Trabajo remunerado"=3,
                     "Quehaceres del hogar o trabajo no remunerado"=4,
                     "Otros"=5)
mydata <- ordinal_recode (variable="p4c1", break_points=break_activity, missing=999999, value_labels=labels_activity)


break_activity <- c(1,2,3,4,5)
labels_activity <- c("Otros"=1,
                     "Otros"=2,
                     "Trabajo remunerado"=3,
                     "Otros"=4,
                     "Otros"=5)
mydata <- ordinal_recode (variable="p4c2", break_points=break_activity, missing=999999, value_labels=labels_activity)

break_activity <- c(1,2,3,4,5)
labels_activity <- c("Otros"=1,
                     "Otros"=2,
                     "Trabajo remunerado"=3,
                     "Otros"=4,
                     "Otros"=5)
mydata <- ordinal_recode (variable="p4c3", break_points=break_activity, missing=999999, value_labels=labels_activity)


break_activity <- c(1,2,3,4,5)
labels_activity <- c("Estudia"=1,
                     "Otros"=2,
                     "Otros"=3,
                     "Otros"=4,
                     "Otros"=5)
mydata <- ordinal_recode (variable="p4d1", break_points=break_activity, missing=999999, value_labels=labels_activity)


break_material <- c(1,2,3,4,5,6,7,8,9)
labels_material <- c("Concreto, ladrillos o cemento"=1,
                     "Otro"=2,
                     "Calamina de metal o metal"=3,
                     "Calamina de plastico o plastico"=4,
                     "Madera"=5,
                     "Otro"=6,
                     "Otro"=7,
                     "Otro"=8,
                     "Otro"=9)
mydata <- ordinal_recode (variable="p8", break_points=break_material, missing=999999, value_labels=labels_material)


#'# Matching and crosstabulations: Run automated PII check 

# selected categorical key variables: gender, occupation/education and age
selectedKeyVars = c('hh_gender', 'hh_ageinyears', 'p4_1') ##!!! Replace with candidate categorical demo vars

# weight variable (add if available)
# selectedWeightVar = c('projwt') ##!!! Replace with weight var

# household id variable (cluster)
# selectedHouseholdID = c('wpid') ##!!! Replace with household id

# creating the sdcMicro object with the assigned variables
sdcInitial <- createSdcObj(dat = mydata, keyVars = selectedKeyVars)
sdcInitial

#' Show values of key variable of records that violate k-anonymity
#mydata <- labelDataset(mydata)
notAnon <- sdcInitial@risk$individual[,2] < 2 # for 2-anonymity
mydata[notAnon,selectedKeyVars]
sdcFinal <- localSuppression(sdcInitial)

# Recombining anonymized variables

extractManipData(sdcFinal)[notAnon,selectedKeyVars] # manipulated variables HH
mydata [notAnon,"hh_gender"] <- NA
mydata[notAnon,"p4_1"] <- NA


#'# Open-ends: review responses for any sensitive information, redact as necessary
 
# !!! Identify open-end variables here: 
open_ends <- c("hh_parentesco_other",
               "pref65f",
               "pref66f",
               "p44c",
               "p51a",
               "i19a1",
               "p8a")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata <- mydata[!names(mydata) %in% "hh_parentesco_other"] # Drop as actually verbatim data in Spanish
mydata <- mydata[!names(mydata) %in% "pref65f"] # Drop as actually verbatim data in Spanish
mydata <- mydata[!names(mydata) %in% "pref66f"] # Drop as actually verbatim data in Spanish
mydata <- mydata[!names(mydata) %in% "p44c"] # Drop as actually verbatim data in Spanish
mydata <- mydata[!names(mydata) %in% "p51a"] # Drop as actually verbatim data in Spanish
mydata <- mydata[!names(mydata) %in% "i19a1"] # Drop as actually verbatim data in Spanish
mydata <- mydata[!names(mydata) %in% "p8a"] # Drop as actually verbatim data in Spanish

#'# GPS data: Displace
# Setup map
# !!!No GPS data

#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
