#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "InDepthParents2016_Rural_Raw_NOPII" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#' #Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#!!!Save flagged dictionary in .csv format, add "DatasetReview" to name and continue processing data with subset of flagged variables


#' #Direct PII: variables to be removed

# !!!Include any Direct PII variables
dropvars <- c("student_name",
              "cto_padre_nom",
              "name_pad",
              "dia_nac",
              "mes_nac",
              "fecha_nac",
              "telf_yesno",
              "num_telf",
              "future_parent",
              "school_parent",
              "education_parent",
              "treated_2015",
              "video_start",
              "video_end",
              "pic_home",
              "audio_video",
              "key",
              "fecha_nac_fixed",
              "p27a1",
              "p27a2",
              "p27a3",
              "p27a4",
              "p27a5",
              "p27a6",
              "p27a7",
              "p27a8",
              "p27a9",
              "p27a10",
              "p27d1",
              "p27d2",
              "p27d3") 
mydata <- mydata[!names(mydata) %in% dropvars]

# !!!Encode ID variables
mydata <- encode_direct_PII_team (variables=c("id_alumno"))
mydata <- encode_direct_PII_team (variables=c("id_alumno_preloaded"))

#' #Direct PII-team: Encode field team names
#  Interviewer names, for example  may be useful for analysis of interviewer effects
#' !!!Replace vector in "variables" field below with relevant variable names

mydata <- encode_direct_PII_team (variables=c("i5"))

#' #Small locations: Encode locations  with pop <100,000 using random large numbers
#'  !!!Include relevant variables, but check their population size first to confirm they are <100,000

locvars <- c("i8a",
             "i7",
             "geo_points1") 
mydata <- encode_location (variables= locvars, missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 

mydata$age1 <- as.numeric(mydata$age1)

break_age <- c(29,31,32,33,35,37,38,39,40,41,42,43,44,45,46,48,49,50)
labels_age <- c("30 or younger" =1, 
                "31"=2,
                "32"=3,
                "33"=4,
                "35"=5,
                "37"=6,
                "38"=7,
                "39"=8,
                "40"=9,
                "41"=10,
                "42"=11,
                "43"=12,
                "44"=13,
                "45"=14,
                "46"=15,
                "48"=16,
                "49"=17,
                "50 or older"=18,
                "NA" = 19)
mydata <- ordinal_recode (variable="age1", break_points=break_age, missing=999999, value_labels=labels_age)

# Recode education attainment of adults to reduce risk of re-identification 

break_edu <- c(-98,-1,0,1,2,3,8)
labels_edu <- c("No se"=1,
                "Sin nivel"=2,
                "Inicial"=3,
                "Prim Comp"=4,
                "Sec Comp"=5,
                "Tec Incomp or more"=6)

mydata <- ordinal_recode (variable="p6_1", break_points=break_edu, missing=999999, value_labels=labels_edu)

break_edu <- c(-98,-1,0,1,2,3,8)
labels_edu <- c("No se"=1,
                "Sin nivel"=2,
                "Inicial"=3,
                "Prim Comp"=4,
                "Sec Comp"=5,
                "Tec Incomp or more"=6)
mydata <- ordinal_recode (variable="p6_2", break_points=break_edu, missing=999999, value_labels=labels_edu)

break_edu <- c(-98,-1,0,1)
labels_edu <- c("No se"=1,
                "Sin nivel"=2,
                "Inicial"=3,
                "Prim Comp or more"=4)
mydata <- ordinal_recode (variable="p6b1", break_points=break_edu, missing=999999, value_labels=labels_edu)

break_edu <- c(-1,0)
labels_edu <- c("Sin nivel"=1,
                "Inicial or more"=2)
mydata <- ordinal_recode (variable="p6b2", break_points=break_edu, missing=999999, value_labels=labels_edu)

# Top code household composition variables with large and unusual numbers 

mydata <- top_recode ("p1", break_point=10, missing=c(888, 999999)) # Topcode cases with 10 or more adult household members. 
mydata <- top_recode ("p2c", break_point=5, missing=c(888, 999999)) # Topcode cases with 5 or more adult household members.
mydata <- top_recode ("p2d", break_point=2, missing=c(888, 999999)) # Topcode cases with 2 or more adult household members.
mydata <- top_recode ("p2e", break_point=1, missing=c(888, 999999)) # Topcode cases with 1 or more adult household members.
mydata <- top_recode ("p2f", break_point=2, missing=c(888, 999999)) # Topcode cases with 2 or more adult household members.
mydata <- top_recode ("p2g", break_point=3, missing=c(888, 999999)) # Topcode cases with 3 or more adult household members.

# Top code high income to the 99.5 percentile

percentile_99.5 <- floor(quantile(na.exclude(mydata$p42a)[na.exclude(mydata$p42a)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p42a", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7_1)[na.exclude(mydata$p7_1)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7_1", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7_2)[na.exclude(mydata$p7_2)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7_2", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7a1)[na.exclude(mydata$p7a1)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7a1", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7a2)[na.exclude(mydata$p7a2)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7a2", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7a3)[na.exclude(mydata$p7a3)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7a3", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7a4)[na.exclude(mydata$p7a4)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7a4", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$p7c1)[na.exclude(mydata$p7c1)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="p7c1", break_point=percentile_99.5, missing=-97)


#' #Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("i14",
                  "i15",
                  "dropout",
                  "p10_1",
                  "p42",
                  "p2a",
                  "p2b",
                  "p3a1",
                  "p3a2",
                  "p3a3",
                  "p3a4",
                  "p3a5",
                  "p3a6",
                  "p3a7",
                  "p3a8",
                  "p3a9",
                  "p3a10",
                  "p3b1",
                  "p3b2",
                  "p3b3",
                  "p3c1",
                  "p3c2",
                  "p3d1",
                  "p3d2",
                  "p3d3",
                  "p26a1",
                  "p26a2",
                  "p26a3",
                  "p26a4",
                  "p26a5",
                  "p26a6",
                  "p26a7",
                  "p26a8",
                  "p26a9",
                  "p26a10",
                  "p26c1",
                  "p26c2",
                  "p26d1",
                  "p26d2",
                  "p26d3",
                  "p4_1",
                  "p4_2",
                  "p4a1",
                  "p4a2",
                  "p4a3",
                  "p4a4",
                  "p4a5",
                  "p4a6",
                  "p4a7",
                  "p4a8",
                  "p4a9",
                  "p4a10",
                  "p4b1",
                  "p4b2",
                  "p4b3",
                  "p4c1",
                  "p4c2",
                  "p4d1",
                  "p4d2",
                  "p4d3",
                  "p5_a_1",
                  "p5_a_2",
                  "p5_aa1",
                  "p5_aa2",
                  "p5_aa3",
                  "p5_aa4",
                  "p5_aa5",
                  "p5_aa6",
                  "p5_aa7",
                  "p5_aa8",
                  "p5_aa9",
                  "p5_ab1",
                  "p5_ac1",
                  "p5_ac2",
                  "p5_ad1",
                  "p5_ad2",
                  "p23_1",
                  "p23_2",
                  "p23a1",
                  "p23a2",
                  "p23a3",
                  "p23a4",
                  "p23a5",
                  "p23a6",
                  "p23a7",
                  "p23a8",
                  "p23a9",
                  "p23b1",
                  "p23b2",
                  "p23b3",
                  "p23c1",
                  "p23c2",
                  "p23d1",
                  "p23d2",
                  "juntos_ben",
                  "juntos_year")

capture_tables (indirect_PII)

#Recode those with very specific values. 

break_activity <- c(1,2,3,4,5)
labels_activity <- c("Estudia"=1,
                     "Otros"=2,
                     "Trabajo remunerado"=3,
                     "Quehaceres del hogar o trabajo no remunerado"=4,
                     "Otros"=5)
mydata <- ordinal_recode (variable="p4_1", break_points=break_activity, missing=999999, value_labels=labels_activity)

break_activity <- c(1,2,3,4,5)
labels_activity <- c("Otros"=1,
                     "Otros"=2,
                     "Trabajo remunerado"=3,
                     "Quehaceres del hogar o trabajo no remunerado"=4,
                     "Otros"=5)
mydata <- ordinal_recode (variable="p4_2", break_points=break_activity, missing=999999, value_labels=labels_activity)

break_activity <- c(1,2,3,4,5)
labels_activity <- c("Otros"=1,
                     "Otros"=2,
                     "Otros"=3,
                     "Quehaceres del hogar o trabajo no remunerado"=4,
                     "Otros"=5)
mydata <- ordinal_recode (variable="p4b1", break_points=break_activity, missing=999999, value_labels=labels_activity)

break_activity <- c(1,2,3,4,5)
labels_activity <- c("Otros"=1,
                     "Otros"=2,
                     "Otros"=3,
                     "Otros"=4,
                     "Otros"=5)
mydata <- ordinal_recode (variable="p4c1", break_points=break_activity, missing=999999, value_labels=labels_activity)

break_activity <- c(1,2,3,4,5)
labels_activity <- c("Otros"=1,
                     "Otros"=2,
                     "Otros"=3,
                     "Otros"=4,
                     "Otros"=5)
mydata <- ordinal_recode (variable="p4b3", break_points=break_activity, missing=999999, value_labels=labels_activity)



break_activity <- c(1,2,3,4,5)
labels_activity <- c("Otros"=1,
                     "Otros"=2,
                     "Otros"=3,
                     "Otros"=4,
                     "Otros"=5)
mydata <- ordinal_recode (variable="p4c2", break_points=break_activity, missing=999999, value_labels=labels_activity)

break_activity <- c(1,2,3,4,5)
labels_activity <- c("Otros"=1,
                     "Otros"=2,
                     "Otros"=3,
                     "Otros"=4,
                     "Otros"=5)
mydata <- ordinal_recode (variable="p4d1", break_points=break_activity, missing=999999, value_labels=labels_activity)

#' #Matching and crosstabulations: Run automated PII check 

# Based on dictionary inspection, select variables for creating sdcMicro object
# See: https://sdcpractice.readthedocs.io/en/latest/anon_methods.html
# All variable names should correspond to the names in the data file
# selected categorical key variables: gender, occupation/education and age
selectedKeyVars = c('i14', 'age1') ##!!! Replace with candidate categorical demo vars

# weight variable (add if available)
# selectedWeightVar = c('projwt') ##!!! Replace with weight var

# household id variable (cluster)
# selectedHouseholdID = c('wpid') ##!!! Replace with household id

# creating the sdcMicro object with the assigned variables
sdcInitial <- createSdcObj(dat = mydata, keyVars = selectedKeyVars)
sdcInitial

#' #Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("dropout_reasons",
               "dropout_reasons_otro",
               "p15a",
               "p29a",
               "p44b",
               "p44c",
               "p51",
               "p51a",
               "p_h1",
               "p_h2",
               "p_h3",
               "p_h4",
               "p_h5",
               "p_h6",
               "p_h7",
               "p_h8",
               "p_h9",
               "p_h10",
               "p_h11",
               "p_h12",
               "p_a1",
               "p_a2",
               "p_a3",
               "p_a4",
               "p_t1",
               "p_t2",
               "p_t3",
               "p_t4",
               "p_t5",
               "p_t6",
               "p_t7",
               "p_t8",
               "p_t9",
               "p_t10",
               "p_t11",
               "p_t12",
               "p_s1",
               "p_s2",
               "p_s3",
               "p_s4",
               "p_s5",
               "p_s6",
               "p_s7",
               "p_s8",
               "p_s9",
               "p_s10",
               "p_s11",
               "p_s12",
               "text_geo")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 
# !!! Remove, as they contain a lot of sensitive information and they are in Spanish.

mydata <- mydata[!names(mydata) %in% "dropout_reasons"]
mydata <- mydata[!names(mydata) %in% "dropout_reasons_otro"]
mydata <- mydata[!names(mydata) %in% "p15a"]
mydata <- mydata[!names(mydata) %in% "p29a"]
mydata <- mydata[!names(mydata) %in% "p44b"]
mydata <- mydata[!names(mydata) %in% "p44c"]
mydata <- mydata[!names(mydata) %in% "p51"]
mydata <- mydata[!names(mydata) %in% "p51a"]
mydata <- mydata[!names(mydata) %in% "p_h1"]
mydata <- mydata[!names(mydata) %in% "p_h2"]
mydata <- mydata[!names(mydata) %in% "p_h3"]
mydata <- mydata[!names(mydata) %in% "p_h4"]
mydata <- mydata[!names(mydata) %in% "p_h5"]
mydata <- mydata[!names(mydata) %in% "p_h6"]
mydata <- mydata[!names(mydata) %in% "p_h7"]
mydata <- mydata[!names(mydata) %in% "p_h8"]
mydata <- mydata[!names(mydata) %in% "p_h9"]
mydata <- mydata[!names(mydata) %in% "p_h10"]
mydata <- mydata[!names(mydata) %in% "p_h11"]
mydata <- mydata[!names(mydata) %in% "p_h12"]
mydata <- mydata[!names(mydata) %in% "p_a1"]
mydata <- mydata[!names(mydata) %in% "p_a2"]
mydata <- mydata[!names(mydata) %in% "p_a3"]
mydata <- mydata[!names(mydata) %in% "p_a4"]
mydata <- mydata[!names(mydata) %in% "p_t1"]
mydata <- mydata[!names(mydata) %in% "p_t2"]
mydata <- mydata[!names(mydata) %in% "p_t3"]
mydata <- mydata[!names(mydata) %in% "p_t4"]
mydata <- mydata[!names(mydata) %in% "p_t5"]
mydata <- mydata[!names(mydata) %in% "p_t6"]
mydata <- mydata[!names(mydata) %in% "p_t7"]
mydata <- mydata[!names(mydata) %in% "p_t8"]
mydata <- mydata[!names(mydata) %in% "p_t9"]
mydata <- mydata[!names(mydata) %in% "p_t10"]
mydata <- mydata[!names(mydata) %in% "p_t11"]
mydata <- mydata[!names(mydata) %in% "p_t12"]
mydata <- mydata[!names(mydata) %in% "p_s1"]
mydata <- mydata[!names(mydata) %in% "p_s2"]
mydata <- mydata[!names(mydata) %in% "p_s3"]
mydata <- mydata[!names(mydata) %in% "p_s4"]
mydata <- mydata[!names(mydata) %in% "p_s5"]
mydata <- mydata[!names(mydata) %in% "p_s6"]
mydata <- mydata[!names(mydata) %in% "p_s7"]
mydata <- mydata[!names(mydata) %in% "p_s8"]
mydata <- mydata[!names(mydata) %in% "p_s9"]
mydata <- mydata[!names(mydata) %in% "p_s10"]
mydata <- mydata[!names(mydata) %in% "p_s11"]
mydata <- mydata[!names(mydata) %in% "p_s12"]
mydata <- mydata[!names(mydata) %in% "text_geo"]


#' #GPS data: Displace
# Setup map

countrymap <- map_data("world") %>% filter(region=="Peru")  #!!! Select correct country
admin <- raster::getData("GADM", country="PE", level=0) #!!! Select correct country map using standard 2-letter country codes: https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2

# Displace all pairs of GPS variables (Longitude, Latitude). Check summary statistics and maps before and after displacement. 

gps.vars <- c("geo_pointslongitude", "geo_pointslatitude") # !!!Include relevant variables, always longitude first, latitude second.
mydata <- displace(gps.vars, admin=admin, samp_num=1, other_num=100000) # May take a few minutes to process.

# !!! Remove altitude data

mydata <- mydata[!names(mydata) %in% "geo_pointsaltitude"]

#' #Save processed data in Stata and SPSS format
#' Adds "_PU" (Public Use) to the end of the name 

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
#'