/* This SAS program was automatically generated by Stat/Transfer */

/* The following line should contain the complete path and name of your raw data file */
FILENAME datafile 'PATH_NAME\pud_wia.dat' ;

/* The following line should contain the directory in which you wish your SAS file to be stored */
libname library 'PATH_NAME' ;

/* The following line contains the name (without the extension) for your SAS dataset */
%LET dataset = pud_wia ;

proc format library = library ;
   value YNF
      0 = 'No'  
      1 = 'Yes' ;
   value GENDERF
      1 = 'Male'  
      2 = 'Female' ;
   value RACEF
      1 = 'White only'  
      2 = 'Black (including black and any other racial category)'  
      3 = 'Other (any other specified racial category)'  
      4 = 'No racial category identified' ;

quit;
DATA library.&dataset ;
INFILE datafile LRECL=52;
INPUT
   ID  1-8                  REG_YR  9-12             REG_MT  13-14         
   EXIT_YR  15-18           EXIT_MT  19-20           ADULT_L  21           
   DISWRK_L  22             INT_YR  23-26            INT_MT  27-28         
   TRN_YR  29-32            TRN_MT  33-34            DIS_YR  35-38         
   DIS_MT  39-40            AGE  41-45               GENDER  46            
   RACE  47                 HISPANIC  48             YEARSED  49-50        
   DISABLE  51              VET  52                ;                       

LABEL
   ID = "Individual Identifier"
   REG_YR = "Date of Program Participation: year"
   REG_MT = "Date of Program Participation: month"
   EXIT_YR = "Date of Exit: year"
   EXIT_MT = "Date of Exit: month"
   ADULT_L = "Adult (local formula)"
   DISWRK_L = "Dislocated Worker (local formula)"
   INT_YR = "Date of First Intensive Service: year"
   INT_MT = "Date of First Intensive Service: month"
   TRN_YR = "Date Entered Training: year"
   TRN_MT = "Date Entered Training: month"
   DIS_YR = "Date of Actual Qualifying Dislocation: year"
   DIS_MT = "Date of Actual Qualifying Dislocation: month"
   AGE = "Age at event"
   GENDER = "Gender"
   RACE = "Race"
   HISPANIC = "Ethnicity Hispanic/Latino"
   YEARSED = "# of years of education"
   DISABLE = "Individual with a Disability"
   VET = "Eligible Veteran Status" ;

FORMAT
   ADULT_L YNF.             DISWRK_L YNF.            GENDER GENDERF.       
   RACE RACEF.              HISPANIC YNF.            DISABLE YNF.          
   VET YNF. ;
          

LENGTH
   ID 6                     REG_YR 4                 REG_MT 3              
   EXIT_YR 4                EXIT_MT 3                ADULT_L 3             
   DISWRK_L 3               INT_YR 4                 INT_MT 3              
   TRN_YR 4                 TRN_MT 3                 DIS_YR 4              
   DIS_MT 3                 GENDER 3                 RACE 3                
   HISPANIC 3               YEARSED 3                DISABLE 3             
   VET 3 ;

           

RUN ;
