/* This SAS program was automatically generated by Stat/Transfer */

/* The following line should contain the complete path and name of your raw data file */
FILENAME datafile 'PATH_NAME\pud_ui.dat' ;

/* The following line should contain the directory in which you wish your SAS file to be stored */
libname library 'PATH_NAME' ;

/* The following line contains the name (without the extension) for your SAS dataset */
%LET dataset = pud_ui ;

proc format library = library ;
   value GENDERF
      1 = 'Male'  
      2 = 'Female' ;
   value RACEF
      1 = 'White only'  
      2 = 'Black (including black and any other racial category)'  
      3 = 'Other (any other specified racial category)'  
      4 = 'No racial category identified' ;
   value YNF
      0 = 'No'  
      1 = 'Yes' ;

quit;
DATA library.&dataset ;
INFILE datafile LRECL=43;
INPUT
   ID  1-8                  UIREG_YR  9-12           UIREG_MT  13-14       
   PAID_LST_YR  15-18       PAID_LST_MT  19-20       LSTJOB_END_YR  21-24  
   LSTJOB_END_MT  25-26     PAID_AMOUNT  27-31       AGE  32-36            
   GENDER  37               RACE  38                 HISPANIC  39          
   YEARSED  40-41           DISABLE  42              VET  43               
 ;                       

LABEL
   ID = "Individual Identifier"
   UIREG_YR = "Date filed UI claim: year"
   UIREG_MT = "Date filed UI claim: month"
   PAID_LST_YR = "Last Date of Payments: year"
   PAID_LST_MT = "Last Date of Payments: month"
   LSTJOB_END_YR = "End Date of Prior Job: year"
   LSTJOB_END_MT = "End Date of Prior Job: month"
   PAID_AMOUNT = "Sum of Payments Under Claim"
   AGE = "Age at event"
   GENDER = "Gender"
   RACE = "Race"
   HISPANIC = "Ethnicity Hispanic/Latino"
   YEARSED = "# of years of education"
   DISABLE = "Individual with a Disability"
   VET = "Eligible Veteran Status" ;

FORMAT
   GENDER GENDERF.          RACE RACEF.              HISPANIC YNF.         
   DISABLE YNF.             VET YNF. ;
          

LENGTH
   ID 6                     UIREG_YR 4               UIREG_MT 3            
   PAID_LST_YR 4            PAID_LST_MT 3            LSTJOB_END_YR 4       
   LSTJOB_END_MT 3          PAID_AMOUNT 6            GENDER 3              
   RACE 3                   HISPANIC 3               YEARSED 3             
   DISABLE 3                VET 3 ;

           

RUN ;
