USE master
GO

-- Restore Seed to temp DBs
RESTORE FILELISTONLY 
   FROM DISK = 'c:\Program Files\DRVS\WIAnLX\Bin\DBBackups\WIADB.BAK'
RESTORE DATABASE CITIWIADB
   FROM DISK = 'c:\Program Files\DRVS\WIAnLX\Bin\DBBackups\WIADB.BAK'
   with replace,
   MOVE 'WIADB_Data' TO 'c:\Program Files\DRVS\User Data\WIA\Data\CITIWIADB_Data.mdf',
   MOVE 'WIADB_log' TO 'c:\Program Files\DRVS\User Data\WIA\Log\CITIWIADB_Log.ldf'
GO

RESTORE FILELISTONLY 
   FROM DISK = 'c:\Program Files\DRVS\WIAnLX\Bin\DBBackups\WIATempDB.BAK'
RESTORE DATABASE CITIWIATempDB
   FROM DISK = 'c:\Program Files\DRVS\WIAnLX\Bin\DBBackups\WIATempDB.BAK'
   with replace,
   MOVE 'WIATempDB_Data' TO 'c:\Program Files\DRVS\User Data\WIA\Data\CITIWIATempDB_Data.mdf',
   MOVE 'WIATempDB_log' TO 'c:\Program Files\DRVS\User Data\WIA\Log\CITIWIATempDB_Log.ldf'
GO

RESTORE FILELISTONLY 
   FROM DISK = 'c:\Program Files\DRVS\WIAnLX\Bin\DBBackups\LXDB.BAK'
RESTORE DATABASE CITILXDB
   FROM DISK = 'c:\Program Files\DRVS\WIAnLX\Bin\DBBackups\LXDB.BAK'
   with replace,
   MOVE 'LXDB_Data' TO 'c:\Program Files\DRVS\User Data\WIA\Data\CITILXDB_Data.mdf',
   MOVE 'LXDB_log' TO 'c:\Program Files\DRVS\User Data\WIA\Log\CITILXDB_Log.ldf'
GO

RESTORE FILELISTONLY 
   FROM DISK = 'c:\Program Files\DRVS\WIAnLX\Bin\DBBackups\LXTempDB.BAK'
RESTORE DATABASE CITILXTempDB
   FROM DISK = 'c:\Program Files\DRVS\WIAnLX\Bin\DBBackups\LXTempDB.BAK'
   with replace,
   MOVE 'LXTempDB_Data' TO 'c:\Program Files\DRVS\User Data\WIA\Data\CITILXTempDB_Data.mdf',
   MOVE 'LXTempDB_log' TO 'c:\Program Files\DRVS\User Data\WIA\Log\CITILXTempDB_Log.ldf'
GO

-- Fix temp DB DRVSUser SID
declare @psNewName varchar(20)
declare @psPassword varchar(10)
declare @sSQLExecString varchar(300), @sDatabaseName varchar(50)
declare @tblDBList table (dummyid int identity(1,1), dbname varchar(30))
declare @dummyid int

set @psNewName = 'DRVSUser'
set @psPassword = 'DRVSUser'

insert @tblDBList (dbname) values ('CITIWIADB')
insert @tblDBList (dbname) values ('CITIWIATempDB')
insert @tblDBList (dbname) values ('CITILXDB')
insert @tblDBList (dbname) values ('CITILXTempDB')

exec sp_configure 'allow updates', '1'
reconfigure with override

-- for each database need to add the user and assign the associated permissions
-- if the user already exists in the current database then just assign the permissions
set @dummyid = 0

while exists (select 'c' from @tblDBList where dummyid > @dummyid)
    begin
        -- use the database to add the user
		select top 1 @sSQLExecString = 'update ' + dbname + '..sysusers
						set sid = sl.sid
						from syslogins sl
						where sl.name = ' + dbname + '..sysusers.name
						  and sl.sid <> ' + dbname + '..sysusers.sid'
				, @sDatabaseName = dbname, @dummyid = dummyid
		from @tblDBList tDL
		where tDL.dummyid > @dummyid
		order by dummyid asc


		exec (@sSQLExecString)
    end 

exec sp_configure 'allow updates', '0'
reconfigure with override
GO

--Replace seed
BACKUP DATABASE CITIWIADB TO DISK = 'c:\Program Files\DRVS\WIAnLX\Bin\DBBackups\WIADB.BAK' WITH INIT, SKIP 
BACKUP DATABASE CITIWIATempDB TO DISK = 'c:\Program Files\DRVS\WIAnLX\Bin\DBBackups\WIATempDB.BAK' WITH INIT, SKIP 
BACKUP DATABASE CITILXDB TO DISK = 'c:\Program Files\DRVS\WIAnLX\Bin\DBBackups\LXDB.BAK' WITH INIT, SKIP 
BACKUP DATABASE CITILXTempDB TO DISK = 'c:\Program Files\DRVS\WIAnLX\Bin\DBBackups\LXTempDB.BAK' WITH INIT, SKIP 
GO

--Remove temp DBs
DROP DATABASE CITIWIADB
DROP DATABASE CITIWIATempDB
DROP DATABASE CITILXDB
DROP DATABASE CITILXTempDB
GO
