USE WIALXSystem 

GO

----------------------------------------------------

----------------309 valid value updates -----------
----------------------------------------------------

UPDATE Code SET CodeName = 'Primarily Statewide 15% funds' WHERE CodeGroup = 'IncumbentWorker' AND CodeAbbrv ='1'
UPDATE Code SET CodeName = 'Primarily Local Formula (waiver) funds' WHERE CodeGroup = 'IncumbentWorker' AND CodeAbbrv ='2'


	IF NOT EXISTS( SELECT 'c' 
					 FROM  CODE
					WHERE CodeGroup  = 'IncumbentWorker'
					  and CodeAbbrv  = '3'
				 )
		BEGIN
			DECLARE @incumworker3 int
			INSERT INTO code 
				   ( CodeGroup     , CodeAbbrv , CodeName  , ColumnName , SortOrder , LastModifiedDate )
			VALUES ( 'IncumbentWorker' , '3'  , 'Primarily Rapid Response (waiver) funds' , 'NULL'     , 1000 , getdate() )
		
			 SET @incumworker3 = @@identity
	      
			 UPDATE Code SET SortOrder = @incumworker3 WHERE CodeName = 'Primarily Rapid Response (waiver) funds' AND  CodeGroup = 'IncumbentWorker' AND CodeAbbrv ='3'

		END
	IF NOT EXISTS( SELECT 'c' 
					 FROM  CODE
					WHERE CodeGroup  = 'IncumbentWorker'
					  and CodeAbbrv  = '0'
				 )
		BEGIN
			DECLARE @incumworker0 int
			INSERT INTO code 
				   ( CodeGroup     , CodeAbbrv , CodeName  , ColumnName , SortOrder , LastModifiedDate )
			VALUES ( 'IncumbentWorker' , '0'  , 'no serviced received' , 'NULL'     , 1001 , getdate() )
		 
			SET @incumworker0 = @@identity
	      
			 UPDATE Code SET SortOrder = @incumworker0 WHERE CodeName = 'no serviced received' AND  CodeGroup = 'IncumbentWorker' AND CodeAbbrv ='0'

		END



-----------------------------------------

DELETE FROM ErrorCheckXFileRecordLayoutElement
WHERE 
ErrorCheckXFileRecordLayoutElementID 
IN (
SELECT ECFRLE.ErrorCheckXFileRecordLayoutElementID
FROM ErrorCheckXFileRecordLayoutElement ECFRLE

INNER JOIN FileRecordLayoutElement FRLE
ON ECFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID

INNER JOIN FileRecordLayout FRL
ON FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID

INNER JOIN Code c
on FRL.SystemID = c.CodeID and c.CodeAbbrv ='WIA'

INNER JOIN Code c1
ON FRL.ProgramYearID = c1.CodeID and c1.CodeAbbrv='PY2009'

INNER JOIN ErrorCheck EC 
ON ECFRLE.ErrorCheckID = EC.ErrorCheckID AND EC.ErrorAbbrv = 'MANDATORY'

WHERE 
FRLE.ColumnName='IWStatewide15Percent' 
AND FRLE.CodeGroup ='IncumbentWorker')


----------------------------------------------

-------------604/605 Updates -----------------
USE WIALXSystem
GO

DELETE FROM ErrorCheckXFileRecordLayoutElement
WHERE 
ErrorCheckXFileRecordLayoutElementID 
IN (
SELECT ECFRLE.ErrorCheckXFileRecordLayoutElementID
FROM ErrorCheckXFileRecordLayoutElement ECFRLE

INNER JOIN FileRecordLayoutElement FRLE
ON ECFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID

INNER JOIN FileRecordLayout FRL
ON FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID

INNER JOIN Code c
on FRL.SystemID = c.CodeID and c.CodeAbbrv ='WIA' AND  c.CodeGroup='System'

INNER JOIN Code c1
ON FRL.ProgramYearID = c1.CodeID and c1.CodeAbbrv='PY2009' AND  c1.CodeGroup='ProgramYear'

INNER JOIN ErrorCheck EC 
ON ECFRLE.ErrorCheckID = EC.ErrorCheckID AND EC.ErrorAbbrv = 'YNGYTHZEROBLANK'

WHERE 
FRLE.ColumnName='NonTraditionalEmployment')


----------------------------

DECLARE @FRLEID604 INT
DECLARE @FRLEID604T INT
DECLARE @FRLEID605 INT
DECLARE @FRLEID605T INT
DECLARE @FRLID604 INT
DECLARE @FRLID604T INT
DECLARE @FRLID605 INT
DECLARE @FRLID605T INT
DECLARE @warntrainempcid INT
DECLARE @warnnontradbid INT

--604
SELECT @FRLEID604= FRLE.FileRecordLayoutElementID, @FRLID604=FRLE.FileRecordLayoutID

FROM FileRecordLayoutElement FRLE

INNER JOIN FileRecordLayout FRL

ON FRLE.FileRecordLayoutID =FRL.FileRecordLayoutID

INNER JOIN Code c
on FRL.SystemID = c.CodeID and c.CodeAbbrv ='WIA' AND  c.CodeGroup='System'

INNER JOIN Code c1
ON FRL.ProgramYearID = c1.CodeID and c1.CodeAbbrv='PY2009' AND  c1.CodeGroup='ProgramYear'

INNER JOIN Code c2
ON FRL.FileRecordLayoutTypeID = c2.CodeID and c2.CodeAbbrv='DET' AND c2.CodeGroup='FileRecordLayoutType'
WHERE FRLE.ColumnName = 'EmploymentTraining'




--605
SELECT @FRLEID605=FRLE.FileRecordLayoutElementID, @FRLID605=FRLE.FileRecordLayoutID

FROM FileRecordLayoutElement FRLE

INNER JOIN FileRecordLayout FRL

ON FRLE.FileRecordLayoutID =FRL.FileRecordLayoutID

INNER JOIN Code c
on FRL.SystemID = c.CodeID and c.CodeAbbrv ='WIA' AND  c.CodeGroup='System'

INNER JOIN Code c1
ON FRL.ProgramYearID = c1.CodeID and c1.CodeAbbrv='PY2009' AND  c1.CodeGroup='ProgramYear'

INNER JOIN Code c2
ON FRL.FileRecordLayoutTypeID = c2.CodeID and c2.CodeAbbrv='DET' AND c2.CodeGroup='FileRecordLayoutType'
WHERE FRLE.ColumnName = 'NonTraditionalEmployment'

---------------------------------------
--604 Table O

SELECT @FRLEID604T=FRLE.FileRecordLayoutElementID, @FRLID604T=FRLE.FileRecordLayoutID

FROM FileRecordLayoutElement FRLE

INNER JOIN FileRecordLayout FRL

ON FRLE.FileRecordLayoutID =FRL.FileRecordLayoutID

INNER JOIN Code c
on FRL.SystemID = c.CodeID and c.CodeAbbrv ='WIA' AND  c.CodeGroup='System'

INNER JOIN Code c1
ON FRL.ProgramYearID = c1.CodeID and c1.CodeAbbrv='PY2009' AND  c1.CodeGroup='ProgramYear'

INNER JOIN Code c2
ON FRL.FileRecordLayoutTypeID = c2.CodeID and c2.CodeAbbrv='TABLEODET' AND c2.CodeGroup='FileRecordLayoutType'
WHERE FRLE.ColumnName = 'EmploymentTraining'


--605 Table O

SELECT @FRLEID605T=FRLE.FileRecordLayoutElementID,@FRLID605T= FRLE.FileRecordLayoutID

FROM FileRecordLayoutElement FRLE

INNER JOIN FileRecordLayout FRL

ON FRLE.FileRecordLayoutID =FRL.FileRecordLayoutID

INNER JOIN Code c
on FRL.SystemID = c.CodeID and c.CodeAbbrv ='WIA' AND  c.CodeGroup='System'

INNER JOIN Code c1
ON FRL.ProgramYearID = c1.CodeID and c1.CodeAbbrv='PY2009' AND  c1.CodeGroup='ProgramYear'

INNER JOIN Code c2
ON FRL.FileRecordLayoutTypeID = c2.CodeID and c2.CodeAbbrv='TABLEODET' AND c2.CodeGroup='FileRecordLayoutType'
WHERE FRLE.ColumnName = 'NonTraditionalEmployment'

---Begin Process





IF NOT EXISTS( SELECT 'c' 
					 FROM  ErrorCheck
					WHERE ErrorAbbrv = 'WARNTRAINEMPC' 
				 )
		BEGIN
			
			INSERT INTO ErrorCheck
				   ( ErrorAbbrv , ErrorTypeID , FundingStreamID  , ErrorDisplayName , ErrorSQL , LastModifiedDate )
			VALUES ( 'WARNTRAINEMPC' , 748  , NULL , 'C. If participant has not exited, then Entered Training Related Employment cannot be 1 or 2.' , NULL , GETDATE() )
		
			 SET @warntrainempcid = @@identity
      	   
		END
 ELSE
        BEGIN
           SELECT @warntrainempcid = ErrorCheckID
                  FROM  ErrorCheck
					WHERE ErrorAbbrv = 'WARNTRAINEMPC' 
        END

IF NOT EXISTS ( SELECT 'c' 
                    FROM ErrorCheckXFileRecordLayoutElement
                    WHERE 
                     ErrorCheckID = @warntrainempcid AND
                     FileRecordLayoutID = @FRLID604 AND
                     FileRecordLayoutElementID = @FRLEID604)
             BEGIN
               INSERT INTO [ErrorCheckXFileRecordLayoutElement]
						   ([ErrorCheckID]
						   ,[FileRecordLayoutID]
						   ,[FileRecordLayoutElementID]
						   ,[PostingDate])
					 VALUES
						   (@warntrainempcid
						   ,@FRLID604
						   ,@FRLEID604
						   ,GETDATE())
              END

IF NOT EXISTS( SELECT 'c' 
					 FROM  ErrorCheck
					WHERE ErrorAbbrv = 'WARNNONTRADB' 
				 )
		BEGIN
			
			INSERT INTO ErrorCheck
				   ( ErrorAbbrv , ErrorTypeID , FundingStreamID  , ErrorDisplayName , ErrorSQL , LastModifiedDate )
			VALUES ( 'WARNNONTRADB' , 748  , NULL , 'B. If participant has not exited, then Entered non-Traditional Employment cannot be 1 or 2.' ,NULL , GETDATE() )
		
			 SET @warnnontradbid = @@identity
      	   
		END
 ELSE
        BEGIN
           SELECT @warnnontradbid = ErrorCheckID
                  FROM  ErrorCheck
					WHERE ErrorAbbrv = 'WARNNONTRADB' 
        END

IF NOT EXISTS ( SELECT 'c' 
                    FROM ErrorCheckXFileRecordLayoutElement
                    WHERE 
                     ErrorCheckID = @warnnontradbid AND
                     FileRecordLayoutID = @FRLID605 AND
                     FileRecordLayoutElementID = @FRLEID605)
             BEGIN
               INSERT INTO [ErrorCheckXFileRecordLayoutElement]
						   ([ErrorCheckID]
						   ,[FileRecordLayoutID]
						   ,[FileRecordLayoutElementID]
						   ,[PostingDate])
					 VALUES
						   (@warnnontradbid
						   ,@FRLID605
						   ,@FRLEID605
						   ,GETDATE())
              END

IF NOT EXISTS ( SELECT 'c' 
                    FROM ErrorCheckXFileRecordLayoutElement
                    WHERE 
                     ErrorCheckID = @warntrainempcid AND
                     FileRecordLayoutID = @FRLID604T AND
                     FileRecordLayoutElementID = @FRLEID604T)
             BEGIN
               INSERT INTO [ErrorCheckXFileRecordLayoutElement]
						   ([ErrorCheckID]
						   ,[FileRecordLayoutID]
						   ,[FileRecordLayoutElementID]
						   ,[PostingDate])
					 VALUES
						   (@warntrainempcid
						   ,@FRLID604T
						   ,@FRLEID604T
						   ,GETDATE())
              END

IF NOT EXISTS ( SELECT 'c' 
                    FROM ErrorCheckXFileRecordLayoutElement
                    WHERE 
                     ErrorCheckID = @warnnontradbid AND
                     FileRecordLayoutID = @FRLID605T AND
                     FileRecordLayoutElementID = @FRLEID605T)
             BEGIN
               INSERT INTO [ErrorCheckXFileRecordLayoutElement]
						   ([ErrorCheckID]
						   ,[FileRecordLayoutID]
						   ,[FileRecordLayoutElementID]
						   ,[PostingDate])
					 VALUES
						   (@warnnontradbid
						   ,@FRLID605T
						   ,@FRLEID605T
						   ,GETDATE())
              END





-------------------------------------------------

-----------------349 Updates --------------------

UPDATE ErrorCheck SET ErrorDisplayName ='The value for Received Follow-up Services must be 1 or 2 for a Youth who exited more 12 months ago.', LastModifiedDate =GETDATE() 
       WHERE ErrorAbbrv='FOLLOWUPSVC'


--------------------------------------------------

------------Update Contact Information -----------

USE WIAnLXData
GO
UPDATE  TechnicalContactInfo
SET ContactInfo1 ='For questions regarding WIA data files, reports, or validation, email CDS2 at DRVS@cds2.com. Provide the version of the application (see Help/About for the Version Number), specific question, and contact information.',
    EmailLink='DRVS@cds2.com',
    VersionNumber='7.3',
    LastModifiedDate= '2010-09-01'

WHERE TechnicalContactID=1 AND ApplicationID=1

UPDATE  TechnicalContactInfo
SET ContactInfo1 ='For questions regarding ES data files, reports, or validation, email CDS2 at DRVS@cds2.com. Provide the version of the application (see Help/About for the Version Number), specific question, and contact information.',
    EmailLink='DRVS@cds2.com',
    VersionNumber='7.3',
    LastModifiedDate= '2010-09-01'

WHERE TechnicalContactID=2 AND ApplicationID=2

--------------------------------------------------------

-------------------Update WIA Warning Check ------------

USE WIADB

GO

set ANSI_NULLS ON
set QUOTED_IDENTIFIER ON
go



--spWIARunWarningCheck 1,1,''

ALTER                  procedure [dbo].[spWIARunWarningCheck]
    @pnUserID		int,
    @pnApplicationID 	int,
    @pbContinue		bit	OUTPUT
as
BEGIN
SET ANSI_NULLS OFF

declare @sReportQuarter varchar(5)
declare @sProgramYear varchar(4)
declare @nSystemID int
declare @nProgramYearID int
declare @nMaxWarnings int
declare @nTotalWarnings int
declare @nCurrentErrorsLeft int 
declare @litNumStartDate datetime -- 156 - 701

set @nTotalWarnings = 0

select @sReportQuarter = RQ.ReportQuarterDueDate,
       @sProgramYear = substring(C.CodeAbbrv,3,4),
       @nProgramYearID = URO.ProgramYearID,
       @litNumStartDate = litNumStartDate -- 156 - 701
from ReportQuarter RQ
inner join UserReportingOptions URO
on RQ.ReportQuarterID = case isNull(URO.ReportQtrDueID,0)
			  when 0 then 4
			  else URO.ReportQtrDueID
			end
inner join Code C 
on C.CodeID = URO.ProgramYearID
where URO.UserID = @pnUserID
  and URO.ApplicationID = @pnApplicationID

select @nSystemID = C.CodeID
from Code C where CodeGroup = 'System' and CodeAbbrv = 'WIA'

select @nMaxWarnings = cast(C.CodeName as int)
from Code C where CodeGroup = 'ErrorWarningParm' and CodeAbbrv = 'MaxWarnings'

declare @SQLString varchar(8000)
declare @nLoopControlID int, @nErrorCheckLoopID int
declare @ErrorCheckAbbrv varchar(50)

declare @tblColumns table
   (dummyid    int identity(1,1) not null,
    FileRecordLayoutElementID int not null,
    CodeGroup varchar(100) null,
    ColumnName varchar(200) not null)

create table #tmpErrorRecords (RecordID int)

insert #tmpErrorRecords (RecordID)
select RxEC.RecordID
from RecordxErrorCheck RxEC
group by RxEC.RecordID

	-- Create a table of funding streams by record id
	create table #tmpRecordxFundingStream
	(RecordxFundingStreamID int identity(1,1) not null,
	 RecordID int not null,
	 FundingStreamID int not null,
	 ServiceTypeID int null,
	 CoreSerivceOnlyIndicator bit null)

	create index idxRecordID on #tmpRecordxFundingStream(RecordID)

	-- insert the Adults
	insert #tmpRecordxFundingStream
	(RecordID,FundingStreamID, ServiceTypeID, CoreSerivceOnlyIndicator)
	select tFA.RecordID, CA.CodeID, CS.CodeID,
		case 
		     when (rtrim(ltrim(isNull(CoreSelfServices,''))) = '1' or
			len(rtrim(ltrim(isNull(FirstCoreServiceDate,'')))) > 0)
		       and len(rtrim(ltrim(isNull(tFA.FirstIntensiveService,'')))) = 0
		       and len(rtrim(ltrim(isNull(tFA.DateEnterTraining, '')))) = 0 
		       and rtrim(ltrim(isNull(tFA.TrainingService1, '0'))) = '0' then 1
		     else 0
		end 
	from Code CA
	inner join tmpFileUpload_WIA tFA
	on tFA.AdultLocal = '1' or tFA.AdultStatewide15Percent = '1'
	inner join Code CS
	on case 
	     when len(rtrim(ltrim(isNull(tFA.FirstIntensiveService, '')))) > 0 
			or len(rtrim(ltrim(isNull(tFA.DateEnterTraining, '')))) > 0 then 'INTENSETRAIN'
	     when len(rtrim(ltrim(isNull(tFA.FirstIntensiveService, '')))) = 0
			and len(rtrim(ltrim(isNull(tFA.DateEnterTraining, '')))) = 0 then 'CORE'
	     else ''
	   end = CS.CodeAbbrv
	and CS.CodeGroup = 'ServiceType'
	where CA.CodeGroup = 'FundingStreamType' and CA.CodeAbbrv = 'Adult'
	  and not exists (select 'c' from RecordXErrorCheck RxEC
			  inner join ErrorCheck EC
			  on EC.ErrorAbbrv = 'FUNDSTREAM'
	 		  where RxEC.RecordID = tFA.RecordID
			    and RxEC.ErrorCheckID = 2)
	
	insert #tmpRecordxFundingStream
	(RecordID,FundingStreamID,ServiceTypeID, CoreSerivceOnlyIndicator)
	select tFA.RecordID, CA.CodeID, CS.CodeID,
		case 
		     when (rtrim(ltrim(isNull(CoreSelfServices,''))) = '1' or
			len(rtrim(ltrim(isNull(FirstCoreServiceDate,'')))) > 0)
		       and len(rtrim(ltrim(isNull(tFA.FirstIntensiveService,'')))) = 0
		       and len(rtrim(ltrim(isNull(tFA.DateEnterTraining, '')))) = 0 
		       and rtrim(ltrim(isNull(tFA.TrainingService1, '0'))) = '0' then 1
		     else 0
		end 
	from Code CA
	inner join tmpFileUpload_WIA tFA
	on tFA.DWLocal = '1' or tFA.DWStatewide15Percent = '1' 
	or tFA.AddRapidResponse = '1'
	inner join Code CS
	on case 
	     when len(rtrim(ltrim(isNull(tFA.FirstIntensiveService, '')))) > 0 
			or len(rtrim(ltrim(isNull(tFA.DateEnterTraining, '')))) > 0 then 'INTENSETRAIN'
	     when len(rtrim(ltrim(isNull(tFA.FirstIntensiveService, '')))) = 0
			or len(rtrim(ltrim(isNull(tFA.DateEnterTraining, '')))) = 0 then 'CORE'
	     else ''
	   end = CS.CodeAbbrv
	and CS.CodeGroup = 'ServiceType'
	where CA.CodeGroup = 'FundingStreamType' and CA.CodeAbbrv = 'DW'
	  and not exists (select 'c' from RecordXErrorCheck RxEC
			  inner join ErrorCheck EC
			  on EC.ErrorAbbrv = 'FUNDSTREAM'
	 		  where RxEC.RecordID = tFA.RecordID
			    and RxEC.ErrorCheckID = 2)

	insert #tmpRecordxFundingStream
	(RecordID,FundingStreamID,ServiceTypeID, CoreSerivceOnlyIndicator)
	select tFA.RecordID, CA.CodeID, CS.CodeID,
		case 
		     when (rtrim(ltrim(isNull(CoreSelfServices,''))) = '1' or
			len(rtrim(ltrim(isNull(FirstCoreServiceDate,'')))) > 0)
		       and len(rtrim(ltrim(isNull(tFA.FirstIntensiveService,'')))) = 0
		       and len(rtrim(ltrim(isNull(tFA.DateEnterTraining, '')))) = 0 
		       and rtrim(ltrim(isNull(tFA.TrainingService1, '0'))) = '0' then 1
		     else 0
		end 
	from Code CA
	inner join tmpFileUpload_WIA tFA
	on ( isNull(rtrim(ltrim(tFA.NEGProject1)),'0000') <> '0000' 
	  or isNull(rtrim(ltrim(tFA.NEGProject2)),'0000') <> '0000'
	  or isNull(rtrim(ltrim(tFA.NEGProject3)),'0000') <> '0000' 
		)
	and (len(isNull(rtrim(ltrim(tFA.NEGProject1)),'')) +
		len(isNull(rtrim(ltrim(tFA.NEGProject2)),'')) +
		len(isNull(rtrim(ltrim(tFA.NEGProject3)),'')) > 0)
        and (len(isNull(rtrim(ltrim(FirstCoreServiceDate)),'')) > 0 
	  or len(isNull(rtrim(ltrim(FirstIntensiveService)),'')) > 0 
	  or (len(isNull(rtrim(ltrim(DateEnterTraining)),'')) > 0  
	 and TrainingService1 > '0') )
	inner join Code CS
	on case 
	     when (len(isNull(rtrim(ltrim(FirstCoreServiceDate)),'')) > 0 
		  or len(isNull(rtrim(ltrim(FirstIntensiveService)),'')) > 0 
		  or (len(isNull(rtrim(ltrim(DateEnterTraining)),'')) > 0  
		 and TrainingService1 > '0') ) then 'SELFSERV'
	     else 'NOTSELFSERV'
	   end = CS.CodeAbbrv
	and CS.CodeGroup = 'ServiceType'
	where CA.CodeGroup = 'FundingStreamType' and CA.CodeAbbrv = 'NEG'
	  and not exists (select 'c' from RecordXErrorCheck RxEC
			  inner join ErrorCheck EC
			  on EC.ErrorAbbrv = 'FUNDSTREAM'
	 		  where RxEC.RecordID = tFA.RecordID
			    and RxEC.ErrorCheckID = 2)
	
	insert #tmpRecordxFundingStream
	(RecordID,FundingStreamID,ServiceTypeID, CoreSerivceOnlyIndicator)
	select tFA.RecordID, CA.CodeID, CS.CodeID,
		case 
		     when (rtrim(ltrim(isNull(CoreSelfServices,''))) = '1' or
			len(rtrim(ltrim(isNull(FirstCoreServiceDate,'')))) > 0)
		       and len(rtrim(ltrim(isNull(tFA.FirstIntensiveService,'')))) = 0
		       and len(rtrim(ltrim(isNull(tFA.DateEnterTraining, '')))) = 0 
		       and rtrim(ltrim(isNull(tFA.TrainingService1, '0'))) = '0' then 1
		     else 0
		end 
	from Code CA
	inner join tmpFileUpload_WIA tFA
	on isDate(FirstYouthServiceDate) = 1 or tFA.YouthStatewide15Percent = '1' 
	inner join Code CS
	on CS.CodeGroup = 'ServiceType'
	and IsDate(tFA.ProgramParticipationDate) = 1
	and IsDate(tFA.DateOfBirth) = 1
	and case
		when dbo.ufn_GetAge ( tFA.DateOfBirth, tFA.FirstYouthServiceDate) between 19 and 21 then 'OLDYTH'
		when dbo.ufn_GetAge ( tFA.DateOfBirth, tFA.FirstYouthServiceDate) between 14 and 18 then 'YOUNGYTH'
	 	else ''
	     end = CS.CodeAbbrv
	where CA.CodeGroup = 'FundingStreamType' and CA.CodeAbbrv = 'Youth'
	  and not exists (select 'c' from RecordXErrorCheck RxEC
			  inner join ErrorCheck EC
			  on EC.ErrorAbbrv = 'FUNDSTREAM'
	 		  where RxEC.RecordID = tFA.RecordID
			    and RxEC.ErrorCheckID = 2)

declare @tblErrors table
   (dummyid    int identity(1,1) not null,
    ErrorAbbrv varchar(50) not null)

insert @tblErrors (ErrorAbbrv)select EC.ErrorAbbrv
from ErrorCheck EC
inner join Code C
on EC.ErrorTypeID = C.CodeID
and C.CodeAbbrv = 'WARNING'

create index idxRecordID on #tmpErrorRecords (RecordID)

set @nErrorCheckLoopID = 0

while exists (select 'c' from @tblErrors tE where tE.dummyid > @nErrorCheckLoopID)
	and (@nTotalWarnings < @nMaxWarnings)
  begin

	select top 1 @nErrorCheckLoopID = tE.dummyid, @ErrorCheckAbbrv = tE.ErrorAbbrv
	from @tblErrors tE
	where tE.dummyid > @nErrorCheckLoopID
	order by tE.dummyid asc
print @ErrorCheckAbbrv
	if (@ErrorCheckAbbrv = 'WARNAGE')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.DateOfBirth,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNAGE'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where case isDate(tFA.DateOfBirth) + isDate(tFA.ProgramParticipationDate)
				when 2 then dbo.ufn_GetAge ( tFA.DateOfBirth, tFA.ProgramParticipationDate)
				else 0
			      end  not between 14 and 100
	      and len(isNull(ltrim(rtrim(tFA.FirstYouthServiceDate)),'')) = 0
	      and len(isNull(ltrim(rtrim(tFA.DateOfBirth)),'')) > 0
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)


	if (@ErrorCheckAbbrv = 'WARNDISABLE')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.VeteranDisabled,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNDISABLE'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where tFA.DisabilityStatus <> '1'
	      and tFA.HighestGradeCompleted = '89'
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

	if (@ErrorCheckAbbrv = 'WARNVET')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.VeteranStatus,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNVET'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where tFA.VeteranStatus <> '2'
	      and (tFA.VeteranCampaign = '1' 
		or tFA.VeteranDisabled in ('1','2')
		or tFA.VeteranRecentlySeparated = '1')
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

	if (@ErrorCheckAbbrv = 'WARNVETCAMP')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.VeteranCampaign,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNVETCAMP'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where tFA.VeteranCampaign not in ('1','2')
	      and tFA.VeteranStatus in ('1','2')
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

	if (@ErrorCheckAbbrv = 'WARNVETDISABLE')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.VeteranDisabled,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNVETDISABLE'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where tFA.VeteranDisabled not in ('1','2','3')
	      and tFA.VeteranStatus in ('1','2')
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

	if (@ErrorCheckAbbrv = 'WARNVETSEP')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.VeteranRecentlySeparated,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNVETSEP'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where tFA.VeteranRecentlySeparated not in ('1','2')
	      and tFA.VeteranStatus in ('1','2')
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

	if (@ErrorCheckAbbrv = 'WARNETA')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.ETACode,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNETA'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where ( substring(tFA.ETACode,5,1) not in ('0','5')
	          and (tFA.AdultLocal='1' or tFA.DWLocal='1' or
		(isDate(FirstYouthServiceDate) = 1) 
		       and tFA.YouthStatewide15Percent <> '1' ))
	       or ( substring(tFA.ETACode,3,3) in ('000') )

	       or ( substring(tFA.ETACode, case when len(tFA.ETACode) < 4 then 3 
						else len(tFA.ETACode) end - 2,3) not in ('903') 
		 and (tFA.AdultStatewide15Percent = '1' or tFA.DWStatewide15Percent = '1'
			or tFA.YouthStatewide15Percent = '1')
		 and (tFA.AdultLocal <> '1' and tFA.DWLocal <> '1') 
		 and (len(rtrim(ltrim(isNull(FirstYouthServiceDate,'')))) = 0
		    or (len(rtrim(ltrim(isNull(FirstYouthServiceDate,'')))) > 0
		     and tFA.YouthStatewide15Percent = '1' )))
	       or ( substring(tFA.ETACode, case when len(tFA.ETACode) < 4 then 3 
						else len(tFA.ETACode) end - 2,3) not in ('901')
		 and ( (tFA.NEGProject1 <> '0000' and len(tFA.NEGProject1) >= 4)
		    or (tFA.NEGProject2 <> '0000' and len(tFA.NEGProject2) >= 4)
		   or (tFA.NEGProject3 <> '0000' and len(tFA.NEGProject3) >= 4) 
)
		 and tFA.AdultStatewide15Percent <> '1' 
		 and tFA.DWStatewide15Percent <> '1'
		 and tFA.YouthStatewide15Percent <> '1'
		 and tFA.AdultLocal <> '1' 
		 and tFA.DWLocal <> '1'
		 and len(rtrim(ltrim(isNull(FirstYouthServiceDate,'')))) = 0 ) 
	       or ( substring(tFA.ETACode, case when len(tFA.ETACode) < 4 then 3 
						else len(tFA.ETACode) end - 2,3) not in ('902')
		 and ( tFA.RapidResponse = '1' or tFA.AddRapidResponse = '1' )
		 and ( (tFA.NEGProject1 = '0000' or len(rtrim(ltrim(isNull(tFA.NEGProject1,'')))) = 0)
		   and (tFA.NEGProject2 = '0000' or len(rtrim(ltrim(isNull(tFA.NEGProject2,'')))) = 0)
		  and (tFA.NEGProject3 = '0000' or len(rtrim(ltrim(isNull(tFA.NEGProject3,'')))) = 0) 
		   and tFA.AdultStatewide15Percent <> '1' 
		   and tFA.DWStatewide15Percent <> '1'
		   and tFA.YouthStatewide15Percent <> '1'
		   and tFA.AdultLocal <> '1' 
		   and tFA.DWLocal <> '1'
		   and len(rtrim(ltrim(isNull(FirstYouthServiceDate,'')))) = 0 ) )
		or ( case isNumeric(tFA.ETACode)
			when 0 then 0
			else cast(tFA.ETACode as int)
		     end <= 1000 )
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

	if (@ErrorCheckAbbrv = 'WARNNEGPROJ2')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.NEGProject2,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNNEGPROJ2'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where ( tFA.NEGProject1 = '0000' 
	       or len(rtrim(ltrim(isNull(tFA.NEGProject1,'')))) = 0 )
	      and tFA.NEGProject2 <> '0000' 
	      and len(rtrim(ltrim(isNull(tFA.NEGProject2,'')))) > 0
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)
-- disable the warning for NEGProject3--08/06/08
	/*if (@ErrorCheckAbbrv = 'WARNNEGPROJ3')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.NEGProject3,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNNEGPROJ3'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where ( tFA.NEGProject2 = '0000' 
	       or len(rtrim(ltrim(isNull(tFA.NEGProject2,'')))) = 0 )
	      and tFA.NEGProject3 <> '0000' 
	      and len(rtrim(ltrim(isNull(tFA.NEGProject3,'')))) > 0
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)*/

	if (@ErrorCheckAbbrv = 'WARNCORESVCDATE')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.FirstCoreServiceDate,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNCORESVCDATE'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where  len(rtrim(ltrim(isNull(tFA.FirstCoreServiceDate,'')))) > 0
	      and  len(rtrim(ltrim(isNull(tFA.ProgramExitDate,'')))) > 0
	      and  case isDate(tFA.FirstCoreServiceDate) 
			when 1 then cast(tFA.FirstCoreServiceDate as smalldatetime)
			else getdate()
		   end > case isDate(tFA.ProgramExitDate) 
			when 1 then cast(tFA.ProgramExitDate as smalldatetime)
			else getdate()
		   end
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

	if (@ErrorCheckAbbrv = 'WARNINTENSEDATE')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.FirstIntensiveService,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNINTENSEDATE'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where  len(rtrim(ltrim(isNull(tFA.FirstIntensiveService,'')))) > 0
	      and  len(rtrim(ltrim(isNull(tFA.ProgramExitDate,'')))) > 0
	      and  case isDate(tFA.FirstIntensiveService) 
			when 1 then cast(tFA.FirstIntensiveService as smalldatetime)
			else getdate()
		   end > case isDate(tFA.ProgramExitDate) 
			when 1 then cast(tFA.ProgramExitDate as smalldatetime)
			else getdate()
		   end
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

	if (@ErrorCheckAbbrv = 'WARNTRAINDATE')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.DateEnterTraining,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNTRAINDATE'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where len(rtrim(ltrim(isNull(tFA.OTCCode,'')))) > 0 
	      and tFA.OTCCode <> '00000000' 
	      and isDate(tFA.DateEnterTraining) = 0
	      and exists (select 'c' from #tmpRecordxFundingStream tRFS
			  inner join Code CFS
			  on CFS.CodeID = tRFS.FundingStreamID
		 	  and CFS.CodeAbbrv in ('Adult','DW','Youth') 
	  		  inner join Code CST
			  on CST.CodeID = tRFS.ServiceTypeID
	 		  and CST.CodeAbbrv in ('CORE','INTENSETRAIN','OLDYTH')
			  where tRFS.RecordID = tFA.RecordID)
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)


	if (@ErrorCheckAbbrv = 'FOLLOWUPSVC')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.DateEnterTraining,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'FOLLOWUPSVC'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    inner join ReportQuarter RQ
	    on RQ.ReportQuarterDueDate = @sReportQuarter
	    where isNull(tFA.FollowupServices,'') not in ('1','2')
	  and  len(rtrim(ltrim(isNull(tFA.ProgramExitDate,'')))) > 0
		  and  case isDate(tFA.ProgramExitDate) 
			     when 1 then cast(tFA.ProgramExitDate as datetime)
		         else getdate()
		       end <= cast(RQ.QuarterEndMonthDay + '/' + @sProgramYear as datetime)
     
--	      and dateadd(quarter,-4,cast(RQ.QuarterStartMonthDay + '/' + @sProgramYear as datetime))
--							                     > cast(tFA.ProgramExitDate as smalldatetime) 
	      and exists (select 'c' from #tmpRecordxFundingStream tRFS
			  inner join Code CFS
			  on CFS.CodeID = tRFS.FundingStreamID
		 	  and CFS.CodeAbbrv in ('Youth') 
			  where tRFS.RecordID = tFA.RecordID)
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

	if (@ErrorCheckAbbrv = 'WARNENROLL')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.Enrolled,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNENROLL'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where tFA.Enrolled <> '1'
	      and tFA.ExitSchoolStatus in ('1','2','3')
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

	if (@ErrorCheckAbbrv = 'WARNCOMPTRAINDATE')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.DateExitTraining,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNCOMPTRAINDATE'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where  ( len(rtrim(ltrim(isNull(tFA.DateExitTraining,'')))) > 0
	      and  len(rtrim(ltrim(isNull(tFA.DateEnterTraining,'')))) = 0 )
		or ( case isDate(tFA.DateExitTraining) 
			when 1 then cast(tFA.DateExitTraining as smalldatetime)
			else getdate()
		   end < case isDate(tFA.DateEnterTraining) 
			when 1 then cast(tFA.DateEnterTraining as smalldatetime)
			else getdate()
		   end )
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

	if (@ErrorCheckAbbrv = 'WARNTRAINSVC1')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.TrainingService1,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNTRAINSVC1'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where  (isNull(tFA.TrainingService1,'') not in ('1','2','3','4','5','6')
		and isDate(tFA.DateEnterTraining) = 1 )
	      or (case len(rtrim(ltrim(tFA.TrainingService1)))
		    when 0 then '0'
		    else tFA.TrainingService1
		  end <> '0'
		and len(rtrim(ltrim(isNull(tFA.DateEnterTraining,'')))) = 0 )
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

	if (@ErrorCheckAbbrv = 'WARNTRAINSVC2')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.TrainingService2,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNTRAINSVC2'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where 
--( case len(rtrim(ltrim(IsNull(tFA.TrainingService2,''))))
--			when 0 then '0'
--			else tFA.TrainingService2
--		    end <> '0'
--		  and isDate(tFA.DateEnterTraining) = 0 )
--	      or 
		(case len(rtrim(ltrim(tFA.TrainingService1)))
		    when 0 then '0'
		    else tFA.TrainingService1
		  end = '0'
		and case len(rtrim(ltrim(tFA.TrainingService2)))
		    when 0 then '0'
		    else tFA.TrainingService2
		  end <> '0')
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

	if (@ErrorCheckAbbrv = 'WARNOCCODE')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.OccupationCode,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNOCCODE'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where (case len(rtrim(ltrim(IsNull(tFA.OccupationCode,''))))
		    when 0 then '00000000'
		    else tFA.OccupationCode
		  end <> '00000000'
	      and tFA.ExitEmployed1 in ('2','3') )
	      or tFA.OccupationCode like '%.%'
	      or tFA.OccupationCode like '%-%'
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

	if (@ErrorCheckAbbrv = 'WARNTRAINEMP')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.EmploymentTraining,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNTRAINEMP'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where tFA.EmploymentTraining not in ('1','2')
	      and ( ( isDate(tFA.DateEnterTraining) = 1
		  and tFA.ExitEmployed1 = '1'
		  and (tFA.AdultLocal = '1' or tFA.AdultStatewide15Percent = '1') )
		or  ( tFA.ExitEmployed1 = '1' 
		  and ( isNull(tFA.TrainingService1,'') in ('1','2','3','4','5','6')
		   or isNull(tFA.TrainingService2,'') in ('1','2','3','4','5','6') )
		  and (tFA.AdultLocal = '1' or tFA.AdultStatewide15Percent = '1') )
	        or  ( tFA.ExitEmployed1 = '1' 
		  and (isDate(FirstYouthServiceDate) = 1 or tFA.YouthStatewide15Percent = '1' )
		  and IsDate(tFA.ProgramParticipationDate) = 1
		  and IsDate(tFA.DateOfBirth) = 1
		  and dbo.ufn_GetAge ( tFA.DateOfBirth, tFA.FirstYouthServiceDate) between 19 and 21 ) )
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

--------------604 update begins------------
if (@ErrorCheckAbbrv = 'WARNTRAINEMPC')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.EmploymentTraining,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNTRAINEMPC'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where  ISNULL(rtrim(ltrim(tFA.EmploymentTraining)),0) <> 0
             and ISNULL(tFA.ProgramExitDate,'') =''
      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

----------------604 update ends here------------


	if (@ErrorCheckAbbrv = 'WARNNONTRAD')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.NonTraditionalEmployment,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNNONTRAD'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where tFA.NonTraditionalEmployment not in ('1','2')
	      and tFA.ExitEmployed1 = '1'
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

------------------605 update begins here -----------------
if (@ErrorCheckAbbrv = 'WARNNONTRADB')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.NonTraditionalEmployment,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNNONTRADB'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where  ISNULL(rtrim(ltrim(tFA.NonTraditionalEmployment)),0) <> 0
             and ISNULL(tFA.ProgramExitDate,'') =''
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

------------------605 update ends here -------------------

	if (@ErrorCheckAbbrv = 'WARNQTR4EXIT')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
			tFA.ExitEmployed4, getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNQTR4EXIT'
	    inner join ReportQuarter RQ
	    on RQ.ReportQuarterDueDate = @sReportQuarter
	    inner join ReportQuarter RQ1
	    on RQ1.ReportQuarterSequence = case RQ.ReportQuarterSequence
						    when 4 then 1
	                                            else RQ.ReportQuarterSequence + 1
	                                         end
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where ( tFA.ExitEmployed4 <> '1'
	        and isNull(tFA.ExitEmployedMatch4,'') in ('1','2','3','4','5') )
	       or ( tFA.ExitEmployed4 <> '3'
	        and tFA.ExitEmployedMatch4 = '6' )
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)


	if (@ErrorCheckAbbrv = 'PASS2QTREXIT4')

	    insert RecordXErrorCheck
	   (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
			tFA.ExitEmployed4, getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'PASS2QTREXIT4'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    inner join ReportQuarter RQ
	    on RQ.ReportQuarterDueDate = @sReportQuarter
	    inner join ReportQuarter RQ1
	    on RQ1.ReportQuarterSequence = case RQ.ReportQuarterSequence
						    when 4 then 1
	                                            else RQ.ReportQuarterSequence + 1
	                                         end
	    where ( ( tFA.ExitEmployed4 <> '2'
	        and case len(isNull(rtrim(ltrim(tFA.ExitEmployedMatch4)),''))
	                when 0 then '0'
	                else tFA.ExitEmployedMatch4
	            end = '0' )
	       or ( tFA.ExitEmployed4 <> '3'
		and len(isNull(rtrim(ltrim(tFA.ProgramExitDate)),'')) = 0 )
	       or ( tFA.ExitEmployed4 = '3'
	        and isDate(tFA.ProgramExitDate) = 1
	        and datediff(month,-12,cast(RQ.QuarterStartMonthDay + '/' + @sProgramYear as datetime))
							                     > cast(tFA.ProgramExitDate as smalldatetime)  ) )
		and exists ( select 'c' from #tmpRecordxFundingStream tRFS
			     inner join WIALXSystem.dbo.Code CFS (nolock) on CFS.CodeID = tRFS.FundingStreamID
			     and CFS.CodeAbbrv in ('Adult','DW','Youth','NEG')
			     inner join WIALXSystem.dbo.Code CST (nolock) on CST.CodeID = tRFS.ServiceTypeID
			     and ( CST.CodeAbbrv in ('CORE','INTENSETRAIN','OLDYTH')
				or ( CFS.CodeAbbrv = 'NEG' and tRFS.CoreSerivceOnlyIndicator = 1 ) )
			     where tFA.RecordID = tRFS.RecordID)

	if (@ErrorCheckAbbrv = 'WARNQTR4EMPLOY')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
			tFA.ExitEmployedMatch4, getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNQTR4EMPLOY'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where ( isNull(tFA.ExitEmployedMatch4,'') not in ('1','2','3','4')
	        and case isNumeric(ExitWages4)
	               when 0 then 0
	               else cast(ExitWages4 as Numeric(10,2))
	            end > 0
	        and case isNumeric(ExitWages4)
	               when 0 then 0
	               else cast(ExitWages4 as Numeric(10,2))
	            end < 999999.99 )
	       or ( case len(isNull(rtrim(ltrim(tFA.ExitEmployedMatch4)),''))
	                when 0 then '0'
	                else tFA.ExitEmployedMatch4
	            end not in ('0','5')
	        and case len(isNull(rtrim(ltrim(ExitWages4)),'')) 
			when 0 then '0'
			else rtrim(ltrim(ExitWages4))
		    end = '0' )
	       or ( isNull(tFA.ExitEmployedMatch4,'') <> '6'
	        and ExitWages4 = '999999.99' )
	      and not exists (select 'c' from #tmpErrorRecords tER			      where tER.RecordID = tFA.RecordID)
	
		if (@ErrorCheckAbbrv = 'WARNPRIORWAGE')
		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNPRIORWAGE'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPRIORWAGE''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where len(rtrim(ltrim(isNull(tFA.' + tC.ColumnName + ','''')))) > 0
					      and tFA.' + tC.ColumnName + ' <> ''999999.99''
					      and case isNumeric(rtrim(ltrim(tFA.' + tC.ColumnName + '))) 
						    when 0 then 999999.99
						    else cast(tFA.' + tC.ColumnName + ' as numeric(10,2))
					      	  end > 100000
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'
		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc
	
		                exec (@SQLString)
	
		            end
	
		    end
	
		if (@ErrorCheckAbbrv = 'WARNEXITWAGE')
		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNEXITWAGE'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNEXITWAGE''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where len(rtrim(ltrim(isNull(tFA.' + tC.ColumnName + ','''')))) > 0
					      and tFA.' + tC.ColumnName + ' <> ''999999.99''
					      and case isNumeric(rtrim(ltrim(tFA.' + tC.ColumnName + '))) 
						    when 0 then 999998.99
						    else cast(tFA.' + tC.ColumnName + ' as numeric(10,2))
					      	  end > 50000
					      and tFA.' + tC.ColumnName + ' <> ''999999.99''
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'
		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc
	
		                exec (@SQLString)
	
		            end
	
		    end
	
		if (@ErrorCheckAbbrv = 'WARNGOALTYPE')
		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNGOALTYPE'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNGOALTYPE''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
					    inner join #tmpRecordxFundingStream tRxFS
					    on tRxFS.RecordID = tFA.RecordID
					    inner join Code CFS
					    on tRxFS.FundingStreamID = CFS.CodeID
					    and CFS.CodeAbbrv = ''Youth''
					    inner join Code CST
					    on tRxFS.ServiceTypeID = CST.CodeID
					    and CST.CodeAbbrv = ''YOUNGYTH''
		                            where isNull(tFA.' + tC.ColumnName + ','''') not in (''1'',''2'',''3'')
					      and ( tFA.SchoolParticipation in (''1'',''2'')
						or (tFA.SchoolParticipation = ''3'' and LiteracySkillsIndicator = ''1'') )
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'
		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc
	
		                exec (@SQLString)
	
		            end
	
		    end

	
		if (@ErrorCheckAbbrv = 'WARNGOALSETDATE')
		    begin
			        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNGOALSETDATE'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNGOALSETDATE''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where isDate(tFA.' + tC.ColumnName + ') = 0
					      and tFA.GoalType' + replace(tC.ColumnName,'DateGoalSet','') + ' in (''1'',''2'',''3'')
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'
		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc
	
		                exec (@SQLString)
	
		            end
	
		    end

		if (@ErrorCheckAbbrv = 'WARNGOALSETDATEA')
		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNGOALSETDATEA'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0

		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNGOALSETDATEA''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where ((case IsDate(tFA.' + tC.ColumnName + ')
							when 0 then getdate()
							else cast(tFA.' + tC.ColumnName + ' as smalldatetime)
						     end <
						     case IsDate(tFA.DateGoalSet' + cast((cast(substring(tC.ColumnName,12,2) as smallint) - 1) as varchar(2)) + ')
							when 0 then getdate()
							else cast(tFA.DateGoalSet' + cast((cast(substring(tC.ColumnName,12,2) as smallint) - 1) as varchar(2)) + ' as smalldatetime)
						     end )
					          and tFA.GoalType' + replace(tC.ColumnName,'DateGoalSet','') + ' in (''1'',''2'',''3''))
					      or (len(isNull(tFA.' + tC.ColumnName + ','''')) > 0
						and isNull(tFA.GoalType' + replace(tC.ColumnName,'DateGoalSet','') + ',''0'') = ''0'')
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'
		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc

		                exec (@SQLString)
	
		            end
	
		    end


		if (@ErrorCheckAbbrv = 'WARNGOALATTAIN1')
		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNGOALATTAIN1'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNGOALATTAIN1''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where ( isNull(tFA.' + tC.ColumnName + ','''') not in (''1'',''2'',''3'')
					        and tFA.GoalType' + replace(tC.ColumnName,'GoalAttainment','') + ' in (''1'',''2'',''3'') )
					      or  ( isNull(tFA.' + tC.ColumnName + ','''') not in (''1'')
						and isDate(tFA.DateGoalAttained' + replace(tC.ColumnName,'GoalAttainment','') + ') = 1 )
					      or  (  isNull(tFA.' + tC.ColumnName + ','''') not in (''0'','''')
						and case len(rtrim(ltrim(isNull(tFA.GoalType' + replace(tC.ColumnName,'GoalAttainment','') + ',''''))))
							when 0 then ''''
							else tFA.GoalType' + replace(tC.ColumnName,'GoalAttainment','') + '
						    end = ''0'' )
					      or ( isNull(tFA.' + tC.ColumnName + ','''') in (''3'')					        and isDate(tFA.ProgramExitDate) = 1 )
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'

		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc

		                exec (@SQLString)
	
		            end
	
		    end
		if (@ErrorCheckAbbrv = 'WARNGOALATTAIN')
		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNGOALATTAIN'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNGOALATTAIN''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where ( isNull(tFA.' + tC.ColumnName + ','''') in (''3'')
					        and isDate(tFA.ProgramExitDate) = 1 )
					      or ( isNull(tFA.' + tC.ColumnName + ','''') not in (''1'',''2'',''3'')
					        and tFA.GoalType' + replace(tC.ColumnName,'GoalAttainment','') + ' in (''1'',''2'',''3'') )
					      or  (  isNull(tFA.' + tC.ColumnName + ',''0'') not in (''0'')
						and case len(rtrim(ltrim(isNull(tFA.GoalType' + replace(tC.ColumnName,'GoalAttainment','') + ',''''))))
							when 0 then ''0''
							else tFA.GoalType' + replace(tC.ColumnName,'GoalAttainment','') + '
						    end = ''0'' )
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'

		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc
	
		                exec (@SQLString)
	
		            end
	
		    end

		if (@ErrorCheckAbbrv = 'WARNGOALATTAINDATE')
		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNGOALATTAINDATE'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNGOALATTAINDATE''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where (( tFA.GoalAttainment' + replace(tC.ColumnName,'DateGoalAttained','') + ' = ''1''
					        and  case IsDate(tFA.' + tC.ColumnName + ')
							when 0 then getdate()
							else cast(tFA.' + tC.ColumnName + ' as smalldatetime)
						     end <
						     case IsDate(tFA.DateGoalSet' + replace(tC.ColumnName,'DateGoalAttained','') + ')
							when 0 then getdate()
							else cast(tFA.DateGoalSet' + replace(tC.ColumnName,'DateGoalAttained','') + ' as smalldatetime)
						     end )
					       or ( ( case len(rtrim(ltrim(isNull(tFA.GoalAttainment' + replace(tC.ColumnName,'DateGoalAttained','') + ',''''))))
							when 0 then ''0''
							else  tFA.GoalAttainment' + replace(tC.ColumnName,'DateGoalAttained','') + '
						      end in (''2'',''3'',''0'')
						and len(rtrim(ltrim(isNull(tFA.' + tC.ColumnName + ','''')))) > 0 )))
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'

		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc

		                exec (@SQLString)

		            end
	
		    end

	if (@ErrorCheckAbbrv = 'WARNCRED')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.DegreeCertificate,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNCRED'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    inner join #tmpRecordxFundingStream tRFS
	    on tRFS.RecordID = tFA.RecordID
	    inner join Code CFS
	    on CFS.CodeID = tRFS.FundingStreamID
	    and CFS.CodeAbbrv = 'Youth'
	    inner join Code CST
	    on CST.CodeID = tRFS.ServiceTypeID
	    and CST.CodeAbbrv = 'YOUNGYTH'
	    inner join ReportQuarter RQ
	    on RQ.ReportQuarterDueDate = @sReportQuarter
	    where tFA.DegreeCertificate not in ('1','2','3','4')
	      and tFA.SchoolParticipation in ('1','2','4')
	      and dateadd(quarter,-1,cast(RQ.QuarterStartMonthDay + '/' + @sProgramYear as datetime))
				                    > cast(tFA.ProgramExitDate as smalldatetime) 
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

	if (@ErrorCheckAbbrv = 'WARNCREDATTAINDATE')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.DateDegreeCertificate,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNCREDATTAINDATE'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where ( case isDate(tFA.DateDegreeCertificate)
		    when 0 then getdate()
		    else cast(tFA.DateDegreeCertificate as smalldatetime)
		  end <=
		  case isDate(tFA.ProgramParticipationDate)
		    when 0 then getdate()
		    else cast(tFA.ProgramParticipationDate as smalldatetime)
		  end
	      and tFA.DegreeCertificate in ('1','2','3','4') )
	      or ( len(isNull(rtrim(ltrim(tFA.DateDegreeCertificate)),'')) = 0
		  and tFA.DegreeCertificate in ('1','2','3') )
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

	if (@ErrorCheckAbbrv = 'WARNEXIT')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.ExitSchoolStatus,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNEXIT'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID
	    where tFA.ExitSchoolStatus in ('1','2','4')
	      and tFA.SchoolParticipation in ('3','5')
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

	if (@ErrorCheckAbbrv = 'WARNASSESSCAT')

	    insert RecordXErrorCheck
	    (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
	    select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID, 
			    tFA.AssessmentCategory,getdate()
	    from tmpFileUpload_WIA tFA (nolock)
	    inner join ErrorCheck EC
	    on EC.ErrorAbbrv = 'WARNASSESSCAT'
	    inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
	    on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	    inner join FileRecordLayoutElement FRLE
	    on ECxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	    inner join FileRecordLayout FRL
	    on FRL.FileRecordLayoutID = FRLE.FileRecordLayoutID
	    and FRL.ProgramYearID = @nProgramYearID
	    and FRL.SystemID = @nSystemID

	    --where isNull(tFA.AssessmentCategory,'0') not in ('1','2')
	--03112009 156 - 701
	where isNull(tFA.AssessmentCategory,'0') not in ('1','2','3')
	      and tFA.SchoolParticipation in ('3','4','5') -- FLAG
	      and tFA.LiteracySkillsIndicator = '1' -- FLAG
	      and case isDate(tFA.FirstYouthServiceDate)
			when 1 then cast(tFA.FirstYouthServiceDate as datetime)
			else getdate()
		  end >= cast(@litNumStartDate as datetime)
		and exists ( select 'c' from #tmpRecordxFundingStream tRFS
			     inner join Code CFS on CFS.CodeID = tRFS.FundingStreamID
			     and CFS.CodeAbbrv in ('Youth')
			     where tFA.RecordID = tRFS.RecordID)			
	      and not exists (select 'c' from #tmpErrorRecords tER
			      where tER.RecordID = tFA.RecordID)

	if (@ErrorCheckAbbrv = 'WARNASSESSTYPE')
		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNASSESSTYPE'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	
/*
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNASSESSTYPE''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where isNull(tFA.AssessmentType' + replace(tC.ColumnName,'AssessmentType','') + ',''0'') not in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'')
					      and tFA.AssessmentCategory in (''1'',''2'')
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'
*/
--03112009 157 - 702
				select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNASSESSTYPE''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            ' inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                             where isNull(tFA.AssessmentType' + replace(tC.ColumnName,'AssessmentType','') + ',''0'') not in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'',''9'',''10'')
					      and tFA.AssessmentCategory in (''1'',''2'',''3'')
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'

		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc
	
		                exec (@SQLString)
	
		            end
	
		    end

	if (@ErrorCheckAbbrv = 'WARNFUNCAREA')
		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNFUNCAREA'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	/*
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNFUNCAREA''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where isNull(tFA.' + tC.ColumnName + ','''') not in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'')
					      and tFA.AssessmentType' + replace(tC.ColumnName,'FunctionalArea','') + ' in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'')
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'
*/
		/*03112009 BT 158 703*/
  				select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNFUNCAREA''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where isNull(tFA.' + tC.ColumnName + ','''') not in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'')
					      and tFA.AssessmentType' + replace(tC.ColumnName,'FunctionalArea','') + ' in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'',''9'',''10'')
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'

		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc
	
		                exec (@SQLString)
	
		            end	
		    end

	if (@ErrorCheckAbbrv = 'WARNPRETESTDATE')		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNPRETESTDATE'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	
/* 03302009 BT 159 704
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPRETESTDATE''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where ( isDate(tFA.' + tC.ColumnName + ') = 0
					        and isNull(tFA.AssessmentType' + replace(tC.ColumnName,'PreTestDate','') + ','''') in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'') )
					       or ( case IsDate(tFA.' + tC.ColumnName + ')
							when 0 then getdate()
							else cast(tFA.' + tC.ColumnName + ' as smalldatetime)
						     end >
						     case IsDate(tFA.PostTestDate' + replace(tC.ColumnName,'PreTestDate','') + 'Y1)
							when 0 then getdate()
							else cast(tFA.PostTestDate' + replace(tC.ColumnName,'PreTestDate','') + 'Y1 as smalldatetime)
						     end )
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'
*/
			select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPRETESTDATE''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where ( isDate(tFA.' + tC.ColumnName + ') = 0
					        and isNull(tFA.AssessmentType' + replace(tC.ColumnName,'PreTestDate','') + ','''') in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'',''9'',''10'') )
					      and dbo.getReportPeriod (''EndOfReportingPeriod'',0) >  case IsDate(tFA.FirstYouthServiceDate)
							when 0 then getdate()
							else DateAdd(Day,90,cast(tFA.FirstYouthServiceDate as smalldatetime))
						     end
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'

		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc
	print @SQLString
		                exec (@SQLString)
	
		            end
	
		    end

	if (@ErrorCheckAbbrv = 'WARNPRETESTSCORE')
		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNPRETESTSCORE'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	
		                select top 1 @nLoopControlID = tC.DummyID,
/* 160 705 04022009 BT
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPRETESTSCORE''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where ( isDate(tFA.PreTestDate' + replace(tC.ColumnName,'PreTestScore','') + ') = 1
					        and case isNumeric(tFA.' + tC.ColumnName + ')
							when 0 then 0
							else cast(tFA.' + tC.ColumnName + ' as int)
						    end <= 0 )
					       or ( tFA.PreTestEducationLevel' + replace(tC.ColumnName,'PreTestScore','') + ' in (''1'',''2'',''3'',''4'',''5'',''6'')
					        and case isNumeric(tFA.' + tC.ColumnName + ')
							when 0 then 0
							else cast(tFA.' + tC.ColumnName + ' as int)
						    end <= 0 )
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'
*/
					
				@SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPRETESTSCORE''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where ( isDate(tFA.PreTestDate' + replace(tC.ColumnName,'PreTestScore','') + ') = 1
					        and case isNumeric(tFA.' + tC.ColumnName + ')
							when 0 then 0
							else cast(tFA.' + tC.ColumnName + ' as int)
						    end <= 0 )
					       or ( tFA.PreTestEducationLevel' + replace(tC.ColumnName,'PreTestScore','') + ' in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'')
					        and case isNumeric(tFA.' + tC.ColumnName + ')
							when 0 then 0
							else cast(tFA.' + tC.ColumnName + ' as int)
						    end <= 0 )
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'

		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc
	
		                exec (@SQLString)
	
		            end
	
		    end


	if (@ErrorCheckAbbrv = 'WARNPRETESTFUNCLEVEL')
		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNPRETESTFUNCLEVEL'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	/* 161 706 04020009 BT
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPRETESTFUNCLEVEL''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where isNull(tFA.' + tC.ColumnName + ','''') not in (''1'',''2'',''3'',''4'',''5'',''6'')
					      and case isNumeric(tFA.PreTestScore' + replace(tC.ColumnName,'PreTestEducationLevel','') + ')
						   when 0 then 0
						   else cast(tFA.PreTestScore' + replace(tC.ColumnName,'PreTestEducationLevel','')+ ' as int)
						  end > 0 
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'
*/
				 select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPRETESTFUNCLEVEL''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where isNull(tFA.' + tC.ColumnName + ','''') not in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'')
					      and case isNumeric(tFA.PreTestScore' + replace(tC.ColumnName,'PreTestEducationLevel','') + ')
						   when 0 then 0
						   else cast(tFA.PreTestScore' + replace(tC.ColumnName,'PreTestEducationLevel','')+ ' as int)
						  end > 0 
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'

		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc
	
		                exec (@SQLString)
	
		            end
	
		    end

/*162 707 - 03242009 BT
	if (@ErrorCheckAbbrv = 'WARNPOSTTESTDATEYR1')
		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNPOSTTESTDATEYR1'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPOSTTESTDATEYR1''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where len(isNull(rtrim(ltrim(tFA.' + tC.ColumnName + ')),'''')) > 0
					      and ( case IsDate(tFA.' + tC.ColumnName + ')
							when 0 then getdate()
							else cast(tFA.' + tC.ColumnName + ' as smalldatetime)
						     end <=
						     case IsDate(tFA.PreTestDate' + replace(replace(tC.ColumnName,'PostTestDate',''),'Y1','') + ')
							when 0 then getdate()
							else cast(tFA.PreTestDate' + replace(replace(tC.ColumnName,'PostTestDate',''),'Y1','') + ' as smalldatetime)
						     end )
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'
		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc

		                exec (@SQLString)
	
		            end
	
		    end
*/
	if (@ErrorCheckAbbrv = 'WARNPOSTTESTSCOREYR1')
		    begin	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNPOSTTESTSCOREYR1'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	/* 163 - 708 04022009 BT
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPOSTTESTSCOREYR1''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where ( isDate(tFA.PostTestDate' + replace(replace(tC.ColumnName,'PostTestScore',''),'Y1','') + 'Y1) = 1
					        and case isNumeric(tFA.' + tC.ColumnName + ')
							when 0 then 0
							else cast(tFA.' + tC.ColumnName + ' as int)
						    end <= 0 )
					       or ( tFA.PostTestEducationLevel' + replace(replace(tC.ColumnName,'PostTestScore',''),'Y1','') + 'Y1 in (''1'',''2'',''3'',''4'',''5'',''6'')
					        and case isNumeric(tFA.' + tC.ColumnName + ')
							when 0 then 0
							else cast(tFA.' + tC.ColumnName + ' as int)
						    end <= 0 )
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'
*/

				 select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPOSTTESTSCOREYR1''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where ( isDate(tFA.PostTestDate' + replace(replace(tC.ColumnName,'PostTestScore',''),'Y1','') + 'Y1) = 1
					        and case isNumeric(tFA.' + tC.ColumnName + ')
							when 0 then 0
							else cast(tFA.' + tC.ColumnName + ' as int)
						    end <= 0 )
					       or ( tFA.PostTestEducationLevel' + replace(replace(tC.ColumnName,'PostTestScore',''),'Y1','') + 'Y1 in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'')
					        and case isNumeric(tFA.' + tC.ColumnName + ')
							when 0 then 0
							else cast(tFA.' + tC.ColumnName + ' as int)
						    end <= 0 )
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'

		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc
	
		                exec (@SQLString)
	
		            end
	
		    end


	if (@ErrorCheckAbbrv = 'WARNPOSTTESTFUNCLEVELYR1')
		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNPOSTTESTFUNCLEVELYR1'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	/* 164 709 04020009 BT
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPOSTTESTFUNCLEVELYR1''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where isNull(tFA.' + tC.ColumnName + ','''') not in (''1'',''2'',''3'',''4'',''5'',''6'')
					      and case isNumeric(tFA.PostTestScore' + replace(replace(tC.ColumnName,'PostTestEducationLevel',''),'Y1','') + 'Y1)						   when 0 then 0
						   else cast(tFA.PostTestScore' + replace(replace(tC.ColumnName,'PostTestEducationLevel',''),'Y1','') + 'Y1 as int)
						  end > 0 
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'
*/

			  select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC		                            on EC.ErrorAbbrv = ''WARNPOSTTESTFUNCLEVELYR1''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where isNull(tFA.' + tC.ColumnName + ','''') not in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'')
					      and case isNumeric(tFA.PostTestScore' + replace(replace(tC.ColumnName,'PostTestEducationLevel',''),'Y1','') + 'Y1)						   when 0 then 0
						   else cast(tFA.PostTestScore' + replace(replace(tC.ColumnName,'PostTestEducationLevel',''),'Y1','') + 'Y1 as int)
						  end > 0 
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'

		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc

		                exec (@SQLString)
	
		            end
	
		    end

/* 165 710 Date Administered Post-test Year#2 03222009 BT
	if (@ErrorCheckAbbrv = 'WARNPOSTTESTDATEYR2')
		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNPOSTTESTDATEYR2'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPOSTTESTDATEYR2''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where len(isNull(rtrim(ltrim(tFA.' + tC.ColumnName + ')),'''')) > 0
					      and ( case IsDate(tFA.' + tC.ColumnName + ')
							when 0 then getdate()
							else cast(tFA.' + tC.ColumnName + ' as smalldatetime)
						     end <=
						     case IsDate(tFA.PostTestDate' + replace(replace(tC.ColumnName,'PostTestDate',''),'Y2','') + 'Y1)
							when 0 then getdate()
							else cast(tFA.PostTestDate' + replace(replace(tC.ColumnName,'PostTestDate',''),'Y2','') + 'Y1 as smalldatetime)						     end )
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'
		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc
	
		                exec (@SQLString)
	
		            end
	
		    end
*/
	if (@ErrorCheckAbbrv = 'WARNPOSTTESTSCOREYR2')
		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNPOSTTESTSCOREYR2'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	/* 166 711 04022009 BT
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPOSTTESTSCOREYR2''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where ( isDate(tFA.PostTestDate' + replace(replace(tC.ColumnName,'PostTestScore',''),'Y2','') + 'Y2) = 1
					        and case isNumeric(tFA.' + tC.ColumnName + ')
							when 0 then 0
							else cast(tFA.' + tC.ColumnName + ' as int)
						    end <= 0 )
					       or ( tFA.PostTestEducationLevel' + replace(replace(tC.ColumnName,'PostTestScore',''),'Y2','') + 'Y2 in (''1'',''2'',''3'',''4'',''5'',''6'')
					        and case isNumeric(tFA.' + tC.ColumnName + ')
							when 0 then 0
							else cast(tFA.' + tC.ColumnName + ' as int)
						    end <= 0 )
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'
*/
		  select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPOSTTESTSCOREYR2''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where ( isDate(tFA.PostTestDate' + replace(replace(tC.ColumnName,'PostTestScore',''),'Y2','') + 'Y2) = 1
					        and case isNumeric(tFA.' + tC.ColumnName + ')
							when 0 then 0
							else cast(tFA.' + tC.ColumnName + ' as int)
						    end <= 0 )
					       or ( tFA.PostTestEducationLevel' + replace(replace(tC.ColumnName,'PostTestScore',''),'Y2','') + 'Y2 in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'')
					        and case isNumeric(tFA.' + tC.ColumnName + ')
							when 0 then 0
							else cast(tFA.' + tC.ColumnName + ' as int)
						    end <= 0 )
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'


		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc
	
		                exec (@SQLString)
	
		            end
	
		    end


	if (@ErrorCheckAbbrv = 'WARNPOSTTESTFUNCLEVELYR2')
		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNPOSTTESTFUNCLEVELYR2'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	/* 167 712 04022009 BT
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPOSTTESTFUNCLEVELYR2''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where isNull(tFA.' + tC.ColumnName + ','''') not in (''1'',''2'',''3'',''4'',''5'',''6'')
					      and case isNumeric(tFA.PostTestScore' + replace(replace(tC.ColumnName,'PostTestEducationLevel',''),'Y2','') + 'Y2)
						   when 0 then 0
						   else cast(tFA.PostTestScore' + replace(replace(tC.ColumnName,'PostTestEducationLevel',''),'Y2','') + 'Y2 as int)
						  end > 0 
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'
*/

			    select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPOSTTESTFUNCLEVELYR2''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where isNull(tFA.' + tC.ColumnName + ','''') not in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'')
					      and case isNumeric(tFA.PostTestScore' + replace(replace(tC.ColumnName,'PostTestEducationLevel',''),'Y2','') + 'Y2)
						   when 0 then 0
						   else cast(tFA.PostTestScore' + replace(replace(tC.ColumnName,'PostTestEducationLevel',''),'Y2','') + 'Y2 as int)
						  end > 0 
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'


		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc

		                exec (@SQLString)
	
		            end
	
		    end
/* moved to ErrorCheck (Reject) 168 713 03222009 BT
	if (@ErrorCheckAbbrv = 'WARNPOSTTESTDATEYR3')
		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNPOSTTESTDATEYR3'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPOSTTESTDATEYR3''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where len(isNull(rtrim(ltrim(tFA.' + tC.ColumnName + ')),'''')) > 0
					      and ( case IsDate(tFA.' + tC.ColumnName + ')
							when 0 then getdate()
							else cast(tFA.' + tC.ColumnName + ' as smalldatetime)
						     end <=
						     case IsDate(tFA.PostTestDate' + replace(replace(tC.ColumnName,'PostTestDate',''),'Y3','') + 'Y2)
							when 0 then getdate()
							else cast(tFA.PostTestDate' + replace(replace(tC.ColumnName,'PostTestDate',''),'Y3','') + 'Y2 as smalldatetime)
						     end )
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'
		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc
	
		                exec (@SQLString)
	
		            end
	
		    end
*/
	if (@ErrorCheckAbbrv = 'WARNPOSTTESTSCOREYR3')
		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNPOSTTESTSCOREYR3'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	/* 169 714 04022009 BT
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPOSTTESTSCOREYR3''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where ( isDate(tFA.PostTestDate' + replace(replace(tC.ColumnName,'PostTestScore',''),'Y3','') + 'Y3) = 1
					        and case isNumeric(tFA.' + tC.ColumnName + ')
							when 0 then 0
							else cast(tFA.' + tC.ColumnName + ' as int)
						    end <= 0 )
					       or ( tFA.PostTestEducationLevel' + replace(replace(tC.ColumnName,'PostTestScore',''),'Y3','') + 'Y3 in (''1'',''2'',''3'',''4'',''5'',''6'')
					        and case isNumeric(tFA.' + tC.ColumnName + ')
							when 0 then 0
							else cast(tFA.' + tC.ColumnName + ' as int)
						    end <= 0 )
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'
*/

		 select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPOSTTESTSCOREYR3''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where ( isDate(tFA.PostTestDate' + replace(replace(tC.ColumnName,'PostTestScore',''),'Y3','') + 'Y3) = 1
					        and case isNumeric(tFA.' + tC.ColumnName + ')
							when 0 then 0
							else cast(tFA.' + tC.ColumnName + ' as int)
						    end <= 0 )
					       or ( tFA.PostTestEducationLevel' + replace(replace(tC.ColumnName,'PostTestScore',''),'Y3','') + 'Y3 in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'')
					        and case isNumeric(tFA.' + tC.ColumnName + ')
							when 0 then 0
							else cast(tFA.' + tC.ColumnName + ' as int)
						    end <= 0 )
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'

		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc
	
		                exec (@SQLString)
	
		            end
	
		    end


	if (@ErrorCheckAbbrv = 'WARNPOSTTESTFUNCLEVELYR3')
		    begin
	
		        delete @tblColumns
	
		        insert @tblColumns (FileRecordLayoutElementID,ColumnName)
		        select distinct FRLE.FileRecordLayoutElementID,FRLE.ColumnName
		        from FileRecordLayoutElement FRLE
			inner join FileRecordLayout FRL
			on FRLE.FileRecordLayoutID = FRL.FileRecordLayoutID
			and FRL.ProgramYearID = @nProgramYearID
			and FRL.SystemID = @nSystemID
		        inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		        on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		        inner join ErrorCheck EC
		        on EC.ErrorAbbrv = 'WARNPOSTTESTFUNCLEVELYR3'
		        and EC.ErrorCheckID = ECxFRLE.ErrorCheckID
	
		        set @nLoopControlID = 0
	
		        while exists (select 'c' from @tblColumns tC where tC.dummyid > @nLoopControlID)
		            begin
	/* 170 715 04022009 BT
		                select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPOSTTESTFUNCLEVELYR3''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where isNull(tFA.' + tC.ColumnName + ','''') not in (''1'',''2'',''3'',''4'',''5'',''6'')
					      and case isNumeric(tFA.PostTestScore' + replace(replace(tC.ColumnName,'PostTestEducationLevel',''),'Y3','') + 'Y3)
						   when 0 then 0
						   else cast(tFA.PostTestScore' + replace(replace(tC.ColumnName,'PostTestEducationLevel',''),'Y3','') + 'Y3 as int)
						  end > 0 
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'
*/

		  select top 1 @nLoopControlID = tC.DummyID,
		                            @SQLString = 'insert RecordXErrorCheck
		                            (RecordID, ErrorCheckID, FileRecordLayoutElementID, ErrorCheckValue, PostingDate)
		                            select distinct tFA.RecordID, EC.ErrorCheckID, ECxFRLE.FileRecordLayoutElementID,
							tFA.' + tC.ColumnName + ',getdate()
		                            from tmpFileUpload_WIA tFA (nolock)
		                            inner join ErrorCheck EC
		                            on EC.ErrorAbbrv = ''WARNPOSTTESTFUNCLEVELYR3''
		                            inner join ErrorCheckXFileRecordLayoutElement ECxFRLE
		                            on EC.ErrorCheckID = ECxFRLE.ErrorCheckID
					    and ECxFRLE.FileRecordLayoutElementID = ' + cast(tC.FileRecordLayoutElementID as varchar(20)) +
		                            'inner join FileRecordLayoutElement FRLE
		                            on FRLE.FileRecordLayoutElementID = ECxFRLE.FileRecordLayoutElementID
		                            where isNull(tFA.' + tC.ColumnName + ','''') not in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'')
					      and case isNumeric(tFA.PostTestScore' + replace(replace(tC.ColumnName,'PostTestEducationLevel',''),'Y3','') + 'Y3)
						   when 0 then 0
						   else cast(tFA.PostTestScore' + replace(replace(tC.ColumnName,'PostTestEducationLevel',''),'Y3','') + 'Y3 as int)
						  end > 0 
					      and not exists (select ''c'' from #tmpErrorRecords tER
							      where tER.RecordID = tFA.RecordID)'


		                from @tblColumns tC
				where tC.DummyID > @nLoopControlID
		                order by tC.DummyID asc

		                exec (@SQLString)
	
		            end
	
		    end

	select @nTotalWarnings = count(distinct RecordID)
	from RecordxErrorCheck RxEC

  end


if @nTotalWarnings < @nMaxWarnings
	set @pbContinue = 1
else 
	set @pbContinue = 0 
END
GO
-------------------------------------------------------

--------------LX Multiple Database Updates-------------


---------------------  This script updates the LX databases---------
	use WIALXSystem
	go
	
	declare @nloopcontrol int
	declare @sDBName varchar(50)
	declare @sTempDBName varchar(50)
	declare @sApplicationAbbrv varchar(20)
	
	declare @tblLX table
	(dummyid		int	identity(1,1),
	 DBName			varchar(50),
	 TempDBName		varchar(50),
	 ApplicationAbbrv	varchar(20))
	
	insert @tblLX
	(DBName,TempDBName,ApplicationAbbrv)
	select 	DBName,TempDBName,ApplicationAbbrv
	from WIALXSystem..DBNames DB
	where ApplicationAbbrv = 'LX'
	group by DBName,TempDBName,ApplicationAbbrv
	
	set @nloopcontrol = 0
	
	while exists (select 'c' from @tblLX where dummyid > @nloopcontrol)
	  begin
	
		select top 1 @nloopcontrol = dummyid,
			 @sDBName = DBName,
			 @sTempDBName = TempDBName,
			 @sApplicationAbbrv = ApplicationAbbrv
		from @tblLX
		where dummyid > @nloopcontrol
		order by dummyid

IF EXISTS (SELECT * FROM master..sysdatabases WHERE name= @sDBName)
 BEGIN

 
		-- recompile spLXRVGetSummaryAnalyticalReport
    exec('use ' + @sDBName + 
     ' exec(''
/****************************************************
Procedure:  spLXRVGetSummaryAnalyticalReport

Created by: Tarun Verma

Updated: 7/7/2006 to fix calc for # Records w/ Element Present
	7/10/2006 to fix NumOfErrors to exclude counts from records that aren''''t validated & remove ObsNumber

Purpose:  this procedure will return a record set containing column
entries associated with the DEV (data element validation) process associated
with DRVS labor exchange.

Parameter:	
@nParticipantID - this parameter will represent the participant
identifier to return.  If the parameter is zero (0) it is assumed the column
instances for all participants will be returned.

@nUserID - an identifier representing the user executing the stored procedure.

Output:  2 resultsets. (1) Summary/Analytical report numeric data (2) Comments

Example:   
to get one participant :  exec spLXRVGetSummaryAnalyticalReport @pnParticipantID = 9, @pnUserID = 2
to get all participant :  exec spLXRVGetSummaryAnalyticalReport @pnParticipantID = 0, @pnUserID = 7
*****************************************************/

ALTER   PROCEDURE spLXRVGetSummaryAnalyticalReport
@pnParticipantID  int, @pnUserID int
AS

	declare @stateCode varchar(10)
	declare @reportValidatedDate varchar(10)
	declare @numRecordsInvalid int


	select	@stateCode = URO.StateCode,
		@reportValidatedDate = Convert(varchar(10),URO.LastModifiedDate,101)
	From UserReportingOptions URO

	--create temp table #tempDEVSummaryAnalyticalTable
	SELECT 	
		DPxPOG.ParticipantID,
		FRLE.ColumnName,
		DPxPOG.IsValidated,
		DPxFRLE.DEVIndicator,
		case isNull(case FRLE.ColumnName
			when ''''OBSNumber'''' then tL.OBSNumber
			when ''''IndividualIdentifier'''' then tL.IndividualIdentifier
			when ''''DateOfBirth'''' then case isDate(tL.DateOfBirth) 
						  when 1 then replace(convert(char(10),cast(tL.DateOfBirth as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''Gender'''' then tL.Gender
			when ''''ProgramParticipationDate'''' then case isDate(tL.ProgramParticipationDate) 
						  when 1 then replace(convert(char(10),cast(tL.ProgramParticipationDate as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''DisabilityStatus'''' then tL.DisabilityStatus
			when ''''NativeAmerican'''' then tL.NativeAmerican
			when ''''Asian'''' then tL.Asian
			when ''''Black'''' then tL.Black
			when ''''PacificIslander'''' then tL.PacificIslander
			when ''''White'''' then tL.White
			when ''''MultiRace'''' then tL.MultiRace
			when ''''Hispanic'''' then tL.Hispanic
			when ''''VeteranStatus'''' then tL.VeteranStatus
			when ''''VeteranCampaign'''' then tL.VeteranCampaign
			when ''''VeteranDisabled'''' then tL.VeteranDisabled
			when ''''VeteranRecentlySeparated'''' then tL.VeteranRecentlySeparated
			when ''''VeteranHomeless'''' then tL.VeteranHomeless
			when ''''VeteranTransition'''' then tL.VeteranTransition
			when ''''EmploymentStatus'''' then tL.EmploymentStatus
			when ''''HighestGradeCompleted'''' then tL.HighestGradeCompleted
			when ''''SchoolParticipation'''' then tL.SchoolParticipation
			when ''''UCEligibleStatus'''' then tL.UCEligibleStatus
			when ''''MSFW'''' then tL.MSFW
			when ''''Interstate'''' then tL.Interstate
			when ''''DislocationDate'''' then case isDate(tL.DislocationDate) 
						  when 1 then replace(convert(char(10),cast(tL.DislocationDate as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''StaffAssistedServices'''' then case isDate(tL.StaffAssistedServices) 
						  when 1 then replace(convert(char(10),cast(tL.StaffAssistedServices as datetime),101),''''/'''','''''''')
						  else ''''''''
						end 
			when ''''StaffAssistedServicesDVOP'''' then case isDate(tL.StaffAssistedServicesDVOP) 
						  when 1 then replace(convert(char(10),cast(tL.StaffAssistedServicesDVOP as datetime),101),''''/'''','''''''')
						  else ''''''''
						end 
			when ''''StaffAssistedServicesLVER'''' then case isDate(tL.StaffAssistedServicesLVER) 
						  when 1 then replace(convert(char(10),cast(tL.StaffAssistedServicesLVER as datetime),101),''''/'''','''''''')
						  else ''''''''
						end  
			when ''''IntensiveServices'''' then case isDate(tL.IntensiveServices) 
						  when 1 then replace(convert(char(10),cast(tL.IntensiveServices as datetime),101),''''/'''','''''''')
						  else ''''''''
						end   
			when ''''IntensiveServicesDVOP'''' then case isDate(tL.IntensiveServicesDVOP) 
						  when 1 then replace(convert(char(10),cast(tL.IntensiveServicesDVOP as datetime),101),''''/'''','''''''')
						  else ''''''''
						end    
			when ''''IntensiveServicesLVER'''' then case isDate(tL.IntensiveServicesLVER) 
						  when 1 then replace(convert(char(10),cast(tL.IntensiveServicesLVER as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''CareerGuidance'''' then case isDate(tL.CareerGuidance) 
						  when 1 then replace(convert(char(10),cast(tL.CareerGuidance as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''CareerGuidanceDVOP'''' then case isDate(tL.CareerGuidanceDVOP) 
						  when 1 then replace(convert(char(10),cast(tL.CareerGuidanceDVOP as datetime),101),''''/'''','''''''')
						  else ''''''''
						end 
			when ''''CareerGuidanceLVER'''' then case isDate(tL.CareerGuidanceLVER) 
						  when 1 then replace(convert(char(10),cast(tL.CareerGuidanceLVER as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''SelfServiceWorkforce'''' then case isDate(tL.SelfServiceWorkforce) 
						  when 1 then replace(convert(char(10),cast(tL.SelfServiceWorkforce as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''StaffAssistedWorkforce'''' then case isDate(tL.StaffAssistedWorkforce) 
						  when 1 then replace(convert(char(10),cast(tL.StaffAssistedWorkforce as datetime),101),''''/'''','''''''')
						  else ''''''''
						end 
			when ''''TAPEEmploymentDVOP'''' then case isDate(tL.TAPEEmploymentDVOP) 
						  when 1 then replace(convert(char(10),cast(tL.TAPEEmploymentDVOP as datetime),101),''''/'''','''''''')
						  else ''''''''
						end 
			when ''''TAPEmploymentLVER'''' then case isDate(tL.TAPEmploymentLVER) 
						  when 1 then replace(convert(char(10),cast(tL.TAPEmploymentLVER as datetime),101),''''/'''','''''''')
						  else ''''''''
						end 
			when ''''JobSearch'''' then case isDate(tL.JobSearch) 
						  when 1 then replace(convert(char(10),cast(tL.JobSearch as datetime),101),''''/'''','''''''')
						  else ''''''''
						end 
			when ''''JobSearchDVOP'''' then case isDate(tL.JobSearchDVOP) 
						  when 1 then replace(convert(char(10),cast(tL.JobSearchDVOP as datetime),101),''''/'''','''''''')
						  else ''''''''
						end 
			when ''''JobSearchLVER'''' then case isDate(tL.JobSearchLVER) 
						  when 1 then replace(convert(char(10),cast(tL.JobSearchLVER as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''WIAServices'''' then case isDate(tL.WIAServices) 
						  when 1 then replace(convert(char(10),cast(tL.WIAServices as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''ReferredEmployment'''' then case isDate(tL.ReferredEmployment) 
						  when 1 then replace(convert(char(10),cast(tL.ReferredEmployment as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''ReferredEmploymentDVOP'''' then case isDate(tL.ReferredEmploymentDVOP) 
						  when 1 then replace(convert(char(10),cast(tL.ReferredEmploymentDVOP as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''ReferredEmploymentLVER'''' then case isDate(tL.ReferredEmploymentLVER) 
						  when 1 then replace(convert(char(10),cast(tL.ReferredEmploymentLVER as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''FederalTraining'''' then case isDate(tL.FederalTraining) 
						  when 1 then replace(convert(char(10),cast(tL.FederalTraining as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''FederalTrainingDVOP'''' then case isDate(tL.FederalTrainingDVOP) 
						  when 1 then replace(convert(char(10),cast(tL.FederalTrainingDVOP as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''FederalTrainingLVER'''' then case isDate(tL.FederalTrainingLVER) 
						  when 1 then replace(convert(char(10),cast(tL.FederalTrainingDVOP as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''PlaceFedTraining'''' then case isDate(tL.PlaceFedTraining) 
						  when 1 then replace(convert(char(10),cast(tL.PlaceFedTraining as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''PlaceFedTrainingDVOP'''' then case isDate(tL.PlaceFedTrainingDVOP) 
						  when 1 then replace(convert(char(10),cast(tL.PlaceFedTrainingDVOP as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''PlaceFedTrainingLVER'''' then case isDate(tL.PlaceFedTrainingLVER) 
						  when 1 then replace(convert(char(10),cast(tL.PlaceFedTrainingLVER as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''ReferredFederalJob'''' then case isDate(tL.ReferredFederalJob) 
						  when 1 then replace(convert(char(10),cast(tL.ReferredFederalJob as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''ReferredFederalJobDVOP'''' then case isDate(tL.ReferredFederalJobDVOP) 
						  when 1 then replace(convert(char(10),cast(tL.ReferredFederalJobDVOP as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''ReferredFederalJobLVER'''' then case isDate(tL.ReferredFederalJobLVER) 
						  when 1 then replace(convert(char(10),cast(tL.ReferredFederalJobLVER as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''FedJobEntered'''' then case isDate(tL.FedJobEntered) 
						  when 1 then replace(convert(char(10),cast(tL.FedJobEntered as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''FedJobEnteredDVOP'''' then case isDate(tL.FedJobEnteredDVOP) 
						  when 1 then replace(convert(char(10),cast(tL.FedJobEnteredDVOP as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''FedJobEnteredLVER'''' then case isDate(tL.FedJobEnteredLVER) 
						  when 1 then replace(convert(char(10),cast(tL.FedJobEnteredLVER as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''ReferFedContractorJob'''' then case isDate(tL.ReferFedContractorJob) 
						  when 1 then replace(convert(char(10),cast(tL.ReferFedContractorJob as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''ReferFedContractorJobDVOP'''' then case isDate(tL.ReferFedContractorJobDVOP) 
						  when 1 then replace(convert(char(10),cast(tL.ReferFedContractorJobDVOP as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''ReferFedContractorJobLVER'''' then case isDate(tL.ReferFedContractorJobLVER) 
						  when 1 then replace(convert(char(10),cast(tL.ReferFedContractorJobLVER as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''EnterFedContractorJob'''' then case isDate(tL.EnterFedContractorJob) 
						  when 1 then replace(convert(char(10),cast(tL.EnterFedContractorJob as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''EnterFedContractorJobDVOP'''' then case isDate(tL.EnterFedContractorJobDVOP) 
						  when 1 then replace(convert(char(10),cast(tL.EnterFedContractorJobDVOP as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''EnterFedContractorJobLVER'''' then case isDate(tL.EnterFedContractorJobLVER) 
						  when 1 then replace(convert(char(10),cast(tL.EnterFedContractorJobLVER as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''ProgramExitDate'''' then case isDate(tL.ProgramExitDate) 
						  when 1 then replace(convert(char(10),cast(tL.ProgramExitDate as datetime),101),''''/'''','''''''')
						  else ''''''''
						end
			when ''''OtherExitReasons'''' then tL.OtherExitReasons
			when ''''ExitEmployed1'''' then tL.ExitEmployed1
			when ''''ExitEmployedMatch1'''' then tL.ExitEmployedMatch1
			when ''''ExitEmployed2'''' then tL.ExitEmployed2
			when ''''ExitEmployedMatch2'''' then tL.ExitEmployedMatch2
			when ''''ExitEmployed3'''' then tL.ExitEmployed3
			when ''''ExitEmployedMatch3'''' then tL.ExitEmployedMatch3
			when ''''PriorWages3'''' then tL.PriorWages3
			when ''''PriorWages2'''' then tL.PriorWages2
			when ''''ExitWages1'''' then tL.ExitWages1
			when ''''ExitWages2'''' then tL.ExitWages2
			when ''''ExitWages3'''' then tL.ExitWages3
			when ''''WIBName'''' then tL.WIBName
			when ''''OfficeName'''' then tL.OfficeName
			when ''''CaseManager'''' then tL.CaseManager
			when ''''UserField1'''' then tL.UserField1
			when ''''UserField2'''' then tL.UserField2
			end,'''''''') when '''''''' then 0 else 1 end As NumWithElementsPresent,
		FRLE.SequenceNumber
	into #tempDEVSummaryAnalyticalTable1
	FROM DEVReport DR (NOLOCK)
	INNER JOIN UserReportingOptions URO (NOLOCK)
	ON DR.ProgramYearID = URO.ProgramYearID
	INNER JOIN DEVParticipantXPerformanceOutcomeGroup DPxPOG (NOLOCK)
	ON DR.DEVReportID = DPxPOG.DEVReportID
	INNER JOIN DEVParticipantxFileRecordLayoutElement DPxFRLE (NOLOCK)
	ON DPxPOG.DEVParticipantXPerformanceOutcomeGroupID = DPxFRLE.DEVParticipantXPerformanceOutcomeGroupID
	--INNER JOIN DEVReportxFileRecordLayoutElement DRxFRLE (NOLOCK)
	--ON DPxFRLE.FileRecordLayoutElementID = DRxFRLE.FileRecordLayoutElementID
	INNER JOIN ' + @sTempDBName + '..tmpFileUpload_LX tL
	on DPxPOG.ParticipantID = tL.RecordID
	INNER JOIN WIALXSystem.dbo.FileRecordLayoutElement FRLE (NOLOCK)
	ON DPxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
	-- remove the "filter" elements from the resultset
	where FRLE.ColumnName NOT IN (''''OBSNumber'''',''''WIBName'''',''''OfficeName'''', ''''CaseManager'''', ''''UserField1'''', ''''UserField2'''')

	ORDER BY SequenceNumber

	-- Create temp table and calculate Summary/Analytical data
	select	@stateCode As StateCode,
		@reportValidatedDate As ReportValidatedDate,
		count(DEVIndicator) As NumRecordsSampled,
		sum(convert(integer, IsValidated)) As NumRecordsValidated,
		sum(Case when ((IsValidated = 1) and (DEVIndicator = 0)) then 1 else 0 end) As NumRecordsInvalid,
		(SequenceNumber - 1000) As ElementNum,
		ColumnName As DataElement,
		sum(NumWithElementsPresent) As NumWithElementsPresent,
		sum(case when IsValidated = 1 and DEVIndicator = 0 then 1 else 0 end) As NumOfErrors
	into #tempDEVSummaryAnalyticalTable2
	from #tempDEVSummaryAnalyticalTable1	
	group by SequenceNumber, ColumnName
	order by SequenceNumber

	select @numRecordsInvalid = max(NumRecordsInvalid)
	from #tempDEVSummaryAnalyticalTable2

	select	StateCode,
		ReportValidatedDate,
		NumRecordsSampled,
		NumRecordsValidated,
		@numRecordsInvalid As NumRecordsInvalid,
		ElementNum,
		DataElement,
		NumWithElementsPresent,
		NumOfErrors
	from #tempDEVSummaryAnalyticalTable2

	-- Display report comment
	SELECT 	DISTINCT
		Comment
	FROM DEVReport DR (NOLOCK)
	INNER JOIN UserReportingOptions URO (NOLOCK)
	ON DR.ProgramYearID = URO.ProgramYearID

	-- Drop temp tables
	drop table #tempDEVSummaryAnalyticalTable1
	drop table #tempDEVSummaryAnalyticalTable2

'')')

	-- recompile spGetLXXMLExtract
    exec('use ' + @sDBName + 
     ' exec(''
-- spGetLXXMLExtract ''''DEV'''', 2
-- spGetLXXMLExtract ''''RV'''', 2
-- spGetLXXMLExtract ''''Both'''', 2

ALTER   PROCEDURE spGetLXXMLExtract
      --		@pcApplAbbrv	varchar(5),
		@pcExtractType	varchar(10),
		@pnUserID int
AS
BEGIN

	DECLARE @StCode varchar(5)
	DECLARE @ProgYr varchar(10)
	DECLARE @SubStDate varchar(20)
	DECLARE @SubEndDate varchar(20)
	DECLARE @SubDueDate varchar(20)
	DECLARE @RptDescription varchar(500)
	DECLARE @strComments varchar(1500)
	DECLARE @blnBoth bit
	DECLARE @isWageUser bit

	SELECT @isWageUser = isWageUser
	FROM	  WIAnLXData..Users
	WHERE  UserID = @pnUserID

	IF UPPER(@pcExtractType) = ''''BOTH'''' 
		SET @blnBoth = 1
	ELSE 
		SET @blnBoth = 0
	
	SELECT    @StCode = uro.StateCode, @ProgYr = right(C.CodeAbbrv,4), 
			@SubStDate = RQ.QuarterStartMonthDay + ''''/'''' +  convert(varchar(50),convert(int,right(C.CodeAbbrv, 4)) +1),
			@SubEndDate = RQ.QuarterEndMonthDay + ''''/'''' +  convert(varchar(50),convert(int,right(C.CodeAbbrv, 4)) +1),
			@SubDueDate = RQ.ReportQuarterDueDate + ''''/'''' +  convert(varchar(50),convert(int,right(C.CodeAbbrv, 4)) +1)
	FROM		UserReportingOptions uro
	INNER JOIN Code C
	ON uro.ProgramYearID = C.CodeID
	AND	C.CodeGroup LIKE ''''ProgramYear%''''
	INNER JOIN ReportQuarter RQ
	ON	uro.ReportQtrDueID = RQ.ReportQuarterID

	IF (UPPER(@pcExtractType) = ''''DEV'''') OR (@blnBoth = 1)
	Begin

		DECLARE @SampledCases int
		DECLARE @ValidatedCases int

		SELECT @strComments = isnull(DR.Comment,''''''''), @RptDescription = ''''Summary Analytical''''
		FROM	  UserReportingOptions URO
		INNER JOIN DEVReport DR
		ON URO.ProgramYearID = DR.ProgramYearID

		SELECT @SampledCases = Count(*)
		FROM	  DEVParticipantXPerformanceOutcomeGroup

		SELECT @ValidatedCases = Count(*)
		FROM	  DEVParticipantXPerformanceOutcomeGroup
		WHERE  IsValidated = 1	
	
		DECLARE @tblColName	TABLE(ColName varchar(50))

		IF @isWageUser = 1
			Begin
				DELETE FROM @tblColName

				INSERT INTO @tblColName(ColName)
				VALUES(''''OBSNumber'''')
			End
		ELSE
			Begin
				DELETE FROM @tblColName

				INSERT INTO @tblColName(ColName)
				VALUES(''''OBSNumber'''')

				INSERT INTO @tblColName(ColName)
				SELECT Distinct ColumnName
				FROM	  FileRecordLayoutElement
				WHERE  ColumnName LIKE ''''%Wage%''''
				AND	  SequenceNumber > 1000
			End

		DECLARE @tblDEV TABLE(DataElement	varchar(50), DataElementNumber int, NumbertoValidate int, NumberOfErrors int)
		
		INSERT INTO @tblDEV(DataElement, DataElementNumber, NumbertoValidate, NumberOfErrors)
		SELECT 	isnull(FRLE.ColumnName,''''''''), isnull(FRLE.SequenceNumber - 1000,0), 
				isnull(sum(case DPxFRLE.DEVIndicator when -1 then 1 else 0 end),0)  as NumbertoValidate, 
				isnull(sum(case DPxFRLE.DEVIndicator when 0 then 1 else 0 end),0) as NumberOfErrors
		FROM		 UserReportingOptions URO
		INNER JOIN DEVReport DR
		ON		 URO.ProgramYearID = DR.ProgramYearID
		INNER JOIN DEVParticipantXPerformanceOutcomeGroup DPxPOG
		ON		 DR.DEVReportID = DPxPOG.DEVReportID
		INNER JOIN DEVParticipantxFileRecordLayoutElement DPxFRLE
		ON		 DPxFRLE.DEVParticipantXPerformanceOutcomeGroupID = DPxPOG.DEVParticipantXPerformanceOutcomeGroupID
		INNER JOIN FileRecordLayoutElement FRLE
		ON		 DPxFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
		WHERE 	 FRLE.ColumnName NOT IN (SELECT Colname FROM @tblColName)
		GROUP BY FRLE.SequenceNumber, FRLE.ColumnName
		ORDER BY 	 FRLE.SequenceNumber

		IF @@RowCount <> 0
		Begin
			SELECT	@StCode as StateCode, ''''LX'''' as ProgramDescription, @ProgYr as ProgramYear, 
					@SubStDate as SubmissionStartDate, @SubEndDate as SubmissionEndDate, @SubDueDate as SubmissionDueDate, 
					isNull(@RptDescription,'''''''') as ReportDescription, ''''DEV'''' as ValidationType, @strComments as Comments,
					@SampledCases as SampledCases, @ValidatedCases as ValidatedCases, '''''''' as InvalidRecords, '''''''' as WrongSSN, DataElement, DataElementNumber,
					NumbertoValidate, NumberOfErrors, '''''''' as OverAllErrorRate, '''''''' as ReportedErrorRate, '''''''' as Significance
			FROM @tblDEV

--			RETURN
		End
		ELSE
		Begin
			SELECT	@StCode as StateCode, ''''LX'''' as ProgramDescription, @ProgYr as ProgramYear, 
					@SubStDate as SubmissionStartDate, @SubEndDate as SubmissionEndDate, @SubDueDate as SubmissionDueDate, 
					isnull(@RptDescription,'''''''') as ReportDescription, ''''DEV'''' as ValidationType, @strComments as Comments,
					@SampledCases as SampledCases, @ValidatedCases as ValidatedCases, '''''''' as InvalidRecords, '''''''' as WrongSSN, DataElement, DataElementNumber,
					NumbertoValidate, NumberOfErrors, '''''''' as OverAllErrorRate, '''''''' as ReportedErrorRate, '''''''' as Significance
			FROM @tblDEV
--			RETURN
		End

	End
	
	IF (UPPER(@pcExtractType) = ''''RV'''') OR (@blnBoth = 1)
	Begin

		DECLARE @ProgYrID int
		DECLARE @nLoopControl int
		DECLARE @nFileRecordLayoutID int
		
		SELECT @ProgYrID = ProgramYearID
		FROM	  UserReportingOptions 
/*		
		SELECT @strComments = isnull(RVR.Comment,''''''''), @RptDescription = isnull(RVR.RVReportName,'''''''')
		FROM	  RVReport RVR
		WHERE  RVR.ProgramYearID = @ProgYrID
*/
		CREATE TABLE #tblRV(MeasurementCode varchar(30), MeasurementDescription varchar(175), ValidationValue int, ReportedValue int, [Difference] int, ErrorRate varchar(20))

		SET @nLoopControl = 0

		DECLARE @tblFRL TABLE (DummyID int identity(1,1), FileRecordLayoutID int, CodeAbbrv varchar(50))
		DECLARE @LXGroup varchar(100)

		SELECT @LXGroup = c.CodeName
		FROM UserReportingOptions uro
		INNER JOIN Code c
		ON uro.LXGroupID = c.CodeID

		IF CHARINDEX(''''A-D'''', @LXGroup) > 0
		Begin
			INSERT INTO @tblFRL(FileRecordLayoutID, CodeAbbrv)
			SELECT CodeID, CodeAbbrv
			FROM Code 
			WHERE CodeGroup LIKE ''''FileRecordLayoutType%''''
			AND (CHARINDEX(''''LX'''', CodeAbbrv) > 0) 
			AND (CHARINDEX(''''RV'''', CodeAbbrv) > 0)
			AND (CHARINDEX(''''9002E'''', CodeAbbrv) = 0)
		End
		ELSE
			IF CHARINDEX(''''9002 E'''', @LXGroup) > 0
			Begin
				INSERT INTO @tblFRL(FileRecordLayoutID, CodeAbbrv)
				SELECT CodeID, CodeAbbrv
				FROM Code 
				WHERE CodeGroup LIKE ''''FileRecordLayoutType%''''
				AND (CHARINDEX(''''LX'''', CodeAbbrv) > 0) 
				AND (CHARINDEX(''''RV'''', CodeAbbrv) > 0)
				AND (CHARINDEX(''''9002E'''', CodeAbbrv) > 0)
			End
		

		WHILE EXISTS (SELECT ''''c'''' FROM @tblFRL WHERE DummyID > @nLoopControl)
		Begin

			SELECT TOP 1   @nLoopControl = frl.DummyID,
						@nFileRecordLayoutID = frl.FileRecordLayoutID
			FROM @tblFRL frl
			WHERE DummyID > @nLoopControl

			SELECT TOP 1   @strComments = isnull(Comment,'''''''') 
			FROM RVReport
			WHERE ProgramYearID = @ProgYrID
			AND FileRecordLayoutID = @nFileRecordLayoutID

			select 	@RptDescription = case FRL.CodeAbbrv
								when ''''LX 9002A RV'''' then ''''ETA9002A - Services to Job Seekers''''
								when ''''LX 9002B RV'''' then ''''ETA9002B - Services to Veterans''''
								when ''''LX 9002C RV'''' then ''''ETA9002C - Performance Outcomes - Job Seekers''''
								when ''''LX 9002D RV'''' then ''''ETA9002D - Performance Outcomes - Veterans''''
								when ''''LX 9002E RV'''' then ''''ETA9002E - Job Openings Received''''
								when ''''LX VETS200A RV'''' then ''''Vets-200(A) DVOP Quarterly Report''''
								when ''''LX VETS200B RV'''' then ''''Vets-200(B) LVER Quarterly Report''''
								when ''''LX VETS200C RV'''' then''''Vets-200(C) DVOP/LVER Quarterly Report''''
								else ''''''''
							  end	
			from @tblFRL FRL
			where FRL.FileRecordLayoutID = @nFileRecordLayoutID

			INSERT INTO #tblRV(MeasurementCode, MeasurementDescription, ValidationValue, ReportedValue, [Difference], ErrorRate)
			EXEC spLXRVGetData @nFileRecordLayoutID

			SELECT	@StCode as StateCode, ''''LX'''' as ProgramDescription, @ProgYr as ProgramYear, 
					@SubStDate as SubmissionStartDate, @SubEndDate as SubmissionEndDate, @SubDueDate as SubmissionDueDate, 
					isNull(@RptDescription,'''''''') as ReportDescription, ''''RV'''' as ValidationType, @strComments as Comments,
					MeasurementCode, MeasurementDescription, ValidationValue, ReportedValue, [Difference], ErrorRate as PercentDifference
			FROM 	#tblRV

			DELETE FROM #tblRV
		End
		DROP TABLE #tblRV

	End

END

'')')

END

end





---------------------------------------------------------------------------------------------------------
------------------******************************************************---------------------------------
---------------------------------------------------------------------------------------------------------



USE WIALXSystem 
GO
------------------------------------------------------------------
-------------------- PY 2010 Option ------------------------------
------------------------------------------------------------------
------------------------------------------------------------------
------------- Script only runs if PY2010 is NOT in DB ------------
------------------------------------------------------------------
if not exists( select 'c' 
                 from  code
                where CodeGroup  = 'ProgramYear'
                  and CodeAbbrv  = 'PY2010'
             )
begin  ------------- Script only runs if PY2010 is NOT in DB ------------



----------------------------------------
-- softcode 1002 to year_id_for_2010_1002
----------------------------------------
DECLARE @year_id_for_2010_1002 int
----------------------------------------

----------------------- insert 2010 -------------------------------------------
if not exists( select 'c' 
                 from  code
                where CodeGroup  = 'ProgramYear'
                  and CodeAbbrv  = 'PY2010'
             )
begin
    insert into code 
           ( CodeGroup     , CodeAbbrv , CodeName  , ColumnName , SortOrder , LastModifiedDate )
    values ( 'ProgramYear' , 'PY2010'  , 'PY 2010' , 'NULL'     , '8'       , getdate() )
    SET @year_id_for_2010_1002 = @@identity
end


    ------------------------------------------------------------------------------------------------------
    ---- Add Exit Quarter Ranges for PY 2010
    ------------------------------------------------------------------------------------------------------
    INSERT INTO LXDB.dbo.ExitQuarterRange
              ( ExitQuarterAbbrv , ReportQuarter , ProgramYearID 
              , CalculationSetID , ExitStartDate , ExitEndDate     ,LastModifiedDate )
         SELECT ExitQuarterAbbrv , ReportQuarter , @year_id_for_2010_1002 
              , CalculationSetID , DATEADD(MONTH, 12,ExitStartDate) , DATEADD(MONTH, 12,ExitEndDate)     , getdate()
           FROM LXDB.dbo.ExitQuarterRange EQR
                INNER JOIN WIALXSYSTEM.dbo.Code C
                ON EQR.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2009' 
           
    INSERT INTO WIADB.dbo.ExitQuarterRange
              ( ExitQuarterAbbrv , ReportQuarter , ProgramYearID 
              , CalculationSetID , ExitStartDate , ExitEndDate     ,LastModifiedDate )
         SELECT ExitQuarterAbbrv , ReportQuarter , @year_id_for_2010_1002 
              , CalculationSetID , DATEADD(MONTH, 12,ExitStartDate) , DATEADD(MONTH, 12,ExitEndDate)     , getdate()
           FROM WIADB.dbo.ExitQuarterRange EQR
                INNER JOIN WIALXSYSTEM.dbo.Code C
                ON EQR.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2009' 
        

------------------------------------------------------------------------------------------------------
---- Add Program Year Ranges for PY 2010
---- Add Program Year Range X Metric Type     for     Program Year Ranges for PY 2010
------------------------------------------------------------------------------------------------------

DECLARE  @LXDB_PYR_ProgramYearRangeId  int, @LXDB_PYR_RangeTypeID  int, @LXDB_PYR_CohortID  int, @LXDB_PYR_LXGroupID            int, @LXDB_PYR_CalculationSetID  int,  @LXDB_PYR_ProgramYearID  int, @LXDB_PYR_QuarterPeriod  int, @LXDB_PYR_ProgramStartDate  smalldatetime, @LXDB_PYR_ProgramEndDate  smalldatetime, @LXDB_PYR_LastModifiedDate  datetime
DECLARE  @WIADB_PYR_ProgramYearRangeId int, @WIADB_PYR_RangeTypeID int, @WIADB_PYR_CohortID int, @WIADB_PYR_CumulativeIndicator int, @WIADB_PYR_CalculationSetID int,  @WIADB_PYR_ProgramYearID int, @WIADB_PYR_QuarterPeriod int, @WIADB_PYR_ProgramStartDate smalldatetime, @WIADB_PYR_ProgramEndDate smalldatetime, @WIADB_PYR_LastModifiedDate datetime
--
DECLARE  @old_LXDB_PYR_ProgramYearRangeID  int, @new_LXDB_PYR_ProgramYearRangeID  int
DECLARE  @old_WIADB_PYR_ProgramYearRangeID int, @new_WIADB_PYR_ProgramYearRangeID int
--
--
declare cursor_LXDB_dbo_ProgramYearRange   cursor for
         SELECT ProgramYearRangeID , RangeTypeID , CohortID , LXGroupID            , CalculationSetID , @year_id_for_2010_1002 , QuarterPeriod , DATEADD(MONTH, 12, ProgramStartDate) , DATEADD(MONTH, 12, ProgramEndDate ) , getdate() 
           FROM LXDB.dbo.ProgramYearRange PYR
           INNER JOIN WIALXSYSTEM.dbo.Code C
           ON PYR.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2009' 
          
--
declare cursor_WIADB_dbo_ProgramYearRange cursor for
         SELECT ProgramYearRangeID , RangeTypeID , CohortID , CumulativeIndicator  , CalculationSetID , @year_id_for_2010_1002 , QuarterPeriod , DATEADD(MONTH, 12, ProgramStartDate) , DATEADD(MONTH, 12, ProgramEndDate ) , getdate() 
           FROM WIADB.dbo.ProgramYearRange PYR1
           INNER JOIN WIALXSYSTEM.dbo.Code C
           ON PYR1.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2009' 
          
--
--
OPEN  cursor_LXDB_dbo_ProgramYearRange   
FETCH cursor_LXDB_dbo_ProgramYearRange   INTO  @LXDB_PYR_ProgramYearRangeID , @LXDB_PYR_RangeTypeID  , @LXDB_PYR_CohortID  , @LXDB_PYR_LXGroupID            , @LXDB_PYR_CalculationSetID  ,  @LXDB_PYR_ProgramYearID  , @LXDB_PYR_QuarterPeriod  , @LXDB_PYR_ProgramStartDate  , @LXDB_PYR_ProgramEndDate  , @LXDB_PYR_LastModifiedDate
WHILE @@fetch_status=0
BEGIN
--
    INSERT INTO LXDB.dbo.ProgramYearRange
                ( RangeTypeID           , CohortID            , LXGroupID                      , CalculationSetID            ,  ProgramYearID            ,  QuarterPeriod           , ProgramStartDate            , ProgramEndDate            , LastModifiedDate           )   
         VALUES ( @LXDB_PYR_RangeTypeID , @LXDB_PYR_CohortID  , @LXDB_PYR_LXGroupID            , @LXDB_PYR_CalculationSetID  ,  @LXDB_PYR_ProgramYearID  , @LXDB_PYR_QuarterPeriod  , @LXDB_PYR_ProgramStartDate  , @LXDB_PYR_ProgramEndDate  , @LXDB_PYR_LastModifiedDate  )
    SET     @new_LXDB_PYR_ProgramYearRangeID = @@identity
    SET     @old_LXDB_PYR_ProgramYearRangeID = @LXDB_PYR_ProgramYearRangeId
    -------
    INSERT INTO LXDB.dbo.ProgramYearRangeXMetricType
                (  ProgramYearRangeID               , MetricTypeID , LastModifiedDate )
          SELECT   @new_LXDB_PYR_ProgramYearRangeID , MetricTypeID , GetDate()  
            FROM LXDB.dbo.ProgramYearRangeXMetricType
           WHERE ProgramYearRangeID = @old_LXDB_PYR_ProgramYearRangeID
    --
    FETCH cursor_LXDB_dbo_ProgramYearRange   INTO  @LXDB_PYR_ProgramYearRangeID , @LXDB_PYR_RangeTypeID  , @LXDB_PYR_CohortID  , @LXDB_PYR_LXGroupID            , @LXDB_PYR_CalculationSetID  ,  @LXDB_PYR_ProgramYearID  , @LXDB_PYR_QuarterPeriod  , @LXDB_PYR_ProgramStartDate  , @LXDB_PYR_ProgramEndDate  , @LXDB_PYR_LastModifiedDate
END 
--
--
OPEN  cursor_WIADB_dbo_ProgramYearRange 
FETCH cursor_WIADB_dbo_ProgramYearRange  INTO   @WIADB_PYR_ProgramYearRangeID , @WIADB_PYR_RangeTypeID , @WIADB_PYR_CohortID , @WIADB_PYR_CumulativeIndicator , @WIADB_PYR_CalculationSetID ,  @WIADB_PYR_ProgramYearID , @WIADB_PYR_QuarterPeriod , @WIADB_PYR_ProgramStartDate , @WIADB_PYR_ProgramEndDate , @WIADB_PYR_LastModifiedDate
WHILE @@fetch_status=0
BEGIN
--
    INSERT INTO WIADB.dbo.ProgramYearRange
                ( RangeTypeID            , CohortID            , CumulativeIndicator            , CalculationSetID            ,  ProgramYearID            , QuarterPeriod            , ProgramStartDate            , ProgramEndDate            , LastModifiedDate            )
         VALUES ( @WIADB_PYR_RangeTypeID , @WIADB_PYR_CohortID , @WIADB_PYR_CumulativeIndicator , @WIADB_PYR_CalculationSetID ,  @WIADB_PYR_ProgramYearID , @WIADB_PYR_QuarterPeriod , @WIADB_PYR_ProgramStartDate , @WIADB_PYR_ProgramEndDate , @WIADB_PYR_LastModifiedDate )
    SET     @new_WIADB_PYR_ProgramYearRangeID = @@identity
    SET     @old_WIADB_PYR_ProgramYearRangeID = @WIADB_PYR_ProgramYearRangeID 
    -------
    INSERT INTO WIADB.dbo.ProgramYearRangeXMetricType
                (  ProgramYearRangeID               , MetricTypeID , LastModifiedDate )
          SELECT   @new_WIADB_PYR_ProgramYearRangeID , MetricTypeID , GetDate()  
            FROM WIADB.dbo.ProgramYearRangeXMetricType
           WHERE ProgramYearRangeID = @old_WIADB_PYR_ProgramYearRangeID
    --
    FETCH cursor_WIADB_dbo_ProgramYearRange  INTO   @WIADB_PYR_ProgramYearRangeID , @WIADB_PYR_RangeTypeID , @WIADB_PYR_CohortID , @WIADB_PYR_CumulativeIndicator , @WIADB_PYR_CalculationSetID ,  @WIADB_PYR_ProgramYearID , @WIADB_PYR_QuarterPeriod , @WIADB_PYR_ProgramStartDate , @WIADB_PYR_ProgramEndDate , @WIADB_PYR_LastModifiedDate
END 
------------
------------
DEALLOCATE cursor_LXDB_dbo_ProgramYearRange
DEALLOCATE cursor_WIADB_dbo_ProgramYearRange

----------------------------------------
-- PerformanceOutcomeGroupxProgramYear 
----------------------------------------
if not exists(select 'c' from  PerformanceOutcomeGroupxProgramYear where ProgramYearID = @year_id_for_2010_1002)
begin
    insert  PerformanceOutcomeGroupxProgramYear 
          select PerformanceOutcomeGroupID, @year_id_for_2010_1002,getdate()
           from  PerformanceOutcomeGroupxProgramYear POGxPY
           INNER JOIN WIALXSYSTEM.dbo.Code C
           ON POGxPY.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2009' 
         
end



----------------------------------------
--MetricTypexProgramYear
----------------------------------------
if not exists(select 'c' from  MetricTypexProgramYear where ProgramYearID = @year_id_for_2010_1002)
begin
    insert  MetricTypexProgramYear 
          select MetricTypeID, @year_id_for_2010_1002,getdate()
           from  MetricTypexProgramYear MTxPY
           INNER JOIN WIALXSYSTEM.dbo.Code C
           ON MTxPY.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2009' 
         
end


--------------------------------------------
-- 1st Cursor
--------------------------------------------
declare @x_FileRecordLayoutID int,@x_FileRecordLayoutTypeID int, @x_SystemID int, @x_ProgramYearID int,
    @x_PostingDate smalldatetime,@old_id int,@NEW_filerecordlayoutelement_id int,@old_FileRecordLayoutElementID int

declare @FileRecordLayoutElementID int,@FileRecordLayoutID int,@DataFormatTypeID int,@ColumnName varchar(500),
    @DisplayName varchar(500),@Description varchar(3000),@CodeGroup varchar(100),@CodeAbbrv varchar(50),
    @ColumnLength smallint,    @StartPosition smallint,@EndPosition smallint,@SequenceNumber smallint,
    @LastModifiedDate datetime


declare @var_count int
declare @new_FileRecordLayoutElementId int
declare @var_frle_identity int
declare @old_DevColumn_DevcolumnId int
declare @new_DevColumn_DevcolumnId int

DECLARE  cursor_FileRecordLayout cursor FOR SELECT  FileRecordLayoutID, FileRecordLayoutTypeID, SystemID, ProgramYearID, PostingDate FROM wialxsystem.dbo.FileRecordLayout FRL  INNER JOIN WIALXSYSTEM.dbo.Code C
           ON FRL.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2009' 

open cursor_FileRecordLayout
fetch next from cursor_FileRecordLayout into 
 @x_FileRecordLayoutID ,
 @x_FileRecordLayoutTypeID ,
 @x_SystemID ,
 @x_ProgramYearID ,
 @x_PostingDate 

while @@fetch_status=0
begin
     
SET @old_id = @x_FileRecordLayoutID
insert into FileRecordLayout (FileRecordLayoutTypeID,SystemID,ProgramYearID,PostingDate)
    values(@x_FileRecordLayoutTypeID,@x_SystemID,@year_id_for_2010_1002,getdate())
--
SET @NEW_filerecordlayoutelement_id = @@identity
        ----------------------------------------
        --second cursor here
        ----------------------------------------
        DECLARE  cursor_FileRecordLayoutElement cursor FOR 
            SELECT  FileRecordLayoutElementID,DataFormatTypeID,ColumnName,DisplayName,
                    [Description],CodeGroup,CodeAbbrv,ColumnLength,
                    StartPosition ,EndPosition,SequenceNumber
              FROM wialxsystem.dbo.FileRecordLayoutElement
             where FileRecordLayoutID= @x_FileRecordLayoutID
        
            open cursor_FileRecordLayoutElement
        fetch next 
              from cursor_FileRecordLayoutElement 
              into @FileRecordLayoutElementID,@DataFormatTypeID,@ColumnName,@DisplayName,
                   @Description,@CodeGroup,@CodeAbbrv,@ColumnLength,
                   @StartPosition ,@EndPosition,@SequenceNumber
                     
       
        while @@fetch_status=0
        begin
          
            insert into FileRecordLayoutElement 
                      ( FileRecordLayoutID              , DataFormatTypeID  , ColumnName  , DisplayName  , [Description] , CodeGroup , CodeAbbrv   , ColumnLength   , StartPosition  , EndPosition  , SequenceNumber , LastModifiedDate )
                values( @NEW_filerecordlayoutelement_id , @DataFormatTypeID , @ColumnName , @DisplayName , @Description  , @CodeGroup , @CodeAbbrv , @ColumnLength  , @StartPosition , @EndPosition , @SequenceNumber     , getdate()        )
            set   @new_FileRecordLayoutElementId = @@identity
            set   @old_FileRecordLayoutElementID = @FileRecordLayoutElementID 
            -----------------------------------------------------------------------------------------
            --cursor 3------------------------------------------------------------------------------
            -----------------------------------------------------------------------------------------
            declare cursor_DevColumn cursor FOR
            select devColumnId , ProgramYearID , FundingStreamTypeID,ServiceTypeID
                 , FileRecordLayoutElementID , InsertSQL ,  PositiveSQL   
                 , IsCorrectable  , SequenceNumber
              from dbo.DevColumn
             where FileRecordLayoutElementID = @old_FileRecordLayoutElementID    
            open cursor_DevColumn
            -----------------------------------------------------------------------------------------
            declare @old_frle_devColumnId                 int --new
            declare @old_frle_ProgramYearID               int
            declare @old_frle_FundingStreamTypeID         int
            declare @old_frle_ServiceTypeID               int
            declare @old_frle_FileRecordLayoutElementID   int
            declare @old_frle_InsertSQL                   varchar(3500)
            declare @old_frle_PositiveSQL                 varchar(4000)
            declare @old_frle_IsCorrectable               bit
            declare @old_frle_SequenceNumber              int    
            -------------------------------------
            ------ two columns will change
            -------------------------------------
            declare @NEW_frle_ProgramYearID               int
            declare @NEW_frle_FileRecordLayoutElementID   int
            -----
            set @NEW_frle_ProgramYearID               = @year_id_for_2010_1002 
            set @NEW_frle_FileRecordLayoutElementID = @new_FileRecordLayoutElementId 
            --------------------------------------------------------------------------
            fetch next from  cursor_DevColumn 
                into @old_frle_devColumnId , @old_frle_ProgramYearID
                   , @old_frle_FundingStreamTypeID,    @old_frle_ServiceTypeID
                   , @old_frle_FileRecordLayoutElementID,@old_frle_InsertSQL
                   , @old_frle_PositiveSQL,@old_frle_IsCorrectable,@old_frle_SequenceNumber
            while @@fetch_status=0
            begin
                insert into DEVColumn
                       ( ProgramYearID           ,ServiceTypeID           , FundingStreamTypeID          , FileRecordLayoutElementID          ,InsertSQL           ,PositiveSQL          , IsCorrectable                 ,SequenceNumber)
                values ( @NEW_frle_ProgramYearID , @old_frle_ServiceTypeID, @old_frle_FundingStreamTypeID, @NEW_frle_FileRecordLayoutElementID,@old_frle_InsertSQL ,@old_frle_PositiveSQL,    @old_frle_IsCorrectable, -42 )
                -----------------------------------------------------------
                fetch next from  cursor_DevColumn 
                    into @old_frle_devColumnId , @old_frle_ProgramYearID
                       , @old_frle_FundingStreamTypeID,    @old_frle_ServiceTypeID
                       , @old_frle_FileRecordLayoutElementID,@old_frle_InsertSQL
                       , @old_frle_PositiveSQL,@old_frle_IsCorrectable,@old_frle_SequenceNumber  
            end
            --         
            close cursor_DevColumn
            deallocate cursor_DevColumn
            -----------------------------------------------------------------------------------------
            --end cursor 3---------------------------------------------------------------------------
            -----------------------------------------------------------------------------------------
            
            -----------------------------------------------------------------------------------------
            ------------------ cursor 4 -------------------------------------------------------------
            -----------------------------------------------------------------------------------------
            print @old_FileRecordLayoutElementId
            declare @ECXFRLE_old_ErrorCheckID               int
            declare @ECXFRLE_old_FileRecordLayoutID         int
            declare @ECXFRLE_old_FileRecordLayoutElementID  int
            declare @ECXFRLE_old_PostingDate                datetime
            --------------------------------------------------------
            declare cursor_ErrorCheckXFileRecordLayoutElement cursor FOR 
               select  ErrorCheckID , FileRecordLayoutID , FileRecordLayoutElementID , PostingDate
                 from  ErrorCheckXFileRecordLayoutElement
                where  FileRecordLayoutElementID = @old_FileRecordLayoutElementId
            --------------------------------------------------------
            open cursor_ErrorCheckXFileRecordLayoutElement
                fetch next from cursor_ErrorCheckXFileRecordLayoutElement 
                           into @ECXFRLE_old_ErrorCheckID
                              , @ECXFRLE_old_FileRecordLayoutID 
                              , @ECXFRLE_old_FileRecordLayoutElementID 
                              , @ECXFRLE_old_PostingDate 
            while   @@fetch_status=0
            begin
                --
                insert into ErrorCheckXFileRecordLayoutElement 
                         (  ErrorCheckID              , FileRecordLayoutID              , FileRecordLayoutElementID          , PostingDate   )
                  values (  @ECXFRLE_old_ErrorCheckID , @NEW_filerecordlayoutelement_id , @NEW_frle_FileRecordLayoutElementID, getdate()     )
                ---------------------------------------------------------
                fetch next from cursor_ErrorCheckXFileRecordLayoutElement 
                           into @ECXFRLE_old_ErrorCheckID
                              , @ECXFRLE_old_FileRecordLayoutID 
                              , @ECXFRLE_old_FileRecordLayoutElementID 
                              , @ECXFRLE_old_PostingDate 
            end
            ---------------------------
            close cursor_ErrorCheckXFileRecordLayoutElement
            deallocate cursor_ErrorCheckXFileRecordLayoutElement
            -----------------------------------------------------------------------------------------
            ------------------ end cursor 4
            -----------------------------------------------------------------------------------------
            fetch next from cursor_FileRecordLayoutElement 
             into @FileRecordLayoutElementID,@DataFormatTypeID,@ColumnName,@DisplayName,
                  @Description,@CodeGroup,@CodeAbbrv,@ColumnLength,
                  @StartPosition ,@EndPosition,@SequenceNumber
        -- 
        end
        close cursor_FileRecordLayoutElement
        deallocate cursor_FileRecordLayoutElement
        -----------------------------------------------------------------------------------------
        -- end second cursor
        -----------------------------------------------------------------------------------------
        --
fetch next from cursor_FileRecordLayout 
      into  @x_FileRecordLayoutID ,
            @x_FileRecordLayoutTypeID ,
            @x_SystemID ,
            @x_ProgramYearID ,
            @x_PostingDate 




end
close cursor_FileRecordLayout
deallocate cursor_FileRecordLayout
--------------------------------------------
-- END 1st Cursor
--------------------------------------------

update devcolumn set sequenceNumber = devcolumnid where sequencenumber = -42

end
------------------------------------------------------------------
---------End of  Script only runs if PY2010 is NOT in DB ---------
------------------------------------------------------------------

go

USE WIALXSystem
go
UPDATE Code SET SortOrder = 1 WHERE CodeAbbrv = 'PY2003';
UPDATE Code SET SortOrder = 2 WHERE CodeAbbrv = 'PY2004';
UPDATE Code SET SortOrder = 3 WHERE CodeAbbrv = 'PY2005';
UPDATE Code SET SortOrder = 4 WHERE CodeAbbrv = 'PY2006';
UPDATE Code SET SortOrder = 5 WHERE CodeAbbrv = 'PY2007';
UPDATE Code SET SortOrder = 6 WHERE CodeAbbrv = 'PY2008';
UPDATE Code SET SortOrder = 7 WHERE CodeAbbrv = 'PY2009';
UPDATE Code SET SortOrder = 8 WHERE CodeAbbrv = 'PY2010';

go
---END HERE PY 2010------------------

USE LXDB
GO
--insert in devreport
DECLARE @tblLXDevColumns table
   ( FileRecordLayoutElementID int not null,
    ColumnName varchar(200) not null,
    IsCorrectable bit null)

DECLARE @LXDevReportId INT

INSERT INTO 
DEVReport(DEVReportName,ProgramYearID,Comment,LastModifiedDate)
SELECT 'LX Dev Sample for PY2010',CYR.CodeID,NULL,GETDATE()
FROM WIALXSystem..Code CYR WHERE CYR.CodeGroup='ProgramYear' AND CYR.CodeAbbrv='PY2010' 
AND NOT EXISTS(SELECT 'c' FROM DEVReport D 
                  INNER JOIN WIALXSystem..Code CYR 
                  ON D.ProgramYearID = CYR.CodeID AND CYR.CodeAbbrv='PY2010')
--get the DEVReportId

SELECT @LXDevReportId=DEVReportID FROM DEVReport D
         INNER JOIN WIALXSystem..Code CPY 
                  ON D.ProgramYearID = CPY.CodeID AND CPY.CodeAbbrv='PY2010'

-- grab IsCorrectable value for columnName for PY 2009
INSERT @tblLXDevColumns (FileRecordLayoutElementID,ColumnName,IsCorrectable)
SELECT DRFRLE.FileRecordLayoutElementID, FRLE.ColumnName,DRFRLE.IsCorrectable 
FROM LXDB..DEVReportxFileRecordLayoutElement DRFRLE
INNER JOIN LXDB..DEVReport DR ON 
 DRFRLE.DEVReportID = DR.DEVReportID
INNER JOIN WIALXSystem..Code CPYR
ON DR.ProgramYearID = CPYR.CodeID AND CPYR.CodeAbbrv='PY2009'
INNER JOIN WIALXSystem..FileRecordLayoutElement FRLE
ON DRFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
order by DRFRLE.FileRecordLayoutElementID

--insert in dbo.DEVReportxFileRecordLayoutElement
INSERT INTO LXDB.dbo.DEVReportxFileRecordLayoutElement
	SELECT @LXDevReportId,FRLE.FileRecordLayoutElementID,TC.IsCorrectable,GETDATE()
	FROM WIALXSystem..FileRecordLayoutElement FRLE
	INNER JOIN WIALXSystem..FileRecordLayout FRL
	ON FRLE.FileRecordLayoutID = FRL.FileRecordlayoutID
	INNER JOIN WIALXSystem..Code CTYPE 
	ON FRL.FileRecordLayoutTypeID = CTYPE.CodeID AND CTYPE.CodeGroup='FileRecordLayoutType' AND CTYPE.CodeAbbrv='DET'
	INNER JOIN WIALXSystem..Code CSYS
	ON FRL.SystemID = CSYS.CodeID AND CSYS.CodeGroup='System' AND CSYS.CodeAbbrv='LX'
	INNER JOIN WIALXSystem..Code CPYR
	 ON FRL.ProgramYearID = CPYR.CodeID AND CPYR.CodeAbbrv='PY2010'
	INNER JOIN @tblLXDevColumns TC
	ON FRLE.ColumnName = TC.ColumnName
	WHERE NOT EXISTS( SELECT 'c' FROM dbo.DEVReportxFileRecordLayoutElement DRFRLE
	                  INNER JOIN DEVReport DR ON 
	                  DRFRLE.DEVReportID = DR.DEVReportID
	                  INNER JOIN WIALXSystem..Code CPYR
	                  ON DR.ProgramYearID = CPYR.CodeID AND CPYR.CodeAbbrv='PY2010')
	and @LXDevReportId > 0
	ORDER BY FRLE.FileRecordLayoutElementID
GO



-----------------------------------------------------------------------------------------------------------------

USE WIALXSystem 
GO
------------------------------------------------------------------
-------------------- PY 2011 Option ------------------------------
------------------------------------------------------------------
------------------------------------------------------------------
------------- Script only runs if PY2011 is NOT in DB ------------
------------------------------------------------------------------
if not exists( select 'c' 
                 from  code
                where CodeGroup  = 'ProgramYear'
                  and CodeAbbrv  = 'PY2011'
             )
begin  ------------- Script only runs if PY2011 is NOT in DB ------------



----------------------------------------
-- softcode 1003 to year_id_for_2011_1003
----------------------------------------
DECLARE @year_id_for_2011_1003 int
----------------------------------------

----------------------- insert 2011 -------------------------------------------
if not exists( select 'c' 
                 from  code
                where CodeGroup  = 'ProgramYear'
                  and CodeAbbrv  = 'PY2011'
             )
begin
    insert into code 
           ( CodeGroup     , CodeAbbrv , CodeName  , ColumnName , SortOrder , LastModifiedDate )
    values ( 'ProgramYear' , 'PY2011'  , 'PY 2011' , 'NULL'     , '9'       , getdate() )
    SET @year_id_for_2011_1003 = @@identity
end


    ------------------------------------------------------------------------------------------------------
    ---- Add Exit Quarter Ranges for PY 2011
    ------------------------------------------------------------------------------------------------------
    INSERT INTO LXDB.dbo.ExitQuarterRange
              ( ExitQuarterAbbrv , ReportQuarter , ProgramYearID 
              , CalculationSetID , ExitStartDate , ExitEndDate     ,LastModifiedDate )
         SELECT ExitQuarterAbbrv , ReportQuarter , @year_id_for_2011_1003 
              , CalculationSetID , DATEADD(MONTH, 12,ExitStartDate) , DATEADD(MONTH, 12,ExitEndDate)     , getdate()
           FROM LXDB.dbo.ExitQuarterRange EQR
                INNER JOIN WIALXSYSTEM.dbo.Code C
                ON EQR.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2010' 
           
    INSERT INTO WIADB.dbo.ExitQuarterRange
              ( ExitQuarterAbbrv , ReportQuarter , ProgramYearID 
              , CalculationSetID , ExitStartDate , ExitEndDate     ,LastModifiedDate )
         SELECT ExitQuarterAbbrv , ReportQuarter , @year_id_for_2011_1003 
              , CalculationSetID , DATEADD(MONTH, 12,ExitStartDate) , DATEADD(MONTH, 12,ExitEndDate)     , getdate()
           FROM WIADB.dbo.ExitQuarterRange EQR
                INNER JOIN WIALXSYSTEM.dbo.Code C
                ON EQR.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2010' 
        

------------------------------------------------------------------------------------------------------
---- Add Program Year Ranges for PY 2011
---- Add Program Year Range X Metric Type     for     Program Year Ranges for PY 2011
------------------------------------------------------------------------------------------------------

DECLARE  @LXDB_PYR_ProgramYearRangeId  int, @LXDB_PYR_RangeTypeID  int, @LXDB_PYR_CohortID  int, @LXDB_PYR_LXGroupID            int, @LXDB_PYR_CalculationSetID  int,  @LXDB_PYR_ProgramYearID  int, @LXDB_PYR_QuarterPeriod  int, @LXDB_PYR_ProgramStartDate  smalldatetime, @LXDB_PYR_ProgramEndDate  smalldatetime, @LXDB_PYR_LastModifiedDate  datetime
DECLARE  @WIADB_PYR_ProgramYearRangeId int, @WIADB_PYR_RangeTypeID int, @WIADB_PYR_CohortID int, @WIADB_PYR_CumulativeIndicator int, @WIADB_PYR_CalculationSetID int,  @WIADB_PYR_ProgramYearID int, @WIADB_PYR_QuarterPeriod int, @WIADB_PYR_ProgramStartDate smalldatetime, @WIADB_PYR_ProgramEndDate smalldatetime, @WIADB_PYR_LastModifiedDate datetime
--
DECLARE  @old_LXDB_PYR_ProgramYearRangeID  int, @new_LXDB_PYR_ProgramYearRangeID  int
DECLARE  @old_WIADB_PYR_ProgramYearRangeID int, @new_WIADB_PYR_ProgramYearRangeID int
--
--
declare cursor_LXDB_dbo_ProgramYearRange   cursor for
         SELECT ProgramYearRangeID , RangeTypeID , CohortID , LXGroupID            , CalculationSetID , @year_id_for_2011_1003 , QuarterPeriod , DATEADD(MONTH, 12, ProgramStartDate) , DATEADD(MONTH, 12, ProgramEndDate ) , getdate() 
           FROM LXDB.dbo.ProgramYearRange PYR
           INNER JOIN WIALXSYSTEM.dbo.Code C
           ON PYR.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2010' 
          
--
declare cursor_WIADB_dbo_ProgramYearRange cursor for
         SELECT ProgramYearRangeID , RangeTypeID , CohortID , CumulativeIndicator  , CalculationSetID , @year_id_for_2011_1003 , QuarterPeriod , DATEADD(MONTH, 12, ProgramStartDate) , DATEADD(MONTH, 12, ProgramEndDate ) , getdate() 
           FROM WIADB.dbo.ProgramYearRange PYR1
           INNER JOIN WIALXSYSTEM.dbo.Code C
           ON PYR1.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2010' 
          
--
--
OPEN  cursor_LXDB_dbo_ProgramYearRange   
FETCH cursor_LXDB_dbo_ProgramYearRange   INTO  @LXDB_PYR_ProgramYearRangeID , @LXDB_PYR_RangeTypeID  , @LXDB_PYR_CohortID  , @LXDB_PYR_LXGroupID            , @LXDB_PYR_CalculationSetID  ,  @LXDB_PYR_ProgramYearID  , @LXDB_PYR_QuarterPeriod  , @LXDB_PYR_ProgramStartDate  , @LXDB_PYR_ProgramEndDate  , @LXDB_PYR_LastModifiedDate
WHILE @@fetch_status=0
BEGIN
--
    INSERT INTO LXDB.dbo.ProgramYearRange
                ( RangeTypeID           , CohortID            , LXGroupID                      , CalculationSetID            ,  ProgramYearID            ,  QuarterPeriod           , ProgramStartDate            , ProgramEndDate            , LastModifiedDate           )   
         VALUES ( @LXDB_PYR_RangeTypeID , @LXDB_PYR_CohortID  , @LXDB_PYR_LXGroupID            , @LXDB_PYR_CalculationSetID  ,  @LXDB_PYR_ProgramYearID  , @LXDB_PYR_QuarterPeriod  , @LXDB_PYR_ProgramStartDate  , @LXDB_PYR_ProgramEndDate  , @LXDB_PYR_LastModifiedDate  )
    SET     @new_LXDB_PYR_ProgramYearRangeID = @@identity
    SET     @old_LXDB_PYR_ProgramYearRangeID = @LXDB_PYR_ProgramYearRangeId
    -------
    INSERT INTO LXDB.dbo.ProgramYearRangeXMetricType
                (  ProgramYearRangeID               , MetricTypeID , LastModifiedDate )
          SELECT   @new_LXDB_PYR_ProgramYearRangeID , MetricTypeID , GetDate()  
            FROM LXDB.dbo.ProgramYearRangeXMetricType
           WHERE ProgramYearRangeID = @old_LXDB_PYR_ProgramYearRangeID
    --
    FETCH cursor_LXDB_dbo_ProgramYearRange   INTO  @LXDB_PYR_ProgramYearRangeID , @LXDB_PYR_RangeTypeID  , @LXDB_PYR_CohortID  , @LXDB_PYR_LXGroupID            , @LXDB_PYR_CalculationSetID  ,  @LXDB_PYR_ProgramYearID  , @LXDB_PYR_QuarterPeriod  , @LXDB_PYR_ProgramStartDate  , @LXDB_PYR_ProgramEndDate  , @LXDB_PYR_LastModifiedDate
END 
--
--
OPEN  cursor_WIADB_dbo_ProgramYearRange 
FETCH cursor_WIADB_dbo_ProgramYearRange  INTO   @WIADB_PYR_ProgramYearRangeID , @WIADB_PYR_RangeTypeID , @WIADB_PYR_CohortID , @WIADB_PYR_CumulativeIndicator , @WIADB_PYR_CalculationSetID ,  @WIADB_PYR_ProgramYearID , @WIADB_PYR_QuarterPeriod , @WIADB_PYR_ProgramStartDate , @WIADB_PYR_ProgramEndDate , @WIADB_PYR_LastModifiedDate
WHILE @@fetch_status=0
BEGIN
--
    INSERT INTO WIADB.dbo.ProgramYearRange
                ( RangeTypeID            , CohortID            , CumulativeIndicator            , CalculationSetID            ,  ProgramYearID            , QuarterPeriod            , ProgramStartDate            , ProgramEndDate            , LastModifiedDate            )
         VALUES ( @WIADB_PYR_RangeTypeID , @WIADB_PYR_CohortID , @WIADB_PYR_CumulativeIndicator , @WIADB_PYR_CalculationSetID ,  @WIADB_PYR_ProgramYearID , @WIADB_PYR_QuarterPeriod , @WIADB_PYR_ProgramStartDate , @WIADB_PYR_ProgramEndDate , @WIADB_PYR_LastModifiedDate )
    SET     @new_WIADB_PYR_ProgramYearRangeID = @@identity
    SET     @old_WIADB_PYR_ProgramYearRangeID = @WIADB_PYR_ProgramYearRangeID 
    -------
    INSERT INTO WIADB.dbo.ProgramYearRangeXMetricType
                (  ProgramYearRangeID               , MetricTypeID , LastModifiedDate )
          SELECT   @new_WIADB_PYR_ProgramYearRangeID , MetricTypeID , GetDate()  
            FROM WIADB.dbo.ProgramYearRangeXMetricType
           WHERE ProgramYearRangeID = @old_WIADB_PYR_ProgramYearRangeID
    --
    FETCH cursor_WIADB_dbo_ProgramYearRange  INTO   @WIADB_PYR_ProgramYearRangeID , @WIADB_PYR_RangeTypeID , @WIADB_PYR_CohortID , @WIADB_PYR_CumulativeIndicator , @WIADB_PYR_CalculationSetID ,  @WIADB_PYR_ProgramYearID , @WIADB_PYR_QuarterPeriod , @WIADB_PYR_ProgramStartDate , @WIADB_PYR_ProgramEndDate , @WIADB_PYR_LastModifiedDate
END 
------------
------------
DEALLOCATE cursor_LXDB_dbo_ProgramYearRange
DEALLOCATE cursor_WIADB_dbo_ProgramYearRange

----------------------------------------
-- PerformanceOutcomeGroupxProgramYear 
----------------------------------------
if not exists(select 'c' from  PerformanceOutcomeGroupxProgramYear where ProgramYearID = @year_id_for_2011_1003)
begin
    insert  PerformanceOutcomeGroupxProgramYear 
          select PerformanceOutcomeGroupID, @year_id_for_2011_1003,getdate()
           from  PerformanceOutcomeGroupxProgramYear POGxPY
           INNER JOIN WIALXSYSTEM.dbo.Code C
           ON POGxPY.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2010' 
         
end



----------------------------------------
--MetricTypexProgramYear
----------------------------------------
if not exists(select 'c' from  MetricTypexProgramYear where ProgramYearID = @year_id_for_2011_1003)
begin
    insert  MetricTypexProgramYear 
          select MetricTypeID, @year_id_for_2011_1003,getdate()
           from  MetricTypexProgramYear MTxPY
           INNER JOIN WIALXSYSTEM.dbo.Code C
           ON MTxPY.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2010' 
         
end


--------------------------------------------
-- 1st Cursor
--------------------------------------------
declare @x_FileRecordLayoutID int,@x_FileRecordLayoutTypeID int, @x_SystemID int, @x_ProgramYearID int,
    @x_PostingDate smalldatetime,@old_id int,@NEW_filerecordlayoutelement_id int,@old_FileRecordLayoutElementID int

declare @FileRecordLayoutElementID int,@FileRecordLayoutID int,@DataFormatTypeID int,@ColumnName varchar(500),
    @DisplayName varchar(500),@Description varchar(3000),@CodeGroup varchar(100),@CodeAbbrv varchar(50),
    @ColumnLength smallint,    @StartPosition smallint,@EndPosition smallint,@SequenceNumber smallint,
    @LastModifiedDate datetime


declare @var_count int
declare @new_FileRecordLayoutElementId int
declare @var_frle_identity int
declare @old_DevColumn_DevcolumnId int
declare @new_DevColumn_DevcolumnId int

DECLARE  cursor_FileRecordLayout cursor FOR SELECT  FileRecordLayoutID, FileRecordLayoutTypeID, SystemID, ProgramYearID, PostingDate FROM wialxsystem.dbo.FileRecordLayout FRL  INNER JOIN WIALXSYSTEM.dbo.Code C
           ON FRL.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2010' 

open cursor_FileRecordLayout
fetch next from cursor_FileRecordLayout into 
 @x_FileRecordLayoutID ,
 @x_FileRecordLayoutTypeID ,
 @x_SystemID ,
 @x_ProgramYearID ,
 @x_PostingDate 

while @@fetch_status=0
begin
     
SET @old_id = @x_FileRecordLayoutID
insert into FileRecordLayout (FileRecordLayoutTypeID,SystemID,ProgramYearID,PostingDate)
    values(@x_FileRecordLayoutTypeID,@x_SystemID,@year_id_for_2011_1003,getdate())
--
SET @NEW_filerecordlayoutelement_id = @@identity
        ----------------------------------------
        --second cursor here
        ----------------------------------------
        DECLARE  cursor_FileRecordLayoutElement cursor FOR 
            SELECT  FileRecordLayoutElementID,DataFormatTypeID,ColumnName,DisplayName,
                    [Description],CodeGroup,CodeAbbrv,ColumnLength,
                    StartPosition ,EndPosition,SequenceNumber
              FROM wialxsystem.dbo.FileRecordLayoutElement
             where FileRecordLayoutID= @x_FileRecordLayoutID
        
            open cursor_FileRecordLayoutElement
        fetch next 
              from cursor_FileRecordLayoutElement 
              into @FileRecordLayoutElementID,@DataFormatTypeID,@ColumnName,@DisplayName,
                   @Description,@CodeGroup,@CodeAbbrv,@ColumnLength,
                   @StartPosition ,@EndPosition,@SequenceNumber
                     
       
        while @@fetch_status=0
        begin
          
            insert into FileRecordLayoutElement 
                      ( FileRecordLayoutID              , DataFormatTypeID  , ColumnName  , DisplayName  , [Description] , CodeGroup , CodeAbbrv   , ColumnLength   , StartPosition  , EndPosition  , SequenceNumber , LastModifiedDate )
                values( @NEW_filerecordlayoutelement_id , @DataFormatTypeID , @ColumnName , @DisplayName , @Description  , @CodeGroup , @CodeAbbrv , @ColumnLength  , @StartPosition , @EndPosition , @SequenceNumber     , getdate()        )
            set   @new_FileRecordLayoutElementId = @@identity
            set   @old_FileRecordLayoutElementID = @FileRecordLayoutElementID 
            -----------------------------------------------------------------------------------------
            --cursor 3------------------------------------------------------------------------------
            -----------------------------------------------------------------------------------------
            declare cursor_DevColumn cursor FOR
            select devColumnId , ProgramYearID , FundingStreamTypeID,ServiceTypeID
                 , FileRecordLayoutElementID , InsertSQL ,  PositiveSQL   
                 , IsCorrectable  , SequenceNumber
              from dbo.DevColumn
             where FileRecordLayoutElementID = @old_FileRecordLayoutElementID    
            open cursor_DevColumn
            -----------------------------------------------------------------------------------------
            declare @old_frle_devColumnId                 int --new
            declare @old_frle_ProgramYearID               int
            declare @old_frle_FundingStreamTypeID         int
            declare @old_frle_ServiceTypeID               int
            declare @old_frle_FileRecordLayoutElementID   int
            declare @old_frle_InsertSQL                   varchar(3500)
            declare @old_frle_PositiveSQL                 varchar(4000)
            declare @old_frle_IsCorrectable               bit
            declare @old_frle_SequenceNumber              int    
            -------------------------------------
            ------ two columns will change
            -------------------------------------
            declare @NEW_frle_ProgramYearID               int
            declare @NEW_frle_FileRecordLayoutElementID   int
            -----
            set @NEW_frle_ProgramYearID               = @year_id_for_2011_1003 
            set @NEW_frle_FileRecordLayoutElementID = @new_FileRecordLayoutElementId 
            --------------------------------------------------------------------------
            fetch next from  cursor_DevColumn 
                into @old_frle_devColumnId , @old_frle_ProgramYearID
                   , @old_frle_FundingStreamTypeID,    @old_frle_ServiceTypeID
                   , @old_frle_FileRecordLayoutElementID,@old_frle_InsertSQL
                   , @old_frle_PositiveSQL,@old_frle_IsCorrectable,@old_frle_SequenceNumber
            while @@fetch_status=0
            begin
                insert into DEVColumn
                       ( ProgramYearID           ,ServiceTypeID           , FundingStreamTypeID          , FileRecordLayoutElementID          ,InsertSQL           ,PositiveSQL          , IsCorrectable                 ,SequenceNumber)
                values ( @NEW_frle_ProgramYearID , @old_frle_ServiceTypeID, @old_frle_FundingStreamTypeID, @NEW_frle_FileRecordLayoutElementID,@old_frle_InsertSQL ,@old_frle_PositiveSQL,    @old_frle_IsCorrectable, -42 )
                -----------------------------------------------------------
                fetch next from  cursor_DevColumn 
                    into @old_frle_devColumnId , @old_frle_ProgramYearID
                       , @old_frle_FundingStreamTypeID,    @old_frle_ServiceTypeID
                       , @old_frle_FileRecordLayoutElementID,@old_frle_InsertSQL
                       , @old_frle_PositiveSQL,@old_frle_IsCorrectable,@old_frle_SequenceNumber  
            end
            --         
            close cursor_DevColumn
            deallocate cursor_DevColumn
            -----------------------------------------------------------------------------------------
            --end cursor 3---------------------------------------------------------------------------
            -----------------------------------------------------------------------------------------
            
            -----------------------------------------------------------------------------------------
            ------------------ cursor 4 -------------------------------------------------------------
            -----------------------------------------------------------------------------------------
            print @old_FileRecordLayoutElementId
            declare @ECXFRLE_old_ErrorCheckID               int
            declare @ECXFRLE_old_FileRecordLayoutID         int
            declare @ECXFRLE_old_FileRecordLayoutElementID  int
            declare @ECXFRLE_old_PostingDate                datetime
            --------------------------------------------------------
            declare cursor_ErrorCheckXFileRecordLayoutElement cursor FOR 
               select  ErrorCheckID , FileRecordLayoutID , FileRecordLayoutElementID , PostingDate
                 from  ErrorCheckXFileRecordLayoutElement
                where  FileRecordLayoutElementID = @old_FileRecordLayoutElementId
            --------------------------------------------------------
            open cursor_ErrorCheckXFileRecordLayoutElement
                fetch next from cursor_ErrorCheckXFileRecordLayoutElement 
                           into @ECXFRLE_old_ErrorCheckID
                              , @ECXFRLE_old_FileRecordLayoutID 
                              , @ECXFRLE_old_FileRecordLayoutElementID 
                              , @ECXFRLE_old_PostingDate 
            while   @@fetch_status=0
            begin
                --
                insert into ErrorCheckXFileRecordLayoutElement 
                         (  ErrorCheckID              , FileRecordLayoutID              , FileRecordLayoutElementID          , PostingDate   )
                  values (  @ECXFRLE_old_ErrorCheckID , @NEW_filerecordlayoutelement_id , @NEW_frle_FileRecordLayoutElementID, getdate()     )
                ---------------------------------------------------------
                fetch next from cursor_ErrorCheckXFileRecordLayoutElement 
                           into @ECXFRLE_old_ErrorCheckID
                              , @ECXFRLE_old_FileRecordLayoutID 
                              , @ECXFRLE_old_FileRecordLayoutElementID 
                              , @ECXFRLE_old_PostingDate 
            end
            ---------------------------
            close cursor_ErrorCheckXFileRecordLayoutElement
            deallocate cursor_ErrorCheckXFileRecordLayoutElement
            -----------------------------------------------------------------------------------------
            ------------------ end cursor 4
            -----------------------------------------------------------------------------------------
            fetch next from cursor_FileRecordLayoutElement 
             into @FileRecordLayoutElementID,@DataFormatTypeID,@ColumnName,@DisplayName,
                  @Description,@CodeGroup,@CodeAbbrv,@ColumnLength,
                  @StartPosition ,@EndPosition,@SequenceNumber
        -- 
        end
        close cursor_FileRecordLayoutElement
        deallocate cursor_FileRecordLayoutElement
        -----------------------------------------------------------------------------------------
        -- end second cursor
        -----------------------------------------------------------------------------------------
        --
fetch next from cursor_FileRecordLayout 
      into  @x_FileRecordLayoutID ,
            @x_FileRecordLayoutTypeID ,
            @x_SystemID ,
            @x_ProgramYearID ,
            @x_PostingDate 




end
close cursor_FileRecordLayout
deallocate cursor_FileRecordLayout
--------------------------------------------
-- END 1st Cursor
--------------------------------------------

update devcolumn set sequenceNumber = devcolumnid where sequencenumber = -42

end
------------------------------------------------------------------
---------End of  Script only runs if PY2011 is NOT in DB ---------
------------------------------------------------------------------

go

USE WIALXSystem
go
UPDATE Code SET SortOrder = 1 WHERE CodeAbbrv = 'PY2003';
UPDATE Code SET SortOrder = 2 WHERE CodeAbbrv = 'PY2004';
UPDATE Code SET SortOrder = 3 WHERE CodeAbbrv = 'PY2005';
UPDATE Code SET SortOrder = 4 WHERE CodeAbbrv = 'PY2006';
UPDATE Code SET SortOrder = 5 WHERE CodeAbbrv = 'PY2007';
UPDATE Code SET SortOrder = 6 WHERE CodeAbbrv = 'PY2008';
UPDATE Code SET SortOrder = 7 WHERE CodeAbbrv = 'PY2009';
UPDATE Code SET SortOrder = 8 WHERE CodeAbbrv = 'PY2010';
UPDATE Code SET SortOrder = 9 WHERE CodeAbbrv = 'PY2011';



go
---END HERE PY 2011------------------

USE LXDB
GO
--insert in devreport
DECLARE @tblLXDevColumns table
   ( FileRecordLayoutElementID int not null,
    ColumnName varchar(200) not null,
    IsCorrectable bit null)

DECLARE @LXDevReportId INT

INSERT INTO 
DEVReport(DEVReportName,ProgramYearID,Comment,LastModifiedDate)
SELECT 'LX Dev Sample for PY2011',CYR.CodeID,NULL,GETDATE()
FROM WIALXSystem..Code CYR WHERE CYR.CodeGroup='ProgramYear' AND CYR.CodeAbbrv='PY2011' 
AND NOT EXISTS(SELECT 'c' FROM DEVReport D 
                  INNER JOIN WIALXSystem..Code CYR 
                  ON D.ProgramYearID = CYR.CodeID AND CYR.CodeAbbrv='PY2011')
--get the DEVReportId

SELECT @LXDevReportId=DEVReportID FROM DEVReport D
         INNER JOIN WIALXSystem..Code CPY 
                  ON D.ProgramYearID = CPY.CodeID AND CPY.CodeAbbrv='PY2011'

-- grab IsCorrectable value for columnName for PY 2010
INSERT @tblLXDevColumns (FileRecordLayoutElementID,ColumnName,IsCorrectable)
SELECT DRFRLE.FileRecordLayoutElementID, FRLE.ColumnName,DRFRLE.IsCorrectable 
FROM LXDB..DEVReportxFileRecordLayoutElement DRFRLE
INNER JOIN LXDB..DEVReport DR ON 
 DRFRLE.DEVReportID = DR.DEVReportID
INNER JOIN WIALXSystem..Code CPYR
ON DR.ProgramYearID = CPYR.CodeID AND CPYR.CodeAbbrv='PY2010'
INNER JOIN WIALXSystem..FileRecordLayoutElement FRLE
ON DRFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
order by DRFRLE.FileRecordLayoutElementID

--insert in dbo.DEVReportxFileRecordLayoutElement
INSERT INTO LXDB.dbo.DEVReportxFileRecordLayoutElement
	SELECT @LXDevReportId,FRLE.FileRecordLayoutElementID,TC.IsCorrectable,GETDATE()
	FROM WIALXSystem..FileRecordLayoutElement FRLE
	INNER JOIN WIALXSystem..FileRecordLayout FRL
	ON FRLE.FileRecordLayoutID = FRL.FileRecordlayoutID
	INNER JOIN WIALXSystem..Code CTYPE 
	ON FRL.FileRecordLayoutTypeID = CTYPE.CodeID AND CTYPE.CodeGroup='FileRecordLayoutType' AND CTYPE.CodeAbbrv='DET'
	INNER JOIN WIALXSystem..Code CSYS
	ON FRL.SystemID = CSYS.CodeID AND CSYS.CodeGroup='System' AND CSYS.CodeAbbrv='LX'
	INNER JOIN WIALXSystem..Code CPYR
	 ON FRL.ProgramYearID = CPYR.CodeID AND CPYR.CodeAbbrv='PY2011'
	INNER JOIN @tblLXDevColumns TC
	ON FRLE.ColumnName = TC.ColumnName
	WHERE NOT EXISTS( SELECT 'c' FROM dbo.DEVReportxFileRecordLayoutElement DRFRLE
	                  INNER JOIN DEVReport DR ON 
	                  DRFRLE.DEVReportID = DR.DEVReportID
	                  INNER JOIN WIALXSystem..Code CPYR
	                  ON DR.ProgramYearID = CPYR.CodeID AND CPYR.CodeAbbrv='PY2011')
	and @LXDevReportId > 0
	ORDER BY FRLE.FileRecordLayoutElementID
GO











------------------------------------------------------------------------------------------------------------------------
USE WIALXSystem 
GO
------------------------------------------------------------------
-------------------- PY 2012 Option ------------------------------
------------------------------------------------------------------
------------- Script only runs if PY2012 is NOT in DB ------------
------------------------------------------------------------------
if not exists( select 'c' 
                 from  code
                where CodeGroup  = 'ProgramYear'
                  and CodeAbbrv  = 'PY2012'
             )
begin  ------------- Script only runs if PY2012 is NOT in DB ------------



----------------------------------------
-- softcode 1004 to year_id_for_2012_1004
----------------------------------------
DECLARE @year_id_for_2012_1004 int
----------------------------------------

----------------------- insert 2012 -------------------------------------------
if not exists( select 'c' 
                 from  code
                where CodeGroup  = 'ProgramYear'
                  and CodeAbbrv  = 'PY2012'
             )
begin
    insert into code 
           ( CodeGroup     , CodeAbbrv , CodeName  , ColumnName , SortOrder , LastModifiedDate )
    values ( 'ProgramYear' , 'PY2012'  , 'PY 2012' , 'NULL'     , '10'       , getdate() )
    SET @year_id_for_2012_1004 = @@identity
end


    ------------------------------------------------------------------------------------------------------
    ---- Add Exit Quarter Ranges for PY 2012
    ------------------------------------------------------------------------------------------------------
    INSERT INTO LXDB.dbo.ExitQuarterRange
              ( ExitQuarterAbbrv , ReportQuarter , ProgramYearID 
              , CalculationSetID , ExitStartDate , ExitEndDate     ,LastModifiedDate )
         SELECT ExitQuarterAbbrv , ReportQuarter , @year_id_for_2012_1004 
              , CalculationSetID , DATEADD(MONTH, 12,ExitStartDate) , DATEADD(MONTH, 12,ExitEndDate)     , getdate()
           FROM LXDB.dbo.ExitQuarterRange EQR
                INNER JOIN WIALXSYSTEM.dbo.Code C
                ON EQR.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2011' 
           
    INSERT INTO WIADB.dbo.ExitQuarterRange
              ( ExitQuarterAbbrv , ReportQuarter , ProgramYearID 
              , CalculationSetID , ExitStartDate , ExitEndDate     ,LastModifiedDate )
         SELECT ExitQuarterAbbrv , ReportQuarter , @year_id_for_2012_1004 
              , CalculationSetID , DATEADD(MONTH, 12,ExitStartDate) , DATEADD(MONTH, 12,ExitEndDate)     , getdate()
           FROM WIADB.dbo.ExitQuarterRange EQR
                INNER JOIN WIALXSYSTEM.dbo.Code C
                ON EQR.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2011' 
        

------------------------------------------------------------------------------------------------------
---- Add Program Year Ranges for PY 2012
---- Add Program Year Range X Metric Type     for     Program Year Ranges for PY 2012
------------------------------------------------------------------------------------------------------

DECLARE  @LXDB_PYR_ProgramYearRangeId  int, @LXDB_PYR_RangeTypeID  int, @LXDB_PYR_CohortID  int, @LXDB_PYR_LXGroupID            int, @LXDB_PYR_CalculationSetID  int,  @LXDB_PYR_ProgramYearID  int, @LXDB_PYR_QuarterPeriod  int, @LXDB_PYR_ProgramStartDate  smalldatetime, @LXDB_PYR_ProgramEndDate  smalldatetime, @LXDB_PYR_LastModifiedDate  datetime
DECLARE  @WIADB_PYR_ProgramYearRangeId int, @WIADB_PYR_RangeTypeID int, @WIADB_PYR_CohortID int, @WIADB_PYR_CumulativeIndicator int, @WIADB_PYR_CalculationSetID int,  @WIADB_PYR_ProgramYearID int, @WIADB_PYR_QuarterPeriod int, @WIADB_PYR_ProgramStartDate smalldatetime, @WIADB_PYR_ProgramEndDate smalldatetime, @WIADB_PYR_LastModifiedDate datetime
--
DECLARE  @old_LXDB_PYR_ProgramYearRangeID  int, @new_LXDB_PYR_ProgramYearRangeID  int
DECLARE  @old_WIADB_PYR_ProgramYearRangeID int, @new_WIADB_PYR_ProgramYearRangeID int
--
--
declare cursor_LXDB_dbo_ProgramYearRange   cursor for
         SELECT ProgramYearRangeID , RangeTypeID , CohortID , LXGroupID            , CalculationSetID , @year_id_for_2012_1004 , QuarterPeriod , DATEADD(MONTH, 12, ProgramStartDate) , DATEADD(MONTH, 12, ProgramEndDate ) , getdate() 
           FROM LXDB.dbo.ProgramYearRange PYR
           INNER JOIN WIALXSYSTEM.dbo.Code C
           ON PYR.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2011' 
          
--
declare cursor_WIADB_dbo_ProgramYearRange cursor for
         SELECT ProgramYearRangeID , RangeTypeID , CohortID , CumulativeIndicator  , CalculationSetID , @year_id_for_2012_1004 , QuarterPeriod , DATEADD(MONTH, 12, ProgramStartDate) , DATEADD(MONTH, 12, ProgramEndDate ) , getdate() 
           FROM WIADB.dbo.ProgramYearRange PYR1
           INNER JOIN WIALXSYSTEM.dbo.Code C
           ON PYR1.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2011' 
          
--
--
OPEN  cursor_LXDB_dbo_ProgramYearRange   
FETCH cursor_LXDB_dbo_ProgramYearRange   INTO  @LXDB_PYR_ProgramYearRangeID , @LXDB_PYR_RangeTypeID  , @LXDB_PYR_CohortID  , @LXDB_PYR_LXGroupID            , @LXDB_PYR_CalculationSetID  ,  @LXDB_PYR_ProgramYearID  , @LXDB_PYR_QuarterPeriod  , @LXDB_PYR_ProgramStartDate  , @LXDB_PYR_ProgramEndDate  , @LXDB_PYR_LastModifiedDate
WHILE @@fetch_status=0
BEGIN
--
    INSERT INTO LXDB.dbo.ProgramYearRange
                ( RangeTypeID           , CohortID            , LXGroupID                      , CalculationSetID            ,  ProgramYearID            ,  QuarterPeriod           , ProgramStartDate            , ProgramEndDate            , LastModifiedDate           )   
         VALUES ( @LXDB_PYR_RangeTypeID , @LXDB_PYR_CohortID  , @LXDB_PYR_LXGroupID            , @LXDB_PYR_CalculationSetID  ,  @LXDB_PYR_ProgramYearID  , @LXDB_PYR_QuarterPeriod  , @LXDB_PYR_ProgramStartDate  , @LXDB_PYR_ProgramEndDate  , @LXDB_PYR_LastModifiedDate  )
    SET     @new_LXDB_PYR_ProgramYearRangeID = @@identity
    SET     @old_LXDB_PYR_ProgramYearRangeID = @LXDB_PYR_ProgramYearRangeId
    -------
    INSERT INTO LXDB.dbo.ProgramYearRangeXMetricType
                (  ProgramYearRangeID               , MetricTypeID , LastModifiedDate )
          SELECT   @new_LXDB_PYR_ProgramYearRangeID , MetricTypeID , GetDate()  
            FROM LXDB.dbo.ProgramYearRangeXMetricType
           WHERE ProgramYearRangeID = @old_LXDB_PYR_ProgramYearRangeID
    --
    FETCH cursor_LXDB_dbo_ProgramYearRange   INTO  @LXDB_PYR_ProgramYearRangeID , @LXDB_PYR_RangeTypeID  , @LXDB_PYR_CohortID  , @LXDB_PYR_LXGroupID            , @LXDB_PYR_CalculationSetID  ,  @LXDB_PYR_ProgramYearID  , @LXDB_PYR_QuarterPeriod  , @LXDB_PYR_ProgramStartDate  , @LXDB_PYR_ProgramEndDate  , @LXDB_PYR_LastModifiedDate
END 
--
--
OPEN  cursor_WIADB_dbo_ProgramYearRange 
FETCH cursor_WIADB_dbo_ProgramYearRange  INTO   @WIADB_PYR_ProgramYearRangeID , @WIADB_PYR_RangeTypeID , @WIADB_PYR_CohortID , @WIADB_PYR_CumulativeIndicator , @WIADB_PYR_CalculationSetID ,  @WIADB_PYR_ProgramYearID , @WIADB_PYR_QuarterPeriod , @WIADB_PYR_ProgramStartDate , @WIADB_PYR_ProgramEndDate , @WIADB_PYR_LastModifiedDate
WHILE @@fetch_status=0
BEGIN
--
    INSERT INTO WIADB.dbo.ProgramYearRange
                ( RangeTypeID            , CohortID            , CumulativeIndicator            , CalculationSetID            ,  ProgramYearID            , QuarterPeriod            , ProgramStartDate            , ProgramEndDate            , LastModifiedDate            )
         VALUES ( @WIADB_PYR_RangeTypeID , @WIADB_PYR_CohortID , @WIADB_PYR_CumulativeIndicator , @WIADB_PYR_CalculationSetID ,  @WIADB_PYR_ProgramYearID , @WIADB_PYR_QuarterPeriod , @WIADB_PYR_ProgramStartDate , @WIADB_PYR_ProgramEndDate , @WIADB_PYR_LastModifiedDate )
    SET     @new_WIADB_PYR_ProgramYearRangeID = @@identity
    SET     @old_WIADB_PYR_ProgramYearRangeID = @WIADB_PYR_ProgramYearRangeID 
    -------
    INSERT INTO WIADB.dbo.ProgramYearRangeXMetricType
                (  ProgramYearRangeID               , MetricTypeID , LastModifiedDate )
          SELECT   @new_WIADB_PYR_ProgramYearRangeID , MetricTypeID , GetDate()  
            FROM WIADB.dbo.ProgramYearRangeXMetricType
           WHERE ProgramYearRangeID = @old_WIADB_PYR_ProgramYearRangeID
    --
    FETCH cursor_WIADB_dbo_ProgramYearRange  INTO   @WIADB_PYR_ProgramYearRangeID , @WIADB_PYR_RangeTypeID , @WIADB_PYR_CohortID , @WIADB_PYR_CumulativeIndicator , @WIADB_PYR_CalculationSetID ,  @WIADB_PYR_ProgramYearID , @WIADB_PYR_QuarterPeriod , @WIADB_PYR_ProgramStartDate , @WIADB_PYR_ProgramEndDate , @WIADB_PYR_LastModifiedDate
END 
------------
------------
DEALLOCATE cursor_LXDB_dbo_ProgramYearRange
DEALLOCATE cursor_WIADB_dbo_ProgramYearRange

----------------------------------------
-- PerformanceOutcomeGroupxProgramYear 
----------------------------------------
if not exists(select 'c' from  PerformanceOutcomeGroupxProgramYear where ProgramYearID = @year_id_for_2012_1004)
begin
    insert  PerformanceOutcomeGroupxProgramYear 
          select PerformanceOutcomeGroupID, @year_id_for_2012_1004,getdate()
           from  PerformanceOutcomeGroupxProgramYear POGxPY
           INNER JOIN WIALXSYSTEM.dbo.Code C
           ON POGxPY.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2011' 
         
end



----------------------------------------
--MetricTypexProgramYear
----------------------------------------
if not exists(select 'c' from  MetricTypexProgramYear where ProgramYearID = @year_id_for_2012_1004)
begin
    insert  MetricTypexProgramYear 
          select MetricTypeID, @year_id_for_2012_1004,getdate()
           from  MetricTypexProgramYear MTxPY
           INNER JOIN WIALXSYSTEM.dbo.Code C
           ON MTxPY.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2011' 
         
end


--------------------------------------------
-- 1st Cursor
--------------------------------------------
declare @x_FileRecordLayoutID int,@x_FileRecordLayoutTypeID int, @x_SystemID int, @x_ProgramYearID int,
    @x_PostingDate smalldatetime,@old_id int,@NEW_filerecordlayoutelement_id int,@old_FileRecordLayoutElementID int

declare @FileRecordLayoutElementID int,@FileRecordLayoutID int,@DataFormatTypeID int,@ColumnName varchar(500),
    @DisplayName varchar(500),@Description varchar(3000),@CodeGroup varchar(100),@CodeAbbrv varchar(50),
    @ColumnLength smallint,    @StartPosition smallint,@EndPosition smallint,@SequenceNumber smallint,
    @LastModifiedDate datetime


declare @var_count int
declare @new_FileRecordLayoutElementId int
declare @var_frle_identity int
declare @old_DevColumn_DevcolumnId int
declare @new_DevColumn_DevcolumnId int

DECLARE  cursor_FileRecordLayout cursor FOR SELECT  FileRecordLayoutID, FileRecordLayoutTypeID, SystemID, ProgramYearID, PostingDate FROM wialxsystem.dbo.FileRecordLayout FRL  INNER JOIN WIALXSYSTEM.dbo.Code C
           ON FRL.ProgramYearID = C.CodeID AND C.CodeAbbrv='PY2011' 

open cursor_FileRecordLayout
fetch next from cursor_FileRecordLayout into 
 @x_FileRecordLayoutID ,
 @x_FileRecordLayoutTypeID ,
 @x_SystemID ,
 @x_ProgramYearID ,
 @x_PostingDate 

while @@fetch_status=0
begin
     
SET @old_id = @x_FileRecordLayoutID
insert into FileRecordLayout (FileRecordLayoutTypeID,SystemID,ProgramYearID,PostingDate)
    values(@x_FileRecordLayoutTypeID,@x_SystemID,@year_id_for_2012_1004,getdate())
--
SET @NEW_filerecordlayoutelement_id = @@identity
        ----------------------------------------
        --second cursor here
        ----------------------------------------
        DECLARE  cursor_FileRecordLayoutElement cursor FOR 
            SELECT  FileRecordLayoutElementID,DataFormatTypeID,ColumnName,DisplayName,
                    [Description],CodeGroup,CodeAbbrv,ColumnLength,
                    StartPosition ,EndPosition,SequenceNumber
              FROM wialxsystem.dbo.FileRecordLayoutElement
             where FileRecordLayoutID= @x_FileRecordLayoutID
        
            open cursor_FileRecordLayoutElement
        fetch next 
              from cursor_FileRecordLayoutElement 
              into @FileRecordLayoutElementID,@DataFormatTypeID,@ColumnName,@DisplayName,
                   @Description,@CodeGroup,@CodeAbbrv,@ColumnLength,
                   @StartPosition ,@EndPosition,@SequenceNumber
                     
       
        while @@fetch_status=0
        begin
          
            insert into FileRecordLayoutElement 
                      ( FileRecordLayoutID              , DataFormatTypeID  , ColumnName  , DisplayName  , [Description] , CodeGroup , CodeAbbrv   , ColumnLength   , StartPosition  , EndPosition  , SequenceNumber , LastModifiedDate )
                values( @NEW_filerecordlayoutelement_id , @DataFormatTypeID , @ColumnName , @DisplayName , @Description  , @CodeGroup , @CodeAbbrv , @ColumnLength  , @StartPosition , @EndPosition , @SequenceNumber     , getdate()        )
            set   @new_FileRecordLayoutElementId = @@identity
            set   @old_FileRecordLayoutElementID = @FileRecordLayoutElementID 
            -----------------------------------------------------------------------------------------
            --cursor 3------------------------------------------------------------------------------
            -----------------------------------------------------------------------------------------
            declare cursor_DevColumn cursor FOR
            select devColumnId , ProgramYearID , FundingStreamTypeID,ServiceTypeID
                 , FileRecordLayoutElementID , InsertSQL ,  PositiveSQL   
                 , IsCorrectable  , SequenceNumber
              from dbo.DevColumn
             where FileRecordLayoutElementID = @old_FileRecordLayoutElementID    
            open cursor_DevColumn
            -----------------------------------------------------------------------------------------
            declare @old_frle_devColumnId                 int --new
            declare @old_frle_ProgramYearID               int
            declare @old_frle_FundingStreamTypeID         int
            declare @old_frle_ServiceTypeID               int
            declare @old_frle_FileRecordLayoutElementID   int
            declare @old_frle_InsertSQL                   varchar(3500)
            declare @old_frle_PositiveSQL                 varchar(4000)
            declare @old_frle_IsCorrectable               bit
            declare @old_frle_SequenceNumber              int    
            -------------------------------------
            ------ two columns will change
            -------------------------------------
            declare @NEW_frle_ProgramYearID               int
            declare @NEW_frle_FileRecordLayoutElementID   int
            -----
            set @NEW_frle_ProgramYearID               = @year_id_for_2012_1004 
            set @NEW_frle_FileRecordLayoutElementID = @new_FileRecordLayoutElementId 
            --------------------------------------------------------------------------
            fetch next from  cursor_DevColumn 
                into @old_frle_devColumnId , @old_frle_ProgramYearID
                   , @old_frle_FundingStreamTypeID,    @old_frle_ServiceTypeID
                   , @old_frle_FileRecordLayoutElementID,@old_frle_InsertSQL
                   , @old_frle_PositiveSQL,@old_frle_IsCorrectable,@old_frle_SequenceNumber
            while @@fetch_status=0
            begin
                insert into DEVColumn
                       ( ProgramYearID           ,ServiceTypeID           , FundingStreamTypeID          , FileRecordLayoutElementID          ,InsertSQL           ,PositiveSQL          , IsCorrectable                 ,SequenceNumber)
                values ( @NEW_frle_ProgramYearID , @old_frle_ServiceTypeID, @old_frle_FundingStreamTypeID, @NEW_frle_FileRecordLayoutElementID,@old_frle_InsertSQL ,@old_frle_PositiveSQL,    @old_frle_IsCorrectable, -42 )
                -----------------------------------------------------------
                fetch next from  cursor_DevColumn 
                    into @old_frle_devColumnId , @old_frle_ProgramYearID
                       , @old_frle_FundingStreamTypeID,    @old_frle_ServiceTypeID
                       , @old_frle_FileRecordLayoutElementID,@old_frle_InsertSQL
                       , @old_frle_PositiveSQL,@old_frle_IsCorrectable,@old_frle_SequenceNumber  
            end
            --         
            close cursor_DevColumn
            deallocate cursor_DevColumn
            -----------------------------------------------------------------------------------------
            --end cursor 3---------------------------------------------------------------------------
            -----------------------------------------------------------------------------------------
            
            -----------------------------------------------------------------------------------------
            ------------------ cursor 4 -------------------------------------------------------------
            -----------------------------------------------------------------------------------------
            print @old_FileRecordLayoutElementId
            declare @ECXFRLE_old_ErrorCheckID               int
            declare @ECXFRLE_old_FileRecordLayoutID         int
            declare @ECXFRLE_old_FileRecordLayoutElementID  int
            declare @ECXFRLE_old_PostingDate                datetime
            --------------------------------------------------------
            declare cursor_ErrorCheckXFileRecordLayoutElement cursor FOR 
               select  ErrorCheckID , FileRecordLayoutID , FileRecordLayoutElementID , PostingDate
                 from  ErrorCheckXFileRecordLayoutElement
                where  FileRecordLayoutElementID = @old_FileRecordLayoutElementId
            --------------------------------------------------------
            open cursor_ErrorCheckXFileRecordLayoutElement
                fetch next from cursor_ErrorCheckXFileRecordLayoutElement 
                           into @ECXFRLE_old_ErrorCheckID
                              , @ECXFRLE_old_FileRecordLayoutID 
                              , @ECXFRLE_old_FileRecordLayoutElementID 
                              , @ECXFRLE_old_PostingDate 
            while   @@fetch_status=0
            begin
                --
                insert into ErrorCheckXFileRecordLayoutElement 
                         (  ErrorCheckID              , FileRecordLayoutID              , FileRecordLayoutElementID          , PostingDate   )
                  values (  @ECXFRLE_old_ErrorCheckID , @NEW_filerecordlayoutelement_id , @NEW_frle_FileRecordLayoutElementID, getdate()     )
                ---------------------------------------------------------
                fetch next from cursor_ErrorCheckXFileRecordLayoutElement 
                           into @ECXFRLE_old_ErrorCheckID
                              , @ECXFRLE_old_FileRecordLayoutID 
                              , @ECXFRLE_old_FileRecordLayoutElementID 
                              , @ECXFRLE_old_PostingDate 
            end
            ---------------------------
            close cursor_ErrorCheckXFileRecordLayoutElement
            deallocate cursor_ErrorCheckXFileRecordLayoutElement
            -----------------------------------------------------------------------------------------
            ------------------ end cursor 4
            -----------------------------------------------------------------------------------------
            fetch next from cursor_FileRecordLayoutElement 
             into @FileRecordLayoutElementID,@DataFormatTypeID,@ColumnName,@DisplayName,
                  @Description,@CodeGroup,@CodeAbbrv,@ColumnLength,
                  @StartPosition ,@EndPosition,@SequenceNumber
        -- 
        end
        close cursor_FileRecordLayoutElement
        deallocate cursor_FileRecordLayoutElement
        -----------------------------------------------------------------------------------------
        -- end second cursor
        -----------------------------------------------------------------------------------------
        --
fetch next from cursor_FileRecordLayout 
      into  @x_FileRecordLayoutID ,
            @x_FileRecordLayoutTypeID ,
            @x_SystemID ,
            @x_ProgramYearID ,
            @x_PostingDate 




end
close cursor_FileRecordLayout
deallocate cursor_FileRecordLayout
--------------------------------------------
-- END 1st Cursor
--------------------------------------------

update devcolumn set sequenceNumber = devcolumnid where sequencenumber = -42

end
------------------------------------------------------------------
---------End of  Script only runs if PY2012 is NOT in DB ---------
------------------------------------------------------------------

go

USE WIALXSystem
go
UPDATE Code SET SortOrder = 1 WHERE CodeAbbrv = 'PY2003';
UPDATE Code SET SortOrder = 2 WHERE CodeAbbrv = 'PY2004';
UPDATE Code SET SortOrder = 3 WHERE CodeAbbrv = 'PY2005';
UPDATE Code SET SortOrder = 4 WHERE CodeAbbrv = 'PY2006';
UPDATE Code SET SortOrder = 5 WHERE CodeAbbrv = 'PY2007';
UPDATE Code SET SortOrder = 6 WHERE CodeAbbrv = 'PY2008';
UPDATE Code SET SortOrder = 7 WHERE CodeAbbrv = 'PY2009';
UPDATE Code SET SortOrder = 8 WHERE CodeAbbrv = 'PY2010';
UPDATE Code SET SortOrder = 9 WHERE CodeAbbrv = 'PY2011';
UPDATE Code SET SortOrder = 10 WHERE CodeAbbrv = 'PY2012';
go
---END HERE PY 2012------------------

USE LXDB
GO
--insert in devreport
DECLARE @tblLXDevColumns table
   ( FileRecordLayoutElementID int not null,
    ColumnName varchar(200) not null,
    IsCorrectable bit null)

DECLARE @LXDevReportId INT

INSERT INTO 
DEVReport(DEVReportName,ProgramYearID,Comment,LastModifiedDate)
SELECT 'LX Dev Sample for PY2012',CYR.CodeID,NULL,GETDATE()
FROM WIALXSystem..Code CYR WHERE CYR.CodeGroup='ProgramYear' AND CYR.CodeAbbrv='PY2012' 
AND NOT EXISTS(SELECT 'c' FROM DEVReport D 
                  INNER JOIN WIALXSystem..Code CYR 
                  ON D.ProgramYearID = CYR.CodeID AND CYR.CodeAbbrv='PY2012')
--get the DEVReportId

SELECT @LXDevReportId=DEVReportID FROM DEVReport D
         INNER JOIN WIALXSystem..Code CPY 
                  ON D.ProgramYearID = CPY.CodeID AND CPY.CodeAbbrv='PY2012'

-- grab IsCorrectable value for columnName for PY 2011
INSERT @tblLXDevColumns (FileRecordLayoutElementID,ColumnName,IsCorrectable)
SELECT DRFRLE.FileRecordLayoutElementID, FRLE.ColumnName,DRFRLE.IsCorrectable 
FROM LXDB..DEVReportxFileRecordLayoutElement DRFRLE
INNER JOIN LXDB..DEVReport DR ON 
 DRFRLE.DEVReportID = DR.DEVReportID
INNER JOIN WIALXSystem..Code CPYR
ON DR.ProgramYearID = CPYR.CodeID AND CPYR.CodeAbbrv='PY2011'
INNER JOIN WIALXSystem..FileRecordLayoutElement FRLE
ON DRFRLE.FileRecordLayoutElementID = FRLE.FileRecordLayoutElementID
order by DRFRLE.FileRecordLayoutElementID

--insert in dbo.DEVReportxFileRecordLayoutElement
INSERT INTO LXDB.dbo.DEVReportxFileRecordLayoutElement
	SELECT @LXDevReportId,FRLE.FileRecordLayoutElementID,TC.IsCorrectable,GETDATE()
	FROM WIALXSystem..FileRecordLayoutElement FRLE
	INNER JOIN WIALXSystem..FileRecordLayout FRL
	ON FRLE.FileRecordLayoutID = FRL.FileRecordlayoutID
	INNER JOIN WIALXSystem..Code CTYPE 
	ON FRL.FileRecordLayoutTypeID = CTYPE.CodeID AND CTYPE.CodeGroup='FileRecordLayoutType' AND CTYPE.CodeAbbrv='DET'
	INNER JOIN WIALXSystem..Code CSYS
	ON FRL.SystemID = CSYS.CodeID AND CSYS.CodeGroup='System' AND CSYS.CodeAbbrv='LX'
	INNER JOIN WIALXSystem..Code CPYR
	 ON FRL.ProgramYearID = CPYR.CodeID AND CPYR.CodeAbbrv='PY2012'
	INNER JOIN @tblLXDevColumns TC
	ON FRLE.ColumnName = TC.ColumnName
	WHERE NOT EXISTS( SELECT 'c' FROM dbo.DEVReportxFileRecordLayoutElement DRFRLE
	                  INNER JOIN DEVReport DR ON 
	                  DRFRLE.DEVReportID = DR.DEVReportID
	                  INNER JOIN WIALXSystem..Code CPYR
	                  ON DR.ProgramYearID = CPYR.CodeID AND CPYR.CodeAbbrv='PY2012')
	and @LXDevReportId > 0
	ORDER BY FRLE.FileRecordLayoutElementID
GO



















